/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDynamicHashMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final Long internalMapLock = new Long(1L);
    protected final Map<K, DynamicEntry<V>> internalMap = new HashMap<K, DynamicEntry<V>>();

    protected void beforeAccessToInternalMap() {
    }

    protected void validateInternalMap() {
        Iterator<Map.Entry<K, DynamicEntry<V>>> it = this.internalMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, DynamicEntry<V>> e = it.next();
            DynamicEntry<V> entry = e.getValue();
            if (this.isEntryValid(entry)) continue;
            it.remove();
            this.removeNotify(entry);
        }
    }

    protected DynamicEntry<V> createDynamicEntry(V value) {
        return new DynamicEntry<V>(value);
    }

    protected void removeNotify(DynamicEntry<V> entry) {
    }

    protected abstract boolean isEntryValid(DynamicEntry<V> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        Long l = this.internalMapLock;
        synchronized (l) {
            this.beforeAccessToInternalMap();
            DynamicEntry<V> entry = this.internalMap.get(key);
            if (entry != null && this.isEntryValid(entry)) {
                return entry.getValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        Long l = this.internalMapLock;
        synchronized (l) {
            this.beforeAccessToInternalMap();
            DynamicEntry<V> entry = this.internalMap.put(key, this.createDynamicEntry(value));
            if (entry != null && this.isEntryValid(entry)) {
                return entry.getValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        Long l = this.internalMapLock;
        synchronized (l) {
            this.beforeAccessToInternalMap();
            for (Map.Entry<K, V> e : m.entrySet()) {
                this.internalMap.put(e.getKey(), this.createDynamicEntry(e.getValue()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V touch(K key) {
        Long l = this.internalMapLock;
        synchronized (l) {
            this.beforeAccessToInternalMap();
            DynamicEntry<V> entry = this.internalMap.get(key);
            if (entry != null) {
                entry.touch();
                return entry.getValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        Long l = this.internalMapLock;
        synchronized (l) {
            block4: {
                this.beforeAccessToInternalMap();
                DynamicEntry<V> entry = this.internalMap.get(key);
                if (entry == null || !this.isEntryValid(entry)) break block4;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean containsValue(Object value) {
        Long l = this.internalMapLock;
        synchronized (l) {
            Map.Entry<K, DynamicEntry<V>> e;
            V existingValue;
            this.validateInternalMap();
            Iterator<Map.Entry<K, DynamicEntry<V>>> iterator = this.internalMap.entrySet().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (value != (existingValue = (e = iterator.next()).getValue().getValue()) && (value == null || !value.equals(existingValue)));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        Long l = this.internalMapLock;
        synchronized (l) {
            this.beforeAccessToInternalMap();
            DynamicEntry<V> entry = this.internalMap.remove(key);
            if (entry != null && this.isEntryValid(entry)) {
                return entry.getValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Long l = this.internalMapLock;
        synchronized (l) {
            this.internalMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Long l = this.internalMapLock;
        synchronized (l) {
            this.validateInternalMap();
            return this.internalMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Long l = this.internalMapLock;
        synchronized (l) {
            this.validateInternalMap();
            return this.internalMap.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        Long l = this.internalMapLock;
        synchronized (l) {
            this.validateInternalMap();
            return new HashSet<K>(this.internalMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> values() {
        Long l = this.internalMapLock;
        synchronized (l) {
            this.validateInternalMap();
            ArrayList<V> list = new ArrayList<V>(this.internalMap.size());
            for (Map.Entry<K, DynamicEntry<V>> e : this.internalMap.entrySet()) {
                list.add(e.getValue().getValue());
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Long l = this.internalMapLock;
        synchronized (l) {
            this.validateInternalMap();
            HashMap<K, V> map = new HashMap<K, V>();
            for (Map.Entry<K, DynamicEntry<V>> e : this.internalMap.entrySet()) {
                map.put(e.getKey(), e.getValue().getValue());
            }
            return map.entrySet();
        }
    }

    public static class DynamicEntry<T> {
        private final T m_value;

        public DynamicEntry(T value) {
            this.m_value = value;
        }

        public void touch() {
        }

        public T getValue() {
            return this.m_value;
        }
    }
}

