/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.scout.commons.csv.ArrayConsumer;
import org.eclipse.scout.commons.csv.IDataConsumer;
import org.eclipse.scout.commons.exception.ProcessingException;

public class CsvHelper {
    public static final String IGNORED_COLUMN_NAME = "null";
    private Locale m_locale;
    private char m_separatorChar;
    private char m_textDelimiterChar;
    private String m_lineSeparator;
    private int m_colCount;
    private ArrayList<String> m_colNames;
    private ArrayList<String> m_colTypes;
    private ArrayList<Format> m_colFormat;
    private boolean[] m_ignoredColumns;

    public CsvHelper() {
        this(null, ',', '\"', "\n");
    }

    public CsvHelper(Locale locale, String separatorChar, String textDelimiterChar, String lineSeparator) {
        this(locale, separatorChar != null && separatorChar.length() > 0 ? separatorChar.charAt(0) : (char)'\u0000', textDelimiterChar != null && textDelimiterChar.length() > 0 ? textDelimiterChar.charAt(0) : (char)'\u0000', lineSeparator);
    }

    public CsvHelper(Locale locale, char separatorChar, char textDelimiterChar, String lineSeparator) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.m_locale = locale;
        this.m_separatorChar = (char)(separatorChar != 0 ? separatorChar : 59);
        this.m_textDelimiterChar = (char)(textDelimiterChar != 0 ? textDelimiterChar : 34);
        this.m_lineSeparator = lineSeparator != null ? lineSeparator : "\n";
        this.m_colFormat = new ArrayList();
    }

    public List<String> getColumnNames() {
        return Collections.unmodifiableList(this.m_colNames);
    }

    public void setColumnNames(List<String> list) {
        this.m_colNames = new ArrayList<String>(list);
        this.m_colCount = Math.max(this.m_colCount, this.m_colNames.size());
        this.m_ignoredColumns = new boolean[this.m_colNames.size()];
        int i = 0;
        while (i < this.m_colNames.size()) {
            this.m_ignoredColumns[i] = IGNORED_COLUMN_NAME.equals(this.m_colNames.get(i));
            ++i;
        }
    }

    public List<String> getColumnTypes() {
        return Collections.unmodifiableList(this.m_colTypes);
    }

    public void setColumnTypes(List<String> list) {
        this.m_colTypes = new ArrayList(list.size());
        this.m_colFormat = new ArrayList(list.size());
        for (String s : list) {
            String sLow = s != null ? s.toLowerCase() : null;
            Format f = null;
            if (s == null) {
                f = null;
            } else if (sLow.equals("string")) {
                f = null;
            } else if (sLow.startsWith("integer")) {
                if (s.length() >= 8) {
                    f = new DecimalFormat(s.substring(8), new DecimalFormatSymbols(this.m_locale));
                    ((DecimalFormat)f).setParseIntegerOnly(true);
                } else {
                    f = NumberFormat.getIntegerInstance(this.m_locale);
                }
            } else if (sLow.startsWith("float")) {
                f = s.length() >= 6 ? new DecimalFormat(s.substring(6), new DecimalFormatSymbols(this.m_locale)) : NumberFormat.getNumberInstance(this.m_locale);
            } else if (sLow.startsWith("date")) {
                f = s.length() >= 5 ? new SimpleDateFormat(s.substring(5), this.m_locale) : DateFormat.getDateInstance(3, this.m_locale);
            } else {
                s = "string";
                f = null;
            }
            this.m_colTypes.add(s);
            this.m_colFormat.add(f);
        }
        this.m_colCount = Math.max(this.m_colCount, this.m_colTypes.size());
    }

    public Object[][] importData(Reader reader, int headerRowCount, List<String> columnTypes, int rowCount) throws ProcessingException {
        try {
            if (columnTypes != null) {
                this.setColumnTypes(columnTypes);
            }
            ArrayConsumer cons = new ArrayConsumer();
            this.importData(cons, reader, false, false, headerRowCount, rowCount);
            Object[][] result = cons.getData();
            return result;
        }
        catch (Exception e) {
            throw new ProcessingException(e.getMessage(), e);
        }
    }

    public void importData(IDataConsumer dataConsumer, Reader reader, boolean readNameHeader, boolean readTypeHeader, int headerRowCount) throws ProcessingException {
        this.importData(dataConsumer, reader, readNameHeader, readTypeHeader, headerRowCount, -1);
    }

    public void importData(IDataConsumer dataConsumer, Reader reader, boolean readNameHeader, boolean readTypeHeader, int headerRowCount, int rowCount) throws ProcessingException {
        this.importData(dataConsumer, reader, readNameHeader, readTypeHeader, headerRowCount, rowCount, false);
    }

    /*
     * Unable to fully structure code
     */
    public void importData(IDataConsumer dataConsumer, Reader reader, boolean readNameHeader, boolean readTypeHeader, int headerRowCount, int rowCount, boolean allowVariableColumnCount) throws ProcessingException {
        line = null;
        cell = null;
        colIndex = 0;
        lineNr = -1;
        if (rowCount < 0) {
            rowCount = 0x7FFFFFFF;
        }
        try {
            if (readNameHeader) {
                list = this.importRow(reader);
                if (list != null) {
                    this.setColumnNames(list);
                }
                --headerRowCount;
            }
            if (readTypeHeader) {
                list = this.importRow(reader);
                if (list != null) {
                    this.setColumnTypes(list);
                }
                --headerRowCount;
            }
            while (headerRowCount > 0) {
                this.importRow(reader);
                --headerRowCount;
            }
            lineNr = 1;
            ** GOTO lbl39
            {
                cellList.add(cellList.size(), null);
                do {
                    if (allowVariableColumnCount && cellList.size() < this.getColumnNames().size()) continue block3;
                    objList = new ArrayList<Object>(cellList.size());
                    colIndex = 0;
                    while (colIndex < cellList.size()) {
                        if (this.m_ignoredColumns == null || this.m_ignoredColumns.length < colIndex || !this.m_ignoredColumns[colIndex]) {
                            cell = cellList.get(colIndex);
                            objList.add(this.importCell(cell, this.getColumnFormat(colIndex)));
                        }
                        ++colIndex;
                    }
                    dataConsumer.processRow(lineNr, objList);
                    ++lineNr;
lbl39:
                    // 2 sources

                } while ((cellList = this.importRow(reader)) != null && lineNr <= rowCount);
            }
        }
        catch (Exception v0) {
            throw new ProcessingException("line=" + line + " colIndex=" + colIndex + " cell=" + cell);
        }
    }

    public void exportData(Object[][] data, File f, String encoding, List<String> columnNames, boolean writeColumnNames, List<String> columnTypes, boolean writeColumnTypes) throws ProcessingException {
        try {
            if (encoding == null) {
                encoding = "UTF-8";
            }
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(f), encoding);
            try {
                this.exportData(data, writer, columnNames, writeColumnNames, columnTypes, writeColumnTypes);
            }
            catch (Throwable throwable) {
                try {
                    ((Writer)writer).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((Writer)writer).close();
            }
            catch (IOException iOException) {}
        }
        catch (UnsupportedEncodingException e) {
            throw new ProcessingException(f.getAbsolutePath(), e);
        }
        catch (FileNotFoundException e) {
            throw new ProcessingException(f.getAbsolutePath(), e);
        }
    }

    public void exportData(Object[][] data, Writer writer, List<String> columnNames, boolean writeColumnNames, List<String> columnTypes, boolean writeColumnTypes) throws ProcessingException {
        try {
            if (columnNames != null) {
                this.setColumnNames(columnNames);
            }
            if (columnTypes != null) {
                this.setColumnTypes(columnTypes);
            }
            this.exportHeaderRows(writer, writeColumnNames, writeColumnTypes);
            Object[][] objectArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] row = objectArray[n2];
                this.exportDataRow(row, writer, false);
                ++n2;
            }
        }
        catch (Throwable throwable) {
            try {
                writer.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            writer.close();
        }
        catch (Exception exception) {}
    }

    public void exportHeaderRows(Writer writer, boolean writeNames, boolean writeTypes) throws ProcessingException {
        String line = null;
        int colIndex = 0;
        Object val = null;
        String cell = null;
        try {
            if (writeNames) {
                line = this.exportRow(this.m_colNames);
                writer.write(line);
                writer.write(this.m_lineSeparator);
            }
            if (writeTypes) {
                line = this.exportRow(this.m_colTypes);
                writer.write(line);
                writer.write(this.m_lineSeparator);
            }
            new ArrayList();
        }
        catch (IOException iOException) {
            throw new ProcessingException("line=" + line + " colIndex=" + colIndex + " value=" + val + " cell=" + cell);
        }
    }

    public void exportDataRow(Object[] row, Writer writer) throws ProcessingException {
        this.exportDataRow(row, writer, true);
    }

    public void exportDataRow(Object[] row, Writer writer, boolean closeWriter) throws ProcessingException {
        String line = null;
        Object val = null;
        String cell = null;
        try {
            try {
                ArrayList<String> rowStrings = new ArrayList<String>();
                rowStrings.clear();
                int i = 0;
                while (i < row.length) {
                    val = row[i];
                    cell = this.exportCell(val, this.getColumnFormat(i));
                    rowStrings.add(cell);
                    ++i;
                }
                line = this.exportRow(rowStrings);
                writer.write(line);
                writer.write(this.m_lineSeparator);
            }
            catch (IOException iOException) {
                throw new ProcessingException("line=" + Arrays.asList(row));
            }
        }
        catch (Throwable throwable) {
            if (closeWriter) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (closeWriter) {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    private Format getColumnFormat(int colIndex) {
        if (colIndex < this.m_colFormat.size()) {
            return this.m_colFormat.get(colIndex);
        }
        return null;
    }

    private ArrayList<String> importRow(Reader reader) throws IOException {
        ArrayList<String> cellList = new ArrayList<String>(Math.max(this.m_colCount, 2));
        boolean inString = false;
        StringBuffer curBuf = new StringBuffer();
        int ch = reader.read();
        while (ch == 10 || ch == 13) {
            ch = reader.read();
        }
        if (ch < 0) {
            return null;
        }
        while (true) {
            if (ch >= 0 && inString) {
                if (ch == this.m_textDelimiterChar) {
                    inString = false;
                }
                curBuf.append((char)ch);
            } else if (ch == this.m_separatorChar || ch < 0 || ch == 10 || ch == 13) {
                String token = curBuf.toString();
                curBuf.setLength(0);
                int tokenLen = token.length();
                if (tokenLen > 0) {
                    if (token.charAt(0) == this.m_textDelimiterChar && token.charAt(tokenLen - 1) == this.m_textDelimiterChar) {
                        token = token.substring(1, tokenLen - 1);
                    }
                    if (token.length() == 0) {
                        token = null;
                    }
                } else {
                    token = null;
                }
                token = this.decodeText(token);
                cellList.add(token);
                if (ch < 0 || ch == 10 || ch == 13) {
                    break;
                }
            } else if (ch == this.m_textDelimiterChar) {
                inString = true;
                curBuf.append((char)ch);
            } else {
                curBuf.append((char)ch);
            }
            ch = reader.read();
        }
        if (cellList.size() == 0 && ch < 0) {
            cellList = null;
        }
        return cellList;
    }

    private String exportRow(Collection<String> strings) {
        StringBuffer buf = new StringBuffer();
        if (strings != null) {
            Iterator<String> it = strings.iterator();
            while (it.hasNext()) {
                buf.append(this.encodeText(it.next()));
                if (!it.hasNext() || this.m_separatorChar == '\u0000') continue;
                buf.append(this.m_separatorChar);
            }
        }
        return buf.toString();
    }

    private Object importCell(String text, Format f) throws ProcessingException {
        if (text != null && f != null) {
            try {
                text = text.trim();
                return f.parseObject(text);
            }
            catch (ParseException parseException) {
                throw new ProcessingException("text=" + text + " format=" + f);
            }
        }
        return text;
    }

    private String exportCell(Object o, Format f) {
        if (f != null && o != null) {
            return f.format(o);
        }
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    private String encodeText(String text) {
        if (this.m_textDelimiterChar != '\u0000' && text != null && ((text = this.stringReplace(text, "" + this.m_textDelimiterChar, "" + this.m_textDelimiterChar + this.m_textDelimiterChar)).indexOf(this.m_separatorChar) >= 0 || text.indexOf(this.m_textDelimiterChar) >= 0)) {
            text = String.valueOf(this.m_textDelimiterChar) + text + this.m_textDelimiterChar;
        }
        return text;
    }

    private String decodeText(String text) {
        if (text != null && text.length() > 0 && this.m_textDelimiterChar != '\u0000') {
            if (text.charAt(0) == this.m_textDelimiterChar && text.charAt(text.length() - 1) == this.m_textDelimiterChar) {
                text = text.substring(1, text.length() - 1);
            }
            text = this.stringReplace(text, "" + this.m_textDelimiterChar + this.m_textDelimiterChar, "" + this.m_textDelimiterChar);
        }
        return text;
    }

    private String stringReplace(String s, String sOld, String sNew) {
        String string = sNew = sNew == null ? "" : sNew;
        if (s == null || sOld == null) {
            return s;
        }
        StringBuffer buf = new StringBuffer();
        int oldLen = sOld.length();
        int pos = 0;
        int i = s.indexOf(sOld);
        while (i >= 0) {
            buf.append(s.substring(pos, i));
            buf.append(sNew);
            pos = i + oldLen;
            i = s.indexOf(sOld, pos);
        }
        buf.append(s.substring(pos));
        return buf.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getColumnNames(File f) throws ProcessingException {
        List<String> list;
        FileReader r = null;
        try {
            List<String> result;
            r = new FileReader(f);
            list = result = this.getCurrentRow(r);
            if (r == null) return list;
        }
        catch (IOException e) {
            try {
                throw new ProcessingException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                if (r == null) throw throwable;
                try {
                    ((Reader)r).close();
                    throw throwable;
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
        }
        try {
            ((Reader)r).close();
            return list;
        }
        catch (Throwable throwable) {}
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getCurrentRow(Reader reader) throws ProcessingException {
        ArrayList<String> arrayList;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(reader);
            arrayList = this.importRow(bufferedReader);
            if (bufferedReader == null) return arrayList;
        }
        catch (Exception exception) {
            try {
                throw new ProcessingException("reading header row");
            }
            catch (Throwable throwable) {
                if (bufferedReader == null) throw throwable;
                try {
                    bufferedReader.close();
                    throw throwable;
                }
                catch (Exception exception2) {}
                throw throwable;
            }
        }
        try {
            bufferedReader.close();
            return arrayList;
        }
        catch (Exception exception) {}
        return arrayList;
    }
}

