/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.servicetunnel;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.eclipse.scout.commons.VerboseUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.servicetunnel.IServiceTunnel;

public class ServiceTunnelInvocationHandler
implements InvocationHandler {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ServiceTunnelInvocationHandler.class);
    private final Class<?> m_serviceInterfaceClass;
    private final IServiceTunnel m_tunnel;

    public ServiceTunnelInvocationHandler(Class<?> serviceInterfaceClass, IServiceTunnel tunnel) {
        if (serviceInterfaceClass == null) {
            throw new IllegalArgumentException("serviceInterfaceClass must not be null");
        }
        if (tunnel == null) {
            throw new IllegalArgumentException("tunnel must not be null");
        }
        this.m_serviceInterfaceClass = serviceInterfaceClass;
        this.m_tunnel = tunnel;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Object.class.isAssignableFrom(method.getDeclaringClass())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Soap call to " + this.m_serviceInterfaceClass.getName() + "." + method.getName() + "(" + VerboseUtility.dumpObjects((Object[])args) + ")");
            }
            return this.m_tunnel.invokeService(this.m_serviceInterfaceClass, method, args);
        }
        return this.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke((Object)this, args);
    }
}

