/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.outline;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.desktop.DesktopEvent;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListener;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.form.fields.treefield.AbstractTreeField;

public abstract class AbstractOutlineTreeField
extends AbstractTreeField {
    private DesktopListener m_desktopListener;
    private PropertyChangeListener m_treePropertyListener;

    @Override
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredLabelVisible() {
        return false;
    }

    @Override
    protected void execInitField() throws ProcessingException {
        this.m_desktopListener = new DesktopListener(){

            @Override
            public void desktopChanged(DesktopEvent e) {
                switch (e.getType()) {
                    case 200: {
                        AbstractOutlineTreeField.this.installOutline(e.getOutline());
                    }
                }
            }
        };
        this.m_treePropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("title")) {
                    AbstractOutlineTreeField.this.setLabel((String)e.getNewValue());
                }
            }
        };
        IDesktop desktop = ClientSyncJob.getCurrentSession().getDesktop();
        desktop.addDesktopListener(this.m_desktopListener);
        this.installOutline(desktop.getOutline());
    }

    @Override
    protected void execDisposeField() throws ProcessingException {
        ClientSyncJob.getCurrentSession().getDesktop().removeDesktopListener(this.m_desktopListener);
        this.m_desktopListener = null;
    }

    private void installOutline(IOutline outline) {
        if (this.getTree() == outline) {
            return;
        }
        if (this.getTree() != null) {
            this.getTree().removePropertyChangeListener(this.m_treePropertyListener);
            this.setLabel(null);
        }
        this.setTree(outline, true);
        if (this.getTree() != null) {
            this.getTree().addPropertyChangeListener(this.m_treePropertyListener);
            this.setLabel(this.getTree().getTitle());
        }
    }
}

