/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.composer;

import java.util.ArrayList;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerField;
import org.eclipse.scout.rt.shared.data.model.AbstractDataModel;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelEntity;

public class ComposerFieldDataModel
extends AbstractDataModel {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ComposerFieldDataModel.class);
    private final IComposerField m_field;

    public ComposerFieldDataModel(IComposerField field) {
        super(false);
        this.m_field = field;
        this.callInitializer();
    }

    protected IDataModelAttribute[] createAttributes() {
        ArrayList<IDataModelAttribute> attributes = new ArrayList<IDataModelAttribute>();
        Class[] all = ConfigurationUtility.getDeclaredPublicClasses(this.m_field.getClass());
        Class[] classArray = ConfigurationUtility.sortFilteredClassesByOrderAnnotation((Class[])all, IDataModelAttribute.class);
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            try {
                IDataModelAttribute a = (IDataModelAttribute)ConfigurationUtility.newInnerInstance((Object)this.m_field, (Class)c);
                attributes.add(a);
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
            ++n2;
        }
        return attributes.toArray(new IDataModelAttribute[attributes.size()]);
    }

    protected IDataModelEntity[] createEntities() {
        ArrayList<IDataModelEntity> entities = new ArrayList<IDataModelEntity>();
        Class[] all = ConfigurationUtility.getDeclaredPublicClasses(this.m_field.getClass());
        Class[] classArray = ConfigurationUtility.sortFilteredClassesByOrderAnnotation((Class[])all, IDataModelEntity.class);
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            try {
                IDataModelEntity e = (IDataModelEntity)ConfigurationUtility.newInnerInstance((Object)this.m_field, (Class)c);
                entities.add(e);
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
            ++n2;
        }
        return entities.toArray(new IDataModelEntity[entities.size()]);
    }
}

