/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.composer.node;

import java.util.Collection;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerField;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.AddEntityMenu;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.EntityNode;
import org.eclipse.scout.rt.shared.data.model.IDataModelEntity;

public abstract class AbstractComposerNode
extends AbstractTreeNode {
    private final IComposerField m_composerField;

    public AbstractComposerNode(IComposerField composerField, boolean callInitializer) {
        super(false);
        this.m_composerField = composerField;
        if (callInitializer) {
            this.callInitializer();
        }
    }

    @Override
    public boolean isLeaf() {
        return this.getChildNodeCount() == 0;
    }

    protected ITreeNode getSiblingBefore() {
        int index;
        if (this.getTree() != null && this.getParentNode() != null && (index = this.getChildNodeIndex()) - 1 >= 0) {
            return this.getParentNode().getChildNode(index - 1);
        }
        return null;
    }

    protected ITreeNode getSiblingAfter() {
        int count;
        int index;
        if (this.getTree() != null && this.getParentNode() != null && (index = this.getChildNodeIndex()) + 1 < (count = this.getParentNode().getChildNodeCount())) {
            return this.getParentNode().getChildNode(index + 1);
        }
        return null;
    }

    public IComposerField getComposerField() {
        return this.m_composerField;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.getCell().getText() + "]";
    }

    protected void attachAddEntityMenus(Collection<IMenu> menus) {
        EntityNode eNode = null;
        ITreeNode n = this;
        while (n != null) {
            if (n instanceof EntityNode) {
                eNode = (EntityNode)n;
                break;
            }
            n = n.getParentNode();
        }
        IDataModelEntity[] childEntitites = eNode != null ? eNode.getEntity().getEntities() : this.getComposerField().getEntities();
        IDataModelEntity[] iDataModelEntityArray = childEntitites;
        int n2 = childEntitites.length;
        int n3 = 0;
        while (n3 < n2) {
            IDataModelEntity e = iDataModelEntityArray[n3];
            menus.add(new AddEntityMenu(this.getComposerField(), this, e));
            ++n3;
        }
    }
}

