/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.doublefield;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.decimalfield.AbstractDecimalField;
import org.eclipse.scout.rt.client.ui.form.fields.doublefield.IDoubleField;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.form.ValidationRule;

public abstract class AbstractDoubleField
extends AbstractDecimalField<Double>
implements IDoubleField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractDoubleField.class);

    @ConfigProperty(value="DOUBLE")
    @Order(value=300.0)
    @ConfigPropertyValue(value="null")
    @ValidationRule(value="minValue")
    protected Double getConfiguredMinimumValue() {
        return null;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=310.0)
    @ConfigPropertyValue(value="null")
    @ValidationRule(value="maxValue")
    protected Double getConfiguredMaximumValue() {
        return null;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setMinValue(this.getConfiguredMinimumValue());
        this.setMaxValue(this.getConfiguredMaximumValue());
    }

    @Override
    protected Double parseValueInternal(String text) throws ProcessingException {
        Double retVal = null;
        if ((text = text == null ? "" : text.trim()).length() > 0) {
            NumberFormat numberFormat = this.createNumberFormat();
            if (this.isPercent()) {
                if (text.endsWith("%")) {
                    text = StringUtility.trim((String)text.substring(0, text.length() - 1));
                }
                String suffix = "%";
                if (numberFormat instanceof DecimalFormat) {
                    suffix = ((DecimalFormat)numberFormat).getPositiveSuffix();
                }
                text = StringUtility.concatenateTokens((String[])new String[]{text, suffix});
            }
            ParsePosition p = new ParsePosition(0);
            Number n = numberFormat.parse(text, p);
            if (p.getErrorIndex() >= 0 || p.getIndex() != text.length()) {
                throw new ProcessingException(ScoutTexts.get((String)"InvalidNumberMessageX", (String[])new String[]{text}));
            }
            NumberFormat fmt = NumberFormat.getNumberInstance();
            int npc = ("" + Math.abs(this.getMultiplier())).length() - 1;
            fmt.setMaximumFractionDigits(this.getFractionDigits() + npc);
            p = new ParsePosition(0);
            String fmtText = fmt.format(n.doubleValue());
            retVal = new Double(fmt.parse(fmtText, p).doubleValue());
            if (p.getErrorIndex() >= 0 || p.getIndex() != fmtText.length()) {
                throw new ProcessingException(ScoutTexts.get((String)"InvalidNumberMessageX", (String[])new String[]{fmtText}));
            }
        }
        return retVal;
    }
}

