/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.lookup;

import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.services.lookup.BatchSplit;
import org.eclipse.scout.rt.client.servicetunnel.ServiceTunnelUtility;
import org.eclipse.scout.rt.shared.services.lookup.BatchLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.IBatchLookupService;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.eclipse.scout.service.AbstractService;

@Priority(value=-3.0f)
public class BatchLookupServiceClientProxy
extends AbstractService
implements IBatchLookupService {
    public LookupRow[][] getBatchDataByKey(BatchLookupCall batch) throws ProcessingException {
        BatchSplit split = new BatchSplit(batch);
        if (split.getLocalCallCount() > 0) {
            LookupCall[] calls = split.getLocalCalls();
            LookupRow[][] resultArray = new LookupRow[calls.length][];
            int i = 0;
            while (i < calls.length) {
                resultArray[i] = calls[i].getDataByKey();
                ++i;
            }
            split.setLocalResults(resultArray);
        }
        if (split.getRemoteCallCount() > 0) {
            LookupRow[][] resultArray = this.getTargetService().getBatchDataByKey(new BatchLookupCall(split.getRemoteCalls()));
            split.setRemoteResults(resultArray);
        }
        return split.getCombinedResults();
    }

    public LookupRow[][] getBatchDataByText(BatchLookupCall batch) throws ProcessingException {
        BatchSplit split = new BatchSplit(batch);
        if (split.getLocalCallCount() > 0) {
            LookupCall[] calls = split.getLocalCalls();
            LookupRow[][] resultArray = new LookupRow[calls.length][];
            int i = 0;
            while (i < calls.length) {
                resultArray[i] = calls[i].getDataByText();
                ++i;
            }
            split.setLocalResults(resultArray);
        }
        if (split.getRemoteCallCount() > 0) {
            LookupRow[][] resultArray = this.getTargetService().getBatchDataByText(new BatchLookupCall(split.getRemoteCalls()));
            split.setRemoteResults(resultArray);
        }
        return split.getCombinedResults();
    }

    public LookupRow[][] getBatchDataByAll(BatchLookupCall batch) throws ProcessingException {
        BatchSplit split = new BatchSplit(batch);
        if (split.getLocalCallCount() > 0) {
            LookupCall[] calls = split.getLocalCalls();
            LookupRow[][] resultArray = new LookupRow[calls.length][];
            int i = 0;
            while (i < calls.length) {
                resultArray[i] = calls[i].getDataByAll();
                ++i;
            }
            split.setLocalResults(resultArray);
        }
        if (split.getRemoteCallCount() > 0) {
            LookupRow[][] resultArray = this.getTargetService().getBatchDataByAll(new BatchLookupCall(split.getRemoteCalls()));
            split.setRemoteResults(resultArray);
        }
        return split.getCombinedResults();
    }

    public LookupRow[][] getBatchDataByRec(BatchLookupCall batch) throws ProcessingException {
        BatchSplit split = new BatchSplit(batch);
        if (split.getLocalCallCount() > 0) {
            LookupCall[] calls = split.getLocalCalls();
            LookupRow[][] resultArray = new LookupRow[calls.length][];
            int i = 0;
            while (i < calls.length) {
                resultArray[i] = calls[i].getDataByRec();
                ++i;
            }
            split.setLocalResults(resultArray);
        }
        if (split.getRemoteCallCount() > 0) {
            LookupRow[][] resultArray = this.getTargetService().getBatchDataByRec(new BatchLookupCall(split.getRemoteCalls()));
            split.setRemoteResults(resultArray);
        }
        return split.getCombinedResults();
    }

    private IBatchLookupService getTargetService() {
        return ServiceTunnelUtility.createProxy(IBatchLookupService.class, ClientSyncJob.getCurrentSession().getServiceTunnel());
    }
}

