/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.activitymap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.activitymap.TimeRange;
import org.eclipse.scout.rt.client.ui.basic.calendar.AbstractCalendar;

class MultiTimeRange
implements Cloneable {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractCalendar.class);
    private TreeMap<Date, TimeRange> m_multipleTimeRangeMap = new TreeMap();

    public MultiTimeRange add(Date from, Date to) {
        this.checkParams(from, to);
        MultiTimeRange addedTimeRanges = new MultiTimeRange();
        addedTimeRanges.internalPutNoOldEntry(from, to);
        SortedMap<Date, TimeRange> headMap = this.m_multipleTimeRangeMap.headMap(to);
        boolean first = true;
        boolean finished = false;
        while (!finished && !headMap.isEmpty()) {
            Date tailKey = headMap.lastKey();
            TimeRange tail = (TimeRange)headMap.get(tailKey);
            Date tailTo = tail.getTo();
            if (first) {
                first = false;
                if (tailTo.after(to)) {
                    to = tailTo;
                }
            }
            Date tailFrom = tail.getFrom();
            if (tailTo.before(from)) {
                finished = true;
                continue;
            }
            if (tailFrom.before(from)) {
                finished = true;
                from = tailFrom;
            }
            this.m_multipleTimeRangeMap.remove(tailKey);
            addedTimeRanges.remove(tailFrom, tailTo);
        }
        this.internalPutNoOldEntry(from, to);
        return addedTimeRanges;
    }

    public void setSingleTimerange(Date from, Date to) {
        this.m_multipleTimeRangeMap = new TreeMap();
        this.internalPutNoOldEntry(from, to);
    }

    private void internalPutNoOldEntry(Date from, Date to) {
        try {
            this.checkParams(from, to);
        }
        catch (IllegalArgumentException iaex) {
            LOG.debug("adding [" + from + ", " + to + "] failed: " + iaex);
            return;
        }
        TimeRange oldEntry = this.m_multipleTimeRangeMap.put(from, new TimeRange(from, to));
        if (oldEntry != null) {
            throw new RuntimeException("Error: should not have an entry for key: " + from);
        }
    }

    private void checkParams(Date from, Date to) {
        if (from == null || to == null) {
            throw new IllegalArgumentException("from and to must not be null.");
        }
        if (!to.after(from)) {
            throw new IllegalArgumentException("time range must be > 0.");
        }
    }

    public Collection remove(Date from, Date to) {
        this.checkParams(from, to);
        ArrayList<TimeRange> removedTimeRanges = new ArrayList<TimeRange>();
        SortedMap<Date, TimeRange> headMap = this.m_multipleTimeRangeMap.headMap(to);
        boolean finished = false;
        while (!finished && !headMap.isEmpty()) {
            Date tailKey = headMap.lastKey();
            TimeRange tail = (TimeRange)headMap.get(tailKey);
            Date tailTo = tail.getTo();
            Date tailFrom = tail.getFrom();
            if (tailTo.after(to) && tailFrom.before(to)) {
                this.m_multipleTimeRangeMap.remove(tailKey);
                if (tailFrom.before(from)) {
                    removedTimeRanges.add(new TimeRange(from, to));
                    this.internalPutNoOldEntry(tailFrom, from);
                    this.internalPutNoOldEntry(to, tailTo);
                    finished = true;
                    continue;
                }
                removedTimeRanges.add(new TimeRange(tailFrom, to));
                this.internalPutNoOldEntry(to, tailTo);
                continue;
            }
            if (from.after(tailTo)) {
                finished = true;
                continue;
            }
            if (tailFrom.after(from)) {
                removedTimeRanges.add(this.m_multipleTimeRangeMap.remove(tailKey));
                continue;
            }
            this.m_multipleTimeRangeMap.remove(tailKey);
            this.internalPutNoOldEntry(tailFrom, from);
            removedTimeRanges.add(new TimeRange(from, tailTo));
            finished = true;
        }
        return removedTimeRanges;
    }

    public TimeRange[] getTimeRanges() {
        return this.m_multipleTimeRangeMap.values().toArray(new TimeRange[this.m_multipleTimeRangeMap.size()]);
    }

    public long sumDurationOfTimeranges() {
        long duration = 0L;
        TimeRange[] timeRangeArray = this.getTimeRanges();
        int n = timeRangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimeRange range = timeRangeArray[n2];
            duration += range.getTo().getTime() - range.getFrom().getTime();
            ++n2;
        }
        return duration;
    }

    public boolean isEmpty() {
        return this.m_multipleTimeRangeMap.isEmpty();
    }

    public Date getBeginDate() {
        if (this.m_multipleTimeRangeMap.isEmpty()) {
            return null;
        }
        return this.m_multipleTimeRangeMap.get(this.m_multipleTimeRangeMap.firstKey()).getFrom();
    }

    public Date getEndDate() {
        if (this.m_multipleTimeRangeMap.isEmpty()) {
            return null;
        }
        return this.m_multipleTimeRangeMap.get(this.m_multipleTimeRangeMap.lastKey()).getTo();
    }

    public boolean contains(Date representedDate) {
        if (representedDate == null || this.m_multipleTimeRangeMap.isEmpty()) {
            return false;
        }
        Date firstKeyAfterRepresentedDate = new Date(representedDate.getTime() + 1L);
        SortedMap<Date, TimeRange> headMap = this.m_multipleTimeRangeMap.headMap(firstKeyAfterRepresentedDate);
        if (headMap.isEmpty()) {
            return false;
        }
        return this.m_multipleTimeRangeMap.get(headMap.lastKey()).contains(representedDate);
    }

    public Object clone() {
        MultiTimeRange m = new MultiTimeRange();
        m.m_multipleTimeRangeMap = new TreeMap<Date, TimeRange>((SortedMap<Date, TimeRange>)this.m_multipleTimeRangeMap);
        return m;
    }
}

