/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

public abstract class AbstractTreeNodeBuilder {
    protected abstract ITreeNode createEmptyTreeNode() throws ProcessingException;

    public ITreeNode createTreeNode(Object primaryKey, String text, int nodeStatus, boolean markChildrenLoaded) throws ProcessingException {
        return this.createTreeNode(new LookupRow(primaryKey, text), nodeStatus, markChildrenLoaded);
    }

    public ITreeNode[] createTreeNodes(LookupRow[] lookupRows, int nodeStatus, boolean markChildrenLoaded) throws ProcessingException {
        ArrayList<ITreeNode> rootNodes = new ArrayList<ITreeNode>();
        HashMap<Object, ITreeNode> nodeMap = new HashMap<Object, ITreeNode>();
        HashMap<Object, ArrayList<ITreeNode>> parentChildMap = new HashMap<Object, ArrayList<ITreeNode>>();
        LookupRow[] lookupRowArray = lookupRows;
        int n = lookupRows.length;
        int n2 = 0;
        while (n2 < n) {
            LookupRow row = lookupRowArray[n2];
            ITreeNode node = this.createTreeNode(row, nodeStatus, markChildrenLoaded);
            nodeMap.put(node.getPrimaryKey(), node);
            if (row.getParentKey() != null) {
                ArrayList<ITreeNode> list = (ArrayList<ITreeNode>)parentChildMap.get(row.getParentKey());
                if (list == null) {
                    list = new ArrayList<ITreeNode>();
                    parentChildMap.put(row.getParentKey(), list);
                }
                list.add(node);
            } else {
                rootNodes.add(node);
            }
            ++n2;
        }
        for (Map.Entry e : parentChildMap.entrySet()) {
            Object parentKey = e.getKey();
            ITreeNode[] childNodes = ((ArrayList)e.getValue()).toArray(new ITreeNode[0]);
            ITreeNode parentNode = (ITreeNode)nodeMap.get(parentKey);
            if (parentNode instanceof AbstractTreeNode) {
                ((AbstractTreeNode)parentNode).addChildNodesInternal(parentNode.getChildNodeCount(), childNodes, true);
                continue;
            }
            rootNodes.addAll((Collection)e.getValue());
        }
        return rootNodes.toArray(new ITreeNode[0]);
    }

    public ITreeNode createTreeNode(LookupRow lookupRow, int nodeStatus, boolean markChildrenLoaded) throws ProcessingException {
        ITreeNode treeNode = this.createEmptyTreeNode();
        treeNode.setPrimaryKey(lookupRow.getKey());
        treeNode.setEnabledInternal(lookupRow.isEnabled());
        treeNode.setStatusInternal(nodeStatus);
        if (markChildrenLoaded) {
            treeNode.setChildrenLoaded(markChildrenLoaded);
        }
        Cell cell = treeNode.getCellForUpdate();
        cell.setValue(lookupRow);
        cell.setText(lookupRow.getText());
        cell.setTooltipText(lookupRow.getTooltipText());
        if (cell.getIconId() == null) {
            cell.setIconId(lookupRow.getIconId());
        }
        cell.setBackgroundColor(lookupRow.getBackgroundColor());
        cell.setForegroundColor(lookupRow.getForegroundColor());
        cell.setFont(lookupRow.getFont());
        if (!lookupRow.isActive()) {
            if (cell.getFont() == null) {
                cell.setFont(FontSpec.parse((String)"italic"));
            }
            cell.setText(String.valueOf(lookupRow.getText()) + " (" + ScoutTexts.get((String)"InactiveState", (String[])new String[0]) + ")");
        }
        return treeNode;
    }
}

