/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.outline.pages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableAdapter;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.TableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractStringColumn;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeAdapter;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithNodes;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.shared.ContextMap;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractPageWithNodes
extends AbstractPage
implements IPageWithNodes {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractPageWithNodes.class);
    private P_Table m_table;
    private final HashMap<ITableRow, IPage> m_tableRowToPageMap = new HashMap();
    private final HashMap<IPage, ITableRow> m_pageToTableRowMap = new HashMap();
    private P_ChildNodeListener m_childNodeListener;

    public AbstractPageWithNodes() {
        this(true, null, null);
    }

    public AbstractPageWithNodes(boolean callInitializer) {
        this(callInitializer, null, null);
    }

    public AbstractPageWithNodes(ContextMap contextMap) {
        this(true, contextMap, null);
    }

    public AbstractPageWithNodes(String userPreferenceContext) {
        this(true, null, userPreferenceContext);
    }

    public AbstractPageWithNodes(boolean callInitializer, String userPreferenceContext) {
        this(callInitializer, null, userPreferenceContext);
    }

    public AbstractPageWithNodes(boolean callInitializer, ContextMap contextMap, String userPreferenceContext) {
        super(callInitializer, contextMap, userPreferenceContext);
    }

    @ConfigOperation
    @Order(value=90.0)
    protected void execCreateChildPages(Collection<IPage> pageList) throws ProcessingException {
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.m_table = new P_Table();
        this.m_table.addTableListener(new P_TableListener());
        this.m_table.setAutoDiscardOnDelete(true);
        try {
            this.m_table.initTable();
        }
        catch (Exception e) {
            LOG.warn(null, (Throwable)e);
        }
    }

    @Override
    public void setTreeInternal(ITree tree, boolean includeSubtree) {
        if (this.getTree() != null && this.m_childNodeListener != null) {
            this.getTree().removeTreeListener(this.m_childNodeListener);
            this.m_childNodeListener = null;
        }
        super.setTreeInternal(tree, includeSubtree);
        if (this.getTree() != null) {
            this.m_childNodeListener = new P_ChildNodeListener();
            this.getTree().addTreeListener(this.m_childNodeListener);
        }
    }

    @Override
    public ITable getInternalTable() {
        return this.m_table;
    }

    @Override
    protected void execPageActivated() throws ProcessingException {
        super.execPageActivated();
        if (this.getInternalTable() != null && this.getTree() != null) {
            this.getInternalTable().setTitle(this.getTree().getPathText(this));
        }
    }

    @Override
    public void loadChildren() throws ProcessingException {
        ArrayList<IPage> pageList = new ArrayList<IPage>();
        this.execCreateChildPages(pageList);
        ITreeNode[] pages = pageList.toArray(new IPage[pageList.size()]);
        ITree tree = this.getTree();
        try {
            if (tree != null) {
                tree.setTreeChanging(true);
            }
            boolean oldSelectionOwned = false;
            int oldSelectionDirectChildIndex = -1;
            ITreeNode oldSelectedNode = null;
            if (tree != null) {
                oldSelectedNode = tree.getSelectedNode();
            }
            String oldSelectedText = null;
            if (oldSelectedNode != null) {
                ITreeNode t = oldSelectedNode;
                while (t != null && t.getParentNode() != null) {
                    if (t.getParentNode() == this) {
                        oldSelectionOwned = true;
                        oldSelectedText = t.getCell().getText();
                        oldSelectionDirectChildIndex = t.getChildNodeIndex();
                        break;
                    }
                    t = t.getParentNode();
                }
            }
            this.setChildrenLoaded(false);
            this.getTree().removeAllChildNodes(this);
            this.getTree().addChildNodes(this, pages);
            this.setChildrenLoaded(true);
            this.setChildrenDirty(false);
            if (tree != null && oldSelectionOwned && tree.getSelectedNode() == null) {
                if (oldSelectedNode != null && oldSelectedNode.getTree() == tree) {
                    tree.selectNode(oldSelectedNode);
                } else {
                    int index = Math.max(-1, Math.min(oldSelectionDirectChildIndex, this.getChildNodeCount() - 1));
                    if (index >= 0 && index < this.getChildNodeCount() && CompareUtility.equals((Object)oldSelectedText, (Object)this.getChildNode(index).getCell().getText())) {
                        tree.selectNode(this.getChildNode(index));
                    } else if (index >= 0 && index < this.getChildNodeCount()) {
                        tree.selectNode(this.getChildNode(index));
                    } else {
                        tree.selectNode(this);
                    }
                }
            }
        }
        finally {
            if (tree != null) {
                tree.setTreeChanging(false);
            }
        }
        this.rebuildTable();
    }

    private void rebuildTable() throws ProcessingException {
        ITreeNode[] childNodes = this.getChildNodes();
        try {
            this.getInternalTable().setTableChanging(true);
            this.unlinkAllTableRowWithPage();
            this.getInternalTable().discardAllRows();
            int i = 0;
            while (i < childNodes.length) {
                TableRow row = new TableRow(this.getInternalTable().getColumnSet());
                row.setCell(0, childNodes[i].getCell());
                ITableRow insertedRow = this.getInternalTable().addRow(row);
                this.linkTableRowWithPage(insertedRow, (IPage)childNodes[i]);
                ++i;
            }
        }
        finally {
            this.getInternalTable().setTableChanging(false);
        }
    }

    @Override
    public boolean isFilterAcceptedForChildNode(ITreeNode childPageNode) {
        return this.m_pageToTableRowMap.get(childPageNode) == null || this.m_pageToTableRowMap.get(childPageNode).isFilterAccepted();
    }

    private void linkTableRowWithPage(ITableRow tableRow, IPage page) {
        this.m_tableRowToPageMap.put(tableRow, page);
        this.m_pageToTableRowMap.put(page, tableRow);
    }

    private void unlinkAllTableRowWithPage() {
        this.m_tableRowToPageMap.clear();
        this.m_pageToTableRowMap.clear();
    }

    private ITreeNode getTreeNodeFor(ITableRow tableRow) {
        if (tableRow == null) {
            return null;
        }
        return this.m_tableRowToPageMap.get(tableRow);
    }

    private ITreeNode[] getTreeNodesFor(ITableRow[] tableRows) {
        ITreeNode[] nodes = new ITreeNode[tableRows.length];
        int missingCount = 0;
        int i = 0;
        while (i < tableRows.length) {
            nodes[i] = this.m_tableRowToPageMap.get(tableRows[i]);
            if (nodes[i] == null) {
                ++missingCount;
            }
            ++i;
        }
        if (missingCount > 0) {
            ITreeNode[] tmp = new ITreeNode[nodes.length - missingCount];
            int index = 0;
            int i2 = 0;
            while (i2 < nodes.length) {
                if (nodes[i2] != null) {
                    tmp[index] = nodes[i2];
                    ++index;
                }
                ++i2;
            }
            nodes = tmp;
        }
        return nodes;
    }

    private class P_ChildNodeListener
    extends TreeAdapter {
        private P_ChildNodeListener() {
        }

        @Override
        public void treeChanged(TreeEvent e) {
            switch (e.getType()) {
                case 10: 
                case 20: 
                case 30: 
                case 50: {
                    try {
                        AbstractPageWithNodes.this.rebuildTable();
                        break;
                    }
                    catch (ProcessingException e1) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e1);
                    }
                }
            }
        }
    }

    private class P_Table
    extends AbstractTable {
        private P_Table() {
        }

        @Override
        public void sort() {
        }

        @Override
        protected boolean getConfiguredAutoResizeColumns() {
            return true;
        }

        @Override
        protected boolean getConfiguredMultiSelect() {
            return false;
        }

        public LabelColumn getLabelColumn() {
            return this.getColumnSet().getColumnByClass(LabelColumn.class);
        }

        @Order(value=1.0)
        public class LabelColumn
        extends AbstractStringColumn {
            @Override
            protected String getConfiguredHeaderText() {
                return ScoutTexts.get((String)"Folders", (String[])new String[0]);
            }

            @Override
            protected void decorateCellInternal(Cell cell, ITableRow row) {
            }

            @Override
            protected int getConfiguredWidth() {
                return 800;
            }
        }
    }

    private class P_TableListener
    extends TableAdapter {
        private P_TableListener() {
        }

        @Override
        public void tableChanged(TableEvent e) {
            switch (e.getType()) {
                case 104: {
                    ITreeNode node;
                    if (e.isConsumed() || (node = AbstractPageWithNodes.this.getTreeNodeFor(e.getFirstRow())) == null) break;
                    e.consume();
                    AbstractPageWithNodes.this.getTree().getUIFacade().setNodeSelectedAndExpandedFromUI(node);
                    break;
                }
                case 700: {
                    ITreeNode node = AbstractPageWithNodes.this.getTreeNodeFor(e.getFirstRow());
                    if (node instanceof IPageWithTable) {
                        try {
                            node.ensureChildrenLoaded();
                            IPageWithTable tablePage = (IPageWithTable)node;
                            IMenu[] menus = ((ITable)tablePage.getTable()).fetchMenusForRowsInternal(new ITableRow[0]);
                            if (menus == null) break;
                            e.addPopupMenus(menus);
                        }
                        catch (ProcessingException ex) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
                        }
                        break;
                    }
                    if (!(node instanceof IPageWithNodes)) break;
                    IPageWithNodes nodePage = (IPageWithNodes)node;
                    try {
                        ITreeNode treeNode = AbstractPageWithNodes.this.getTree().resolveVirtualNode(nodePage);
                        IMenu[] menus = AbstractPageWithNodes.this.getTree().fetchMenusForNodesInternal(new ITreeNode[]{treeNode});
                        if (menus == null) break;
                        e.addPopupMenus(menus);
                    }
                    catch (ProcessingException e1) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e1);
                    }
                    break;
                }
                case 740: {
                    ITreeNode node = AbstractPageWithNodes.this.getTreeNodeFor(e.getFirstRow());
                    if (node == null) break;
                    AbstractPageWithNodes.this.getTree().getUIFacade().fireNodeDropActionFromUI(node, e.getDropObject());
                    break;
                }
                case 210: {
                    if (AbstractPageWithNodes.this.isLeaf() || AbstractPageWithNodes.this.getTree() == null) break;
                    AbstractPageWithNodes.this.getTree().applyNodeFilters();
                }
            }
        }
    }
}

