/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.PrintDevice;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;

public class FormEvent
extends EventObject {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_ACTIVATED = 510;
    public static final int TYPE_LOAD_BEFORE = 1000;
    public static final int TYPE_LOAD_AFTER = 1010;
    public static final int TYPE_LOAD_COMPLETE = 1020;
    public static final int TYPE_STORE_BEFORE = 2010;
    public static final int TYPE_STORE_AFTER = 2020;
    public static final int TYPE_DISCARDED = 3000;
    public static final int TYPE_CLOSED = 3010;
    public static final int TYPE_PRINT = 4000;
    public static final int TYPE_PRINTED = 4010;
    public static final int TYPE_STRUCTURE_CHANGED = 5000;
    public static final int TYPE_TO_FRONT = 6000;
    public static final int TYPE_TO_BACK = 6010;
    private final int m_type;
    private IFormField m_formField;
    private PrintDevice m_printDevice;
    private Map<String, Object> m_printParameters;
    private File m_printedFile;

    public FormEvent(IForm form, int type) {
        super(form);
        this.m_type = type;
    }

    public FormEvent(IForm form, int type, File printedFile) {
        this(form, type);
        this.m_printedFile = printedFile;
    }

    public FormEvent(IForm form, int type, IFormField causingField) {
        super(form);
        this.m_type = type;
        this.m_formField = causingField;
    }

    public FormEvent(IForm form, int type, IFormField printRoot, PrintDevice printDevice, Map<String, Object> printParameters) {
        super(form);
        this.m_type = type;
        this.m_formField = printRoot;
        this.m_printDevice = printDevice;
        this.m_printParameters = printParameters;
    }

    public IForm getForm() {
        return (IForm)this.getSource();
    }

    public int getType() {
        return this.m_type;
    }

    public IFormField getFormField() {
        return this.m_formField;
    }

    public PrintDevice getPrintDevice() {
        return this.m_printDevice;
    }

    public File getPrintedFile() {
        return this.m_printedFile;
    }

    public Map<String, Object> getPrintParameters() {
        if (this.m_printParameters != null) {
            return new HashMap<String, Object>(this.m_printParameters);
        }
        return new HashMap<String, Object>();
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("DialogEvent[");
        try {
            Field[] f = this.getClass().getDeclaredFields();
            int i = 0;
            while (i < f.length) {
                if (Modifier.isPublic(f[i].getModifiers()) && Modifier.isStatic(f[i].getModifiers()) && f[i].getName().startsWith("TYPE_") && ((Number)f[i].get(null)).intValue() == this.m_type) {
                    buf.append(f[i].getName());
                    break;
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            buf.append("#" + this.m_type);
        }
        if (this.getForm() != null) {
            buf.append(" " + this.getForm().getFormId());
        }
        buf.append("]");
        return buf.toString();
    }
}

