/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.composer.internal;

import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.AttributeNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.EitherOrNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.EntityNode;

public class ComposerDisplayTextBuilder {
    public void build(ITreeNode node, StringBuffer buf, String prefix) {
        this.visitAndNodes(node.getChildNodes(), buf, prefix);
    }

    private void visitAndNodes(ITreeNode[] nodes, StringBuffer buf, String prefix) {
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i] instanceof EntityNode) {
                this.visitEntityNode((EntityNode)nodes[i], buf, prefix);
                ++i;
                continue;
            }
            if (nodes[i] instanceof AttributeNode) {
                this.visitAttributeNode((AttributeNode)nodes[i], buf, prefix);
                ++i;
                continue;
            }
            if (!(nodes[i] instanceof EitherOrNode)) continue;
            int k = i;
            while (k + 1 < nodes.length && nodes[k + 1] instanceof EitherOrNode && !((EitherOrNode)nodes[k + 1]).isBeginOfEitherOr()) {
                ++k;
            }
            EitherOrNode[] eNodes = new EitherOrNode[k - i + 1];
            System.arraycopy(nodes, i, eNodes, 0, eNodes.length);
            this.visitOrNodes(eNodes, buf, prefix);
            i = k + 1;
        }
    }

    private void visitOrNodes(EitherOrNode[] nodes, StringBuffer buf, String prefix) {
        EitherOrNode[] eitherOrNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            EitherOrNode node = eitherOrNodeArray[n2];
            buf.append(prefix);
            buf.append(node.getCell().getText());
            buf.append("\n");
            this.visitAndNodes(node.getChildNodes(), buf, String.valueOf(prefix) + " ");
            ++n2;
        }
    }

    private void visitEntityNode(EntityNode node, StringBuffer buf, String prefix) {
        buf.append(prefix);
        buf.append(node.getCell().getText());
        buf.append("\n");
        this.visitAndNodes(node.getChildNodes(), buf, String.valueOf(prefix) + " ");
    }

    private void visitAttributeNode(AttributeNode node, StringBuffer buf, String prefix) {
        buf.append(prefix);
        buf.append(node.getCell().getText());
        buf.append("\n");
        this.visitAndNodes(node.getChildNodes(), buf, String.valueOf(prefix) + " ");
    }
}

