/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.composer.node;

import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerField;
import org.eclipse.scout.rt.client.ui.form.fields.composer.internal.ComposerAttributeForm;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.EntityNode;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttributeOp;

public abstract class AbstractAddAttributeMenu
extends AbstractMenu {
    private final IComposerField m_field;
    private final ITreeNode m_parentNode;

    public AbstractAddAttributeMenu(IComposerField field, ITreeNode parentNode) {
        super(false);
        this.m_field = field;
        this.m_parentNode = parentNode;
        this.callInitializer();
    }

    @Override
    protected String getConfiguredText() {
        return ScoutTexts.get((String)"ExtendedSearchAddAttributeMenu", (String[])new String[0]);
    }

    @Override
    protected void execPrepareAction() throws ProcessingException {
        EntityNode eNode = null;
        ITreeNode n = this.m_parentNode;
        while (n != null) {
            if (n instanceof EntityNode) {
                eNode = (EntityNode)n;
                break;
            }
            n = n.getParentNode();
        }
        IDataModelAttribute[] atts = eNode != null ? eNode.getEntity().getAttributes() : this.m_field.getAttributes();
        this.setVisible(atts.length > 0);
    }

    @Override
    protected void execAction() throws ProcessingException {
        ComposerAttributeForm form = new ComposerAttributeForm();
        EntityNode eNode = null;
        ITreeNode n = this.m_parentNode;
        while (n != null) {
            if (n instanceof EntityNode) {
                eNode = (EntityNode)n;
                break;
            }
            n = n.getParentNode();
        }
        if (eNode != null) {
            form.setAvailableAttributes(eNode.getEntity().getAttributes());
        } else {
            form.setAvailableAttributes(this.m_field.getAttributes());
        }
        form.startNew();
        form.waitFor();
        if (form.isFormStored()) {
            IDataModelAttribute a = form.getSelectedAttribute();
            IDataModelAttributeOp op = form.getSelectedOp();
            Object[] values = form.getSelectedValues();
            String[] displayValues = form.getSelectedDisplayValues();
            this.m_field.addAttributeNode(this.m_parentNode, a, null, op, values, displayValues);
        }
    }
}

