/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.wizard;

import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.wizard.AbstractWizardStep;
import org.eclipse.scout.rt.client.ui.wizard.IWizard;
import org.eclipse.scout.rt.client.ui.wizard.WizardEvent;
import org.eclipse.scout.rt.client.ui.wizard.WizardListener;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public class WrappedWizardWizardStep
extends AbstractWizardStep {
    private final IWizard m_parentWizard;
    private final IWizard m_childWizard;

    public WrappedWizardWizardStep(IWizard parentWizard, IWizard childWizard) throws ProcessingException {
        this.m_parentWizard = parentWizard;
        this.m_childWizard = childWizard;
        this.setTitle(childWizard.getTitle());
    }

    @Override
    protected void execActivate(int stepKind) throws ProcessingException {
        this.m_childWizard.addWizardListener(new WizardListener(){

            @Override
            public void wizardChanged(WizardEvent e) {
                switch (e.getType()) {
                    case 50: {
                        try {
                            WrappedWizardWizardStep.this.m_parentWizard.doNextStep();
                            break;
                        }
                        catch (ProcessingException t) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(t);
                        }
                    }
                }
            }
        });
        this.m_childWizard.start();
    }

    public IWizard getParentWizard() {
        return this.m_parentWizard;
    }

    public IWizard getChildWizard() {
        return this.m_childWizard;
    }
}

