/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.common.utilities.exception;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.tml.common.utilities.BasePlugin;
import org.eclipse.tml.common.utilities.exception.TmLException;

public class ExceptionHandler {
    public static String logException(TmLException exception) {
        IStatus status = exception.getStatus();
        int code = status.getCode();
        String plugin = status.getPlugin();
        String msg = status.getMessage();
        Throwable t = status.getException();
        String logMessage = String.valueOf(msg) + "(PLUGIN=" + plugin + ";ERROR=" + String.valueOf(code) + ")";
        switch (exception.getStatus().getSeverity()) {
            case 1: {
                BasePlugin.logInfo(logMessage);
                break;
            }
            case 2: {
                BasePlugin.logWarning(logMessage);
                break;
            }
            default: {
                if (t != null) {
                    BasePlugin.logError(logMessage, t);
                    break;
                }
                BasePlugin.logError(logMessage);
            }
        }
        return logMessage;
    }

    public static void showException(TmLException exception) {
        ExceptionHandler.logException(exception);
        exception.getStatus().getException();
    }
}

