/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.ui.view.provider;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tml.framework.device.DevicePlugin;
import org.eclipse.tml.framework.device.model.IDeviceType;
import org.eclipse.tml.framework.device.model.IInstance;
import org.eclipse.tml.framework.device.model.IInstanceRegistry;
import org.eclipse.tml.framework.status.IStatus;
import org.eclipse.tml.framework.status.LabelStatus;
import org.eclipse.tml.framework.status.StatusRegistry;

public class InstanceLabelProvider
extends LabelProvider {
    private static final String DEVICE = "Device";
    private static final String INSTANCE_REGISTRY = "Instance registry";
    private static final String NO_DEVICE = "No device";
    private static final String NO_STATUS = "No status";
    private static final String PROPERTIES = "Properties";
    private Map imageCache = new HashMap(20);

    public Image getImage(Object element) {
        ImageDescriptor descriptor = null;
        if (element instanceof IInstanceRegistry) {
            descriptor = ((IInstanceRegistry)element).getImage();
        } else if (element instanceof IInstance) {
            descriptor = DevicePlugin.getDefault().getImageDescriptor("ICON_DEVICE");
        } else if (element instanceof LabelStatus) {
            IStatus status = StatusRegistry.getInstance().getStatus(((LabelStatus)element).getStatus());
            descriptor = status.getImage();
        } else {
            if (element instanceof IDeviceType) {
                return ((IDeviceType)element).getImage();
            }
            if (element instanceof String || element instanceof Properties) {
                descriptor = DevicePlugin.getDefault().getImageDescriptor("ICON_PROPERTY");
            } else {
                throw this.unknownElement(element);
            }
        }
        Image image = (Image)this.imageCache.get(descriptor);
        if (image == null) {
            image = descriptor.createImage();
            this.imageCache.put(descriptor, image);
        }
        return image;
    }

    public String getText(Object element) {
        if (element instanceof IInstanceRegistry) {
            return INSTANCE_REGISTRY;
        }
        if (element instanceof IInstance) {
            String name = ((IInstance)element).getName();
            if (name == null) {
                return DEVICE;
            }
            return name;
        }
        if (element instanceof LabelStatus) {
            IStatus status = StatusRegistry.getInstance().getStatus(((LabelStatus)element).getStatus());
            String name = null;
            if (status != null) {
                name = status.getName();
            }
            if (name == null) {
                return NO_STATUS;
            }
            return name;
        }
        if (element instanceof IDeviceType) {
            if (element == null) {
                return NO_DEVICE;
            }
            return ((IDeviceType)element).getLabel();
        }
        if (element instanceof String) {
            return (String)element;
        }
        if (element instanceof Properties) {
            return PROPERTIES;
        }
        throw this.unknownElement(element);
    }

    public void dispose() {
        Iterator i = this.imageCache.values().iterator();
        while (i.hasNext()) {
            ((Image)i.next()).dispose();
        }
        this.imageCache.clear();
    }

    protected RuntimeException unknownElement(Object element) {
        return new RuntimeException("Unknown type of element in tree of type " + element.getClass().getName());
    }
}

