/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.device.qemu.wizard.custom;

import java.util.Properties;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tml.device.qemu.QEmuPlugin;
import org.eclipse.tml.framework.device.ui.wizard.IInstanceProperties;

public class QEmuBinarySettingsWizardPage
extends WizardPage
implements IInstanceProperties {
    private Text installedDirText;
    private Button browseInstalledDirButton;
    private Text emulatorBinaryText;
    private Button browseEmulatorBinaryButton;
    private Text kernelImageText;
    private Button browseKernelImageButton;
    private Text initrdText;
    private Button browseInitrdButton;
    private Text emulatedMachineText;
    private Text additionalOptionsText;
    private Button startVNCButton;
    private StyledText usage;

    protected QEmuBinarySettingsWizardPage(String pageName) {
        super(pageName);
    }

    public QEmuBinarySettingsWizardPage() {
        super("$qemu_binary_settings$");
        this.setTitle(QEmuPlugin.getResourceString("QEmuBinarySettingsWizardPage.title"));
        this.setMessage(QEmuPlugin.getResourceString("QEmuBinarySettingsWizardPage.message"));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setLayoutData((Object)new GridData(1808));
        container.setFont(parent.getFont());
        Label label = new Label(container, 0);
        label.setText(QEmuPlugin.getResourceString("QEmuBinarySettingsWizardPage.installedDir"));
        label.setFont(container.getFont());
        this.installedDirText = new Text(container, 2048);
        GridData gd = new GridData(768);
        this.installedDirText.setLayoutData((Object)gd);
        this.installedDirText.setFont(container.getFont());
        this.installedDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                QEmuBinarySettingsWizardPage.this.updateUsage();
                QEmuBinarySettingsWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.browseInstalledDirButton = new Button(container, 8);
        this.browseInstalledDirButton.setText(QEmuPlugin.getResourceString("QEmuBinarySettingsWizardPage.browse"));
        this.browseInstalledDirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String dir;
                DirectoryDialog fileDialog = new DirectoryDialog(QEmuBinarySettingsWizardPage.this.getShell(), 4096);
                if (QEmuBinarySettingsWizardPage.this.installedDirText.getText() != null) {
                    fileDialog.setFilterPath(QEmuBinarySettingsWizardPage.this.installedDirText.getText());
                }
                if ((dir = fileDialog.open()) != null && (dir = dir.trim()).length() > 0) {
                    QEmuBinarySettingsWizardPage.this.installedDirText.setText(dir);
                }
            }
        });
        Group group = new Group(container, 0);
        group.setText(QEmuPlugin.getResourceString("QEmuBinarySettingsWizardPage.emulatorStartupSettings"));
        GridLayout layout = new GridLayout(3, false);
        group.setLayout((Layout)layout);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        group.setLayoutData((Object)gd);
        group.setFont(container.getFont());
        label = new Label((Composite)group, 0);
        label.setText(QEmuPlugin.getResourceString("QEmuBinarySettingsWizardPage.emulatorBinary"));
        label.setFont(container.getFont());
        this.emulatorBinaryText = new Text((Composite)group, 2048);
        gd = new GridData(768);
        this.emulatorBinaryText.setLayoutData((Object)gd);
        this.emulatorBinaryText.setFont(container.getFont());
        this.emulatorBinaryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                QEmuBinarySettingsWizardPage.this.updateUsage();
                QEmuBinarySettingsWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.browseEmulatorBinaryButton = new Button((Composite)group, 8);
        this.browseEmulatorBinaryButton.setText(QEmuPlugin.getResourceString("QEmuBinarySettingsWizardPage.browse"));
        this.browseEmulatorBinaryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(QEmuBinarySettingsWizardPage.this.getShell(), 4096);
                if (QEmuBinarySettingsWizardPage.this.emulatorBinaryText.getText().trim() != "") {
                    fileDialog.setFilterPath(QEmuBinarySettingsWizardPage.this.emulatorBinaryText.getText());
                } else if (QEmuBinarySettingsWizardPage.this.installedDirText.getText().trim() != "") {
                    fileDialog.setFilterPath(QEmuBinarySettingsWizardPage.this.installedDirText.getText());
                }
                String dir = fileDialog.open();
                if (dir != null && (dir = dir.trim()).length() > 0) {
                    QEmuBinarySettingsWizardPage.this.emulatorBinaryText.setText(QEmuBinarySettingsWizardPage.this.getRelativePath(dir));
                }
            }
        });
        label = new Label((Composite)group, 0);
        label.setText(QEmuPlugin.getResourceString("QEmuBinarySettingsWizardPage.kernelImage"));
        label.setFont(container.getFont());
        this.kernelImageText = new Text((Composite)group, 2048);
        gd = new GridData(768);
        this.kernelImageText.setLayoutData((Object)gd);
        this.kernelImageText.setFont(container.getFont());
        this.kernelImageText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                QEmuBinarySettingsWizardPage.this.updateUsage();
                QEmuBinarySettingsWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.browseKernelImageButton = new Button((Composite)group, 8);
        this.browseKernelImageButton.setText(QEmuPlugin.getResourceString("QEmuBinarySettingsWizardPage.browse"));
        this.browseKernelImageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(QEmuBinarySettingsWizardPage.this.getShell(), 4096);
                if (QEmuBinarySettingsWizardPage.this.kernelImageText.getText() != null) {
                    fileDialog.setFilterPath(QEmuBinarySettingsWizardPage.this.emulatorBinaryText.getText());
                } else if (QEmuBinarySettingsWizardPage.this.installedDirText.getText() != null) {
                    fileDialog.setFilterPath(QEmuBinarySettingsWizardPage.this.installedDirText.getText());
                }
                String dir = fileDialog.open();
                if (dir != null && (dir = dir.trim()).length() > 0) {
                    QEmuBinarySettingsWizardPage.this.kernelImageText.setText(QEmuBinarySettingsWizardPage.this.getRelativePath(dir));
                }
            }
        });
        label = new Label((Composite)group, 0);
        label.setText(QEmuPlugin.getResourceString("QEmuBinarySettingsWizardPage.initrd"));
        label.setFont(container.getFont());
        this.initrdText = new Text((Composite)group, 2048);
        gd = new GridData(768);
        this.initrdText.setLayoutData((Object)gd);
        this.initrdText.setFont(container.getFont());
        this.initrdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                QEmuBinarySettingsWizardPage.this.updateUsage();
                QEmuBinarySettingsWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.browseInitrdButton = new Button((Composite)group, 8);
        this.browseInitrdButton.setText(QEmuPlugin.getResourceString("QEmuBinarySettingsWizardPage.browse"));
        this.browseInitrdButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(QEmuBinarySettingsWizardPage.this.getShell(), 4096);
                if (QEmuBinarySettingsWizardPage.this.initrdText.getText() != null) {
                    fileDialog.setFilterPath(QEmuBinarySettingsWizardPage.this.initrdText.getText());
                } else if (QEmuBinarySettingsWizardPage.this.installedDirText.getText() != null) {
                    fileDialog.setFilterPath(QEmuBinarySettingsWizardPage.this.installedDirText.getText());
                }
                String dir = fileDialog.open();
                if (dir != null && (dir = dir.trim()).length() > 0) {
                    QEmuBinarySettingsWizardPage.this.initrdText.setText(QEmuBinarySettingsWizardPage.this.getRelativePath(dir));
                }
            }
        });
        group.pack();
        this.startVNCButton = new Button(container, 32);
        this.startVNCButton.setSelection(true);
        this.startVNCButton.setText(QEmuPlugin.getResourceString("QEmuBinarySettingsWizardPage.enableVNC"));
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.startVNCButton.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText(QEmuPlugin.getResourceString("QEmuBinarySettingsWizardPage.emulatedMachine"));
        label.setFont(container.getFont());
        this.emulatedMachineText = new Text(container, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.emulatedMachineText.setLayoutData((Object)gd);
        this.emulatedMachineText.setFont(container.getFont());
        this.emulatedMachineText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                QEmuBinarySettingsWizardPage.this.updateUsage();
                QEmuBinarySettingsWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        label = new Label(container, 0);
        label.setText(QEmuPlugin.getResourceString("QEmuBinarySettingsWizardPage.additionalOptions"));
        label.setFont(container.getFont());
        this.additionalOptionsText = new Text(container, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.additionalOptionsText.setLayoutData((Object)gd);
        this.additionalOptionsText.setFont(container.getFont());
        this.additionalOptionsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                QEmuBinarySettingsWizardPage.this.updateUsage();
                QEmuBinarySettingsWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        label = new Label(container, 0);
        label.setText(QEmuPlugin.getResourceString("QEmuBinarySettingsWizardPage.usage"));
        label.setFont(container.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        this.usage = new StyledText(container, 2122);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.verticalSpan = 3;
        gd.minimumHeight = 100;
        this.usage.setLayoutData((Object)gd);
        this.setControl((Control)container);
    }

    public boolean isPageComplete() {
        if (this.installedDirText == null || this.installedDirText.isDisposed()) {
            return false;
        }
        return this.installedDirText != null && this.installedDirText.getText().trim() != "" && this.emulatorBinaryText != null && this.emulatorBinaryText.getText().trim() != "";
    }

    public void dispose() {
        if (this.getControl() != null) {
            this.setControl(null);
        }
        super.dispose();
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.put("InstalledDirectory", this.installedDirText.getText());
        properties.put("QEmuBinaryName", this.emulatorBinaryText.getText());
        if (this.kernelImageText.getText().trim() != "") {
            properties.put("KernelImage", this.kernelImageText.getText());
        }
        if (this.initrdText.getText().trim() != "") {
            properties.put("InitialRAMDisk", this.initrdText.getText());
        }
        if (this.emulatedMachineText.getText().trim() != "") {
            properties.put("EmulatedMachine", this.emulatedMachineText.getText());
        }
        if (this.startVNCButton.getSelection()) {
            properties.put("EnableVNC", Boolean.TRUE.toString());
        } else {
            properties.put("EnableVNC", Boolean.FALSE.toString());
        }
        if (this.additionalOptionsText.getText().trim() != "") {
            properties.put("AdditionalOptions", this.additionalOptionsText.getText());
        }
        return properties;
    }

    private String getRelativePath(String path) {
        if (path.startsWith(this.installedDirText.getText())) {
            return path.substring(this.installedDirText.getText().length() + 1);
        }
        return path;
    }

    private void updateUsage() {
        IWizardPage previousPage;
        StringBuffer buffer = new StringBuffer();
        if (this.emulatorBinaryText.getText().trim() != "") {
            buffer.append(this.emulatorBinaryText.getText().trim());
        }
        if (this.kernelImageText.getText().trim() != "") {
            buffer.append(" -kernel ");
            buffer.append(this.kernelImageText.getText().trim());
        }
        if (this.initrdText.getText().trim() != "") {
            buffer.append(" -initrd ");
            buffer.append(this.initrdText.getText().trim());
        }
        if (this.emulatedMachineText.getText().trim() != "") {
            buffer.append(" -M ");
            buffer.append(this.emulatedMachineText.getText().trim());
        }
        if (this.additionalOptionsText.getText().trim() != "") {
            buffer.append(" ");
            buffer.append(this.additionalOptionsText.getText().trim());
            buffer.append(" ");
        }
        if (this.startVNCButton.getSelection() && (previousPage = this.getPreviousPage()) instanceof IInstanceProperties) {
            Properties properties = ((IInstanceProperties)previousPage).getProperties();
            String host = properties.getProperty("host");
            String display = properties.getProperty("display");
            String vncConnectionString = null;
            vncConnectionString = host != null && display != null ? String.valueOf(host) + display : "<host>:<display>";
            buffer.append(" -vnc " + vncConnectionString);
        }
        this.usage.setText(buffer.toString());
    }
}

