/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.manager.persistence;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.tml.common.utilities.exception.ExceptionHandler;
import org.eclipse.tml.common.utilities.exception.TmLException;
import org.eclipse.tml.framework.device.DevicePlugin;
import org.eclipse.tml.framework.device.exception.DeviceExceptionHandler;
import org.eclipse.tml.framework.device.factory.InstanceRegistry;
import org.eclipse.tml.framework.device.manager.InstanceManager;
import org.eclipse.tml.framework.device.manager.persistence.IDeviceXmlTags;
import org.eclipse.tml.framework.device.manager.persistence.TmLDevice;
import org.eclipse.tml.framework.device.model.IInstance;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DeviceXmlReader
implements IDeviceXmlTags {
    public static void loadInstances(InstanceManager manager) {
        File path = DevicePlugin.getDeviceXmlLocation();
        File file = new File(path, "tml_devices.xml");
        if (file.exists()) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(file);
                Element rootElement = document.getDocumentElement();
                DeviceXmlReader.parseDevicesList(rootElement, manager);
                DeviceXmlReader.parseInstancesList(rootElement, manager);
            }
            catch (IOException ie) {
                ie.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }
    }

    private static void parseDevicesList(Element rootElement, InstanceManager manager) {
        Node node;
        HashMap<String, TmLDevice> devices = new HashMap<String, TmLDevice>();
        manager.setDevicesMap(devices);
        NodeList devicesNodes = rootElement.getElementsByTagName("devices");
        if (devicesNodes != null && devicesNodes.getLength() == 1 && (node = devicesNodes.item(0)).getNodeType() == 1) {
            Element devicesElement = (Element)node;
            NodeList deviceNodeList = devicesElement.getElementsByTagName("deviceType");
            int i = 0;
            while (deviceNodeList != null && i < deviceNodeList.getLength()) {
                Node devicedNode = deviceNodeList.item(i);
                if (devicedNode.getNodeType() == 1) {
                    Node devicePluginNode;
                    Node firstChild;
                    Element deviceElement = (Element)devicedNode;
                    String deviceId = deviceElement.getAttribute("id");
                    String plugin = "";
                    NodeList devicePluginNodes = deviceElement.getElementsByTagName("plugin");
                    if (devicePluginNodes != null && devicePluginNodes.getLength() >= 1 && (firstChild = (devicePluginNode = devicePluginNodes.item(0)).getFirstChild()) != null && firstChild.getNodeType() == 3) {
                        plugin = firstChild.getNodeValue();
                    }
                    TmLDevice device = new TmLDevice(deviceId, plugin);
                    devices.put(deviceId, device);
                }
                ++i;
            }
        }
    }

    private static void parseInstancesList(Element rootElement, InstanceManager manager) {
        Node node;
        InstanceRegistry registry = InstanceRegistry.getInstance();
        NodeList instancesNodes = rootElement.getElementsByTagName("instances");
        if (instancesNodes != null && instancesNodes.getLength() == 1 && (node = instancesNodes.item(0)).getNodeType() == 1) {
            Element instancesElement = (Element)node;
            NodeList instanceNodeList = instancesElement.getElementsByTagName("instance");
            int i = 0;
            while (instanceNodeList != null && i < instanceNodeList.getLength()) {
                Node childNode = instanceNodeList.item(i);
                if (childNode.getNodeType() == 1) {
                    Element childElement = (Element)childNode;
                    String xml_device_id = childElement.getAttribute("deviceType_id");
                    String instanceName = childElement.getAttribute("name");
                    Properties prop = new Properties();
                    NodeList propList = childElement.getChildNodes();
                    int j = 0;
                    while (propList != null && j < propList.getLength()) {
                        Node propNode = propList.item(j);
                        if (propNode.getNodeType() == 1) {
                            Element propElement = (Element)propNode;
                            prop.put(propElement.getTagName(), propElement.getTextContent());
                        }
                        ++j;
                    }
                    IInstance inst = null;
                    if (instanceName != null && !instanceName.equals("") && xml_device_id != null && !xml_device_id.equals("")) {
                        try {
                            inst = manager.createInstance(instanceName, xml_device_id, "OFF", prop);
                            registry.addInstance(inst);
                        }
                        catch (TmLException tmLException) {
                            ExceptionHandler.showException((TmLException)DeviceExceptionHandler.exception(202));
                        }
                    }
                    if (manager.getCurrentInstance() == null) {
                        manager.setInstance(inst);
                    }
                }
                ++i;
            }
        }
    }
}

