/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.validation.session;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.ProjectInitializationData;
import org.eclipse.set.basis.ToolboxPaths;
import org.eclipse.set.basis.constants.ContainerType;
import org.eclipse.set.basis.constants.ExportType;
import org.eclipse.set.basis.constants.PlanProFileNature;
import org.eclipse.set.basis.constants.TableType;
import org.eclipse.set.basis.constants.ToolboxConstants;
import org.eclipse.set.basis.constants.ValidationResult;
import org.eclipse.set.basis.exceptions.UserAbortion;
import org.eclipse.set.basis.extensions.IModelSessionExtensions;
import org.eclipse.set.basis.extensions.PathExtensions;
import org.eclipse.set.basis.files.ToolboxFile;
import org.eclipse.set.basis.files.ToolboxFileRole;
import org.eclipse.set.basis.guid.Guid;
import org.eclipse.set.core.services.branding.BrandingService;
import org.eclipse.set.core.services.cache.CacheService;
import org.eclipse.set.core.services.defaultvalue.DefaultValueService;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.set.core.services.files.ToolboxFileService;
import org.eclipse.set.core.services.initialization.InitializationService;
import org.eclipse.set.core.services.initialization.InitializationStep;
import org.eclipse.set.core.services.part.ToolboxPartService;
import org.eclipse.set.core.services.rename.RenameService;
import org.eclipse.set.core.services.session.SessionService;
import org.eclipse.set.core.services.validation.ValidationService;
import org.eclipse.set.feature.validation.Messages;
import org.eclipse.set.feature.validation.session.DataEventTransformation;
import org.eclipse.set.feature.validation.session.ToolboxPathsImpl;
import org.eclipse.set.ppmodel.extensions.DocumentRootExtensions;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleDebugExtensions;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.toolboxmodel.Layoutinformationen.PlanPro_Layoutinfo;
import org.eclipse.set.toolboxmodel.PlanPro.DocumentRoot;
import org.eclipse.set.toolboxmodel.PlanPro.PlanProFactory;
import org.eclipse.set.toolboxmodel.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.set.utils.events.DataEvent;
import org.eclipse.set.utils.events.DefaultToolboxEventHandler;
import org.eclipse.set.utils.events.EditingCompleted;
import org.eclipse.set.utils.events.NewTableTypeEvent;
import org.eclipse.set.utils.events.SessionDirtyChanged;
import org.eclipse.set.utils.events.ToolboxEvent;
import org.eclipse.set.utils.events.ToolboxEvents;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelSession
implements IModelSession {
    private static final String APPLICATION_NAME = "Werkzeugkoffer";
    private static final String SESSIONS_SUBDIR = "sessions";
    protected static final String TITLE_SEPARATOR = " - ";
    static final Logger logger = LoggerFactory.getLogger(ModelSession.class);
    private EContentAdapter contentAdapter;
    private final Guid guid;
    private boolean isNewProject = false;
    private final DefaultToolboxEventHandler<NewTableTypeEvent> newTableTypeHandler;
    private PlanPro_Schnittstelle planPro_Schnittstelle;
    private final Map<Integer, Boolean> reportSavedDialogSuppressed = new HashMap<Integer, Boolean>();
    private final SessionService sessionService;
    private double symbolRotation;
    private final ToolboxPaths toolboxPaths;
    private boolean wasDirty = false;
    protected final Shell mainWindow;
    protected PlanProFileNature nature;
    protected ToolboxFile toolboxFile;
    protected ValidationResult schnittstelleValidationResult = new ValidationResult(PlanPro_Schnittstelle.class);
    ProjectInitializationData projectInitializationData;
    final ServiceProvider serviceProvider;
    TableType tableType = null;
    private IModelSession.SaveFixResult saveFixResult = IModelSession.SaveFixResult.NONE;
    protected ValidationResult layoutinfoValidationResult = null;

    private static String getSessionsSubDir() {
        return Paths.get(ToolboxConstants.TMP_BASE_DIR, SESSIONS_SUBDIR).toString();
    }

    public ModelSession(ToolboxFile toolboxFile, SessionService sessionService, Shell mainWindow, ServiceProvider serviceProvider) {
        this.sessionService = sessionService;
        this.toolboxFile = toolboxFile;
        this.mainWindow = mainWindow;
        this.serviceProvider = serviceProvider;
        final ModelSession session = this;
        EditingDomain editingDomain = toolboxFile.getEditingDomain();
        editingDomain.getCommandStack().addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                ModelSession.this.setTitleFilename(IModelSessionExtensions.getTitleFilename((IModelSession)session, (String)ModelSession.this.serviceProvider.messages.ModelSession_ChangeIndicator));
                ModelSession.this.serviceProvider.broker.post("org/eclipse/e4/ui/renderer/requestEnablementUpdate", (Object)"ALL");
                ModelSession.this.checkForDirtyEvent();
            }
        });
        this.guid = Guid.create();
        this.createTempDir();
        toolboxFile.setTemporaryDirectory(this.getTempDir());
        this.toolboxPaths = new ToolboxPathsImpl(this);
        this.newTableTypeHandler = new DefaultToolboxEventHandler<NewTableTypeEvent>(){

            public void accept(NewTableTypeEvent e) {
                ModelSession.this.tableType = e.getTableType();
                logger.debug("Global type is " + ModelSession.this.tableType.toString());
            }
        };
        ToolboxEvents.subscribe((IEventBroker)this.serviceProvider.broker, NewTableTypeEvent.class, this.newTableTypeHandler);
        logger.debug("created session {}", (Object)this);
    }

    public void addSymbolRotation(double rotation) {
        this.symbolRotation += rotation;
    }

    public void cancelMergeMode(Predicate<Path> confirmDeletion) throws UserAbortion, IOException {
        if (!this.isMergeMode()) {
            throw new IllegalStateException("Session not in merge mode.");
        }
        Path temporaryIntegrationPath = this.toolboxFile.getPath();
        if (!confirmDeletion.test(temporaryIntegrationPath)) {
            throw new UserAbortion();
        }
        this.close();
        this.toolboxFile.delete(true);
    }

    public void cleanUp() {
        try {
            FileUtils.deleteDirectory((File)Paths.get(ModelSession.getSessionsSubDir(), new String[0]).toFile());
            this.removeContentAdapter((EObject)this.getPlanProSchnittstelle());
            ToolboxEvents.unsubscribe((IEventBroker)this.serviceProvider.broker, this.newTableTypeHandler);
        }
        catch (IOException e) {
            logger.warn("clean up failed: exception={} message={}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        }
    }

    public void close() {
        this.getToolboxFile().getEditingDomain().getCommandStack().flush();
        this.setTitleFilename(null);
        this.sessionService.close((IModelSession)this);
    }

    public void discardChanges() {
        CommandStack commandStack = this.getEditingDomain().getCommandStack();
        while (commandStack.canUndo()) {
            commandStack.undo();
        }
        ToolboxEvents.send((IEventBroker)this.serviceProvider.broker, (ToolboxEvent)new EditingCompleted());
    }

    public void exitMergeMode(Shell shell) throws IOException, UserAbortion {
        if (!this.isMergeMode()) {
            throw new IllegalStateException("Session not in merge mode.");
        }
        ToolboxFile.Format mergedFileFormat = this.sessionService.getMergedFileFormat();
        Path modelPath = PlanProSchnittstelleExtensions.getDerivedPath((PlanPro_Schnittstelle)this.getPlanProSchnittstelle(), (String)this.getToolboxFile().getPath().getParent().toString(), (String)this.sessionService.getDefaultExtension(mergedFileFormat), (ExportType)ExportType.PLANNING_RECORDS);
        if (Files.exists(modelPath, new LinkOption[0]) && !this.serviceProvider.dialogService.confirmOverwrite(shell, modelPath)) {
            throw new UserAbortion();
        }
        ToolboxFile mergeFile = this.getToolboxFile();
        this.toolboxFile = this.serviceProvider.fileService.create(mergedFileFormat, ToolboxFileRole.EXPORT);
        this.toolboxFile.setTemporaryDirectory(this.getTempDir());
        this.toolboxFile.setPath(modelPath);
        PlanProSchnittstelleExtensions.getAttachments((PlanPro_Schnittstelle)this.getPlanProSchnittstelle()).forEach(anhang -> {
            try {
                this.toolboxFile.copyMedia(mergeFile, anhang.getIdentitaet().getWert());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        DocumentRoot documentRoot = PlanProFactory.eINSTANCE.createDocumentRoot();
        DocumentRootExtensions.fix((DocumentRoot)documentRoot);
        documentRoot.setPlanProSchnittstelle(this.getPlanProSchnittstelle());
        this.toolboxFile.getPlanProResource().getContents().add((Object)documentRoot);
        this.save(shell);
        mergeFile.delete(true);
        this.toolboxFile.close();
        this.toolboxFile.setRole(ToolboxFileRole.SESSION);
        this.init();
    }

    public MultiContainer_AttributeGroup getContainer(ContainerType container) {
        return PlanProSchnittstelleExtensions.getContainer((PlanPro_Schnittstelle)this.getPlanProSchnittstelle(), (ContainerType)container);
    }

    public EditingDomain getEditingDomain() {
        return this.getToolboxFile().getEditingDomain();
    }

    public String getGuid() {
        return this.guid.toString();
    }

    public Shell getMainWindow() {
        return this.mainWindow;
    }

    public Set<EObject> getModels() {
        return Collections.singleton(this.getPlanProSchnittstelle());
    }

    public PlanProFileNature getNature() {
        return this.nature;
    }

    public PlanPro_Schnittstelle getPlanProSchnittstelle() {
        return this.planPro_Schnittstelle;
    }

    public ServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    public double getSymbolRotation() {
        return this.symbolRotation;
    }

    public TableType getTableType() {
        return this.tableType;
    }

    public Path getTempDir() {
        return Paths.get(ModelSession.getSessionsSubDir(), this.getGuid());
    }

    public ToolboxFile getToolboxFile() {
        return this.toolboxFile;
    }

    public ToolboxPaths getToolboxPaths() {
        return this.toolboxPaths;
    }

    public ValidationResult getValidationResult(Class<? extends EObject> sourceClass) {
        if (sourceClass.isAssignableFrom(PlanPro_Schnittstelle.class)) {
            return this.schnittstelleValidationResult;
        }
        if (sourceClass.isAssignableFrom(PlanPro_Layoutinfo.class)) {
            return this.layoutinfoValidationResult;
        }
        return null;
    }

    public ValidationResult.Outcome getValidationsOutcome(Function<ValidationResult, ValidationResult.Outcome> outcome) {
        Stream<ValidationResult> resultsStream = Stream.of(this.schnittstelleValidationResult, this.layoutinfoValidationResult).filter(Objects::nonNull);
        if (resultsStream.anyMatch(result -> outcome.apply((ValidationResult)result) == ValidationResult.Outcome.INVALID)) {
            return ValidationResult.Outcome.INVALID;
        }
        return ValidationResult.Outcome.VALID;
    }

    public void init() {
        block10: {
            try {
                try {
                    this.nature = PlanProFileNature.INVALID;
                    if (this.getToolboxFile().isLoadable()) {
                        this.readModel();
                        logger.info("Read PlanPro model {}", (Object)this.getToolboxFile().getPath());
                        break block10;
                    }
                    this.createEmptyModel();
                    this.setDefaultValues();
                    logger.info("New PlanPro model created.");
                }
                catch (IOException e) {
                    this.serviceProvider.dialogService.error(this.mainWindow, (Exception)e);
                    if (this.getPlanProSchnittstelle() != null) {
                        this.setNature();
                        if (ToolboxConfiguration.isDevelopmentMode()) {
                            PlanProSchnittstelleDebugExtensions.validateTopKanten((PlanPro_Schnittstelle)this.getPlanProSchnittstelle());
                        }
                    }
                }
            }
            finally {
                if (this.getPlanProSchnittstelle() != null) {
                    this.setNature();
                    if (ToolboxConfiguration.isDevelopmentMode()) {
                        PlanProSchnittstelleDebugExtensions.validateTopKanten((PlanPro_Schnittstelle)this.getPlanProSchnittstelle());
                    }
                }
            }
        }
    }

    public boolean isDirty() {
        return this.getEditingDomain().getCommandStack().canUndo();
    }

    public boolean isLoaded() {
        return this.getPlanProSchnittstelle() != null;
    }

    public boolean isMergeMode() {
        return false;
    }

    public boolean isNewProject() {
        return this.isNewProject;
    }

    public boolean isReportSavedDialogSuppressed(int kind) {
        return this.reportSavedDialogSuppressed.getOrDefault(kind, Boolean.FALSE);
    }

    public void refreshValidation() {
        this.toolboxFile.clearXMLDocument();
        this.init();
    }

    public void revert() {
        CommandStack commandStack = this.getEditingDomain().getCommandStack();
        while (commandStack.canUndo()) {
            commandStack.undo();
        }
        this.setTitleFilename();
        ToolboxEvents.send((IEventBroker)this.serviceProvider.broker, (ToolboxEvent)new EditingCompleted());
        this.refreshValidation();
    }

    public boolean save(Shell shell) throws UserAbortion {
        return this.save(shell, true);
    }

    public boolean save(Shell shell, boolean askUser) throws UserAbortion {
        return this.savePlanPro(shell, askUser);
    }

    public boolean saveNew(Shell shell) throws UserAbortion {
        return this.saveNewPlanPro(shell);
    }

    public void setNewProject(boolean val) {
        this.isNewProject = val;
    }

    public void setNewProjectData(ProjectInitializationData data) {
        this.projectInitializationData = data;
    }

    public void setReportSavedDialogSuppressed(int kind, boolean value) {
        this.reportSavedDialogSuppressed.put(kind, value);
    }

    public String toString() {
        return String.format("%s {guid=%s location=%s}", super.toString(), this.getGuid(), this.getToolboxFile().getPath());
    }

    private void addContentAdapter(EObject object) {
        if (object != null) {
            this.contentAdapter = new EContentAdapter(){

                public void notifyChanged(Notification notification) {
                    super.notifyChanged(notification);
                    ModelSession.this.sendDataEvent(notification);
                }
            };
            object.eAdapters().add((Object)this.contentAdapter);
        }
    }

    private void createTempDir() {
        try {
            this.cleanUp();
            FileUtils.forceMkdir((File)this.getTempDir().toFile());
        }
        catch (IOException e) {
            logger.warn("creation of tmp dir failed: exception={} message={}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        }
    }

    private void readMergeModel() throws IOException {
        this.toolboxFile.openModel();
    }

    private void readPlanProModel() {
        this.schnittstelleValidationResult = new ValidationResult(PlanPro_Schnittstelle.class);
        this.setPlanProSchnittstelle((PlanPro_Schnittstelle)this.serviceProvider.validationService.checkLoad(this.getToolboxFile(), path -> {
            this.getToolboxFile().openModel();
            return this.toolboxFile.getPlanProResource();
        }, PlanProSchnittstelleExtensions::readFrom, this.schnittstelleValidationResult));
        this.schnittstelleValidationResult = this.serviceProvider.validationService.validateSource(this.schnittstelleValidationResult, this.getToolboxFile());
    }

    private void readLayoutInformationen() {
        Path layoutPath = this.getToolboxFile().getLayoutPath();
        if (layoutPath != null && layoutPath.toFile().exists()) {
            this.layoutinfoValidationResult = new ValidationResult(PlanPro_Layoutinfo.class);
            this.serviceProvider.validationService.checkLoad(this.getToolboxFile(), path -> {
                this.getToolboxFile().openLayout();
                return this.toolboxFile.getLayoutResource();
            }, null, this.layoutinfoValidationResult);
            this.layoutinfoValidationResult = this.serviceProvider.validationService.validateSource(new ValidationResult(PlanPro_Layoutinfo.class), this.toolboxFile);
        }
    }

    private void removeContentAdapter(EObject object) {
        if (object != null && this.contentAdapter != null) {
            object.eAdapters().remove((Object)this.contentAdapter);
        }
    }

    private boolean saveNewPlanPro(Shell shell) throws UserAbortion {
        try {
            boolean overwriteConfirmed;
            Path path = PlanProSchnittstelleExtensions.getDerivedPath((PlanPro_Schnittstelle)this.getPlanProSchnittstelle(), (String)this.projectInitializationData.getDirectory(), (String)((String)this.serviceProvider.fileService.extensionsForCategory("ppfile").get(0)), (ExportType)ExportType.PLANNING_RECORDS);
            if (Files.exists(path, new LinkOption[0]) && !(overwriteConfirmed = this.serviceProvider.dialogService.confirmOverwrite(shell, path))) {
                throw new UserAbortion();
            }
            DocumentRoot documentRoot = PlanProSchnittstelleExtensions.getDocumentRoot((PlanPro_Schnittstelle)this.getPlanProSchnittstelle());
            XMLResource resource = this.toolboxFile.getPlanProResource();
            resource.getContents().add((Object)documentRoot);
            this.toolboxFile.save();
            this.setNewProject(false);
            this.setTitleFilename();
            this.refreshValidation();
        }
        catch (IOException e) {
            Display.getDefault().syncExec(() -> this.serviceProvider.dialogService.error(shell, (Exception)e));
            return false;
        }
        return true;
    }

    private boolean savePlanPro(Shell shell, boolean askUser) throws UserAbortion {
        try {
            DocumentRoot documentRoot = PlanProSchnittstelleExtensions.getDocumentRoot((PlanPro_Schnittstelle)this.getPlanProSchnittstelle());
            if (documentRoot != null) {
                DocumentRootExtensions.fix((DocumentRoot)documentRoot);
            }
            PlanProSchnittstelleExtensions.fix((PlanPro_Schnittstelle)this.getPlanProSchnittstelle());
            this.saveFixResult = IModelSession.SaveFixResult.NONE;
            if (PlanProSchnittstelleExtensions.containsUnfilledManagementValues((PlanPro_Schnittstelle)this.getPlanProSchnittstelle(), (XMLResource)this.toolboxFile.getPlanProResource()) && this.serviceProvider.dialogService.confirmSetDefaultsManagement(shell)) {
                PlanProSchnittstelleExtensions.fixManagementDefaults((PlanPro_Schnittstelle)this.planPro_Schnittstelle);
                this.saveFixResult = IModelSession.SaveFixResult.OBJEKTMANAGEMENT;
            }
            PlanProSchnittstelleExtensions.updateErzeugung((PlanPro_Schnittstelle)this.getPlanProSchnittstelle(), (String)APPLICATION_NAME, (EditingDomain)this.getToolboxFile().getEditingDomain());
            Path oldPath = this.getToolboxFile().getPath();
            String directory = oldPath.getParent().toString();
            String extension = PathExtensions.getExtension((Path)oldPath);
            Path newPath = PlanProSchnittstelleExtensions.getDerivedPath((PlanPro_Schnittstelle)this.getPlanProSchnittstelle(), (String)directory, (String)extension, (ExportType)ExportType.PLANNING_RECORDS);
            if (oldPath.equals(newPath)) {
                this.saveProcessDialog(shell, this.toolboxFile);
            } else {
                this.toolboxFile = this.serviceProvider.renameService.save(shell, this.toolboxFile, this.getPlanProSchnittstelle(), askUser, newToolboxFile -> this.saveProcessDialog(shell, (ToolboxFile)newToolboxFile));
            }
            this.setTitleFilename();
            ToolboxEvents.send((IEventBroker)this.serviceProvider.broker, (ToolboxEvent)new EditingCompleted());
            this.refreshValidation();
            this.serviceProvider.dialogService.reportSavedSession(shell, (IModelSession)this);
        }
        catch (IOException e) {
            this.serviceProvider.dialogService.error(shell, (Exception)e);
            return false;
        }
        return true;
    }

    private void saveProcessDialog(Shell shell, ToolboxFile toolbox) {
        DialogService dialogService = this.serviceProvider.dialogService;
        dialogService.showProgressUISync(shell, this.serviceProvider.messages.SaveToolboxFile, () -> {
            try {
                toolbox.save();
            }
            catch (IOException e) {
                dialogService.error(shell, (Exception)e);
            }
        });
    }

    private void setPlanProSchnittstelle(PlanPro_Schnittstelle schnittstelle) {
        this.removeContentAdapter((EObject)this.getPlanProSchnittstelle());
        this.planPro_Schnittstelle = schnittstelle;
        this.addContentAdapter((EObject)this.getPlanProSchnittstelle());
        this.setTitleFilename();
    }

    protected void createEmptyModel() {
        this.setNewProject(true);
        DocumentRoot documentRoot = PlanProFactory.eINSTANCE.createDocumentRoot();
        this.serviceProvider.initializationService.init((Object)documentRoot, new InitializationStep.Configuration(){

            public BrandingService getBrandingService() {
                return ModelSession.this.serviceProvider.brandingService;
            }

            public Object getData() {
                return ModelSession.this.projectInitializationData;
            }
        });
        this.setPlanProSchnittstelle(documentRoot.getPlanProSchnittstelle());
        ToolboxFile.Format format = this.toolboxFile.getFormat();
        Path path = PlanProSchnittstelleExtensions.getDerivedPath((PlanPro_Schnittstelle)this.getPlanProSchnittstelle(), (String)this.projectInitializationData.getDirectory(), (String)this.sessionService.getDefaultExtension(format), (ExportType)ExportType.PLANNING_RECORDS);
        this.toolboxFile.setPath(path);
        XMLResource resource = this.toolboxFile.getPlanProResource();
        resource.eAdapters().add((Object)new AdapterFactoryEditingDomain.EditingDomainProvider(this.toolboxFile.getEditingDomain()));
        resource.getContents().add((Object)documentRoot);
    }

    protected void readModel() throws IOException {
        if (this.toolboxFile.getFormat().isTemporaryIntegration()) {
            this.readMergeModel();
        } else {
            this.readPlanProModel();
            this.readLayoutInformationen();
        }
    }

    protected void setDefaultValues() {
        this.serviceProvider.defaultValueService.setDefaultValues(this.getPlanProSchnittstelle());
    }

    protected void setNature() {
        try {
            this.nature = this.isMergeMode() ? PlanProFileNature.INTEGRATION : (PlanProSchnittstelleExtensions.LSTPlanungProjekt((PlanPro_Schnittstelle)this.getPlanProSchnittstelle()) != null ? PlanProFileNature.PLANNING : PlanProFileNature.INFORMATION_STATE);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected void setTitleFilename() {
        this.setTitleFilename(IModelSessionExtensions.getTitleFilename((IModelSession)this, (String)this.serviceProvider.messages.ModelSession_ChangeIndicator));
    }

    void checkForDirtyEvent() {
        boolean dirty = this.isDirty();
        if (this.wasDirty != dirty) {
            ToolboxEvents.send((IEventBroker)this.serviceProvider.broker, (ToolboxEvent)new SessionDirtyChanged((IModelSession)this, dirty));
            this.wasDirty = dirty;
        }
    }

    void sendDataEvent(Notification notification) {
        if (notification.getEventType() == 8) {
            return;
        }
        DataEventTransformation transformation = new DataEventTransformation();
        Set<DataEvent> dataEvents = transformation.transform(notification);
        dataEvents.forEach(e -> ToolboxEvents.send((IEventBroker)this.serviceProvider.broker, (ToolboxEvent)e));
    }

    void setTitleFilename(final String filename) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                String title = ModelSession.this.mainWindow.getText();
                String[] split = title.split(ModelSession.TITLE_SEPARATOR);
                String titleProgrammPart = split[0];
                if (filename != null) {
                    ModelSession.this.mainWindow.setText(titleProgrammPart + ModelSession.TITLE_SEPARATOR + filename);
                } else {
                    ModelSession.this.mainWindow.setText(titleProgrammPart);
                }
            }
        });
    }

    public IModelSession.SaveFixResult getSaveFixResult() {
        return this.saveFixResult;
    }

    public boolean isSingleState() {
        if (!this.isLoaded()) {
            return false;
        }
        return this.getPlanProSchnittstelle().getLSTZustand() != null;
    }

    public static class ServiceProvider {
        @Inject
        public MApplication application;
        @Inject
        public BrandingService brandingService;
        @Inject
        public IEventBroker broker;
        @Inject
        public CacheService cacheService;
        @Inject
        public DefaultValueService defaultValueService;
        @Inject
        public DialogService dialogService;
        @Inject
        public ToolboxFileService fileService;
        @Inject
        public InitializationService initializationService;
        @Inject
        @Translation
        public Messages messages;
        @Inject
        public RenameService renameService;
        @Inject
        public SessionService sessionService;
        @Inject
        public ToolboxPartService toolboxPartService;
        @Inject
        public ValidationService validationService;
    }
}

