/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.validation.utils;

import java.io.IOException;
import java.nio.file.Path;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.set.basis.files.ToolboxFile;
import org.eclipse.set.feature.validation.utils.ObjectMetadataXMLReader;
import org.eclipse.set.utils.xml.LineNumberXMLReader;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLNodeFinder {
    Node rootNode;

    public Node findNodeByLineNumber(int lineNumber) {
        return this.findNodeByLineNumber(this.rootNode, lineNumber);
    }

    private Node findNodeByLineNumber(Node currentNode, int lineNumber) {
        if (currentNode == null) {
            return null;
        }
        NodeList children = currentNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (XMLNodeFinder.isLineNumberInNode(lineNumber, node)) {
                return this.findNodeByLineNumber(node, lineNumber);
            }
            ++i;
        }
        return currentNode;
    }

    public Node findFirstNodeByNodeName(String nodeName) {
        return this.findFirstNodeByNodeName(this.rootNode, nodeName);
    }

    public Node findFirstNodeByNodeName(Node node, String nodeName) {
        if (node == null) {
            return null;
        }
        if (node.getNodeName().equals(nodeName)) {
            return node;
        }
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node childNode = this.findFirstNodeByNodeName(nodeList.item(i), nodeName);
            if (childNode != null) {
                return childNode;
            }
            ++i;
        }
        return null;
    }

    private static boolean isLineNumberInNode(int lineNumber, Node node) {
        int start = LineNumberXMLReader.getLineNumber((Node)node);
        if (lineNumber < start) {
            return false;
        }
        int end = LineNumberXMLReader.getNodeLastLineNumber((Node)node);
        return lineNumber <= end || end == -1;
    }

    public void read(ToolboxFile toolboxfile, Path docPath) {
        try {
            this.rootNode = ObjectMetadataXMLReader.read(toolboxfile, docPath);
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            // empty catch block
        }
    }
}

