/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.projectdata.edit;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.constants.PlanProFileNature;
import org.eclipse.set.basis.exceptions.UserAbortion;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.core.services.viewmodel.ToolboxViewModelService;
import org.eclipse.set.feature.projectdata.Messages;
import org.eclipse.set.feature.projectdata.autofill.DateAutofill;
import org.eclipse.set.feature.projectdata.edit.CopyNameButton;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.eclipse.set.toolboxmodel.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.toolboxmodel.PlanPro.Planung_Gruppe;
import org.eclipse.set.toolboxmodel.PlanPro.Planung_P_Allg_AttributeGroup;
import org.eclipse.set.toolboxmodel.PlanPro.Planung_Projekt;
import org.eclipse.set.utils.emfforms.AbstractTabViewPart;
import org.eclipse.set.utils.events.EditingCompleted;
import org.eclipse.set.utils.events.ProjectDataChanged;
import org.eclipse.set.utils.events.ToolboxEvent;
import org.eclipse.set.utils.events.ToolboxEvents;
import org.eclipse.set.utils.exception.ExceptionHandler;
import org.eclipse.set.utils.widgets.ButtonRow;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ProjectPart
extends AbstractTabViewPart {
    private static final String COPY_DATE_TRIGGER = "copyDateTrigger";
    private static final String COPY_NAME = "copyName";
    @Inject
    @Translation
    private org.eclipse.set.utils.Messages utilMessages;
    @Inject
    @Translation
    protected Messages messages;
    @Inject
    EnumTranslationService enumTranslationService;
    CommandStackListener stackListener;
    @Inject
    ToolboxViewModelService viewModelService;
    private CopyNameButton copyNameButton;
    private DateAutofill dateAutofill;
    private Planung_Projekt planingProject;
    private CTabFolder cTabFolder;
    private final List<CTabItem> tabItems = new LinkedList<CTabItem>();

    @Inject
    public ProjectPart() {
    }

    protected void createView(Composite parent) {
        IModelSession session = this.getModelSession();
        if (session.getNature() != PlanProFileNature.INFORMATION_STATE) {
            this.planingProject = PlanProSchnittstelleExtensions.LSTPlanungProjekt((PlanPro_Schnittstelle)session.getPlanProSchnittstelle());
            Assert.isNotNull((Object)this.planingProject);
            this.copyNameButton = new CopyNameButton(this.messages, ProjectPart.shouldCopyNameButtonEnable(this.planingProject));
            this.viewModelService.put(COPY_NAME, (Object)this.copyNameButton);
            this.createDateAutoFill(parent, session, this.planingProject);
            try {
                this.cTabFolder = this.createTabFolder(parent);
                this.setDefaultSelectionTab(this.cTabFolder);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.createButtonRow(parent);
            this.getModelSession().getEditingDomain().getCommandStack().addCommandStackListener(this.stackListener);
        } else {
            Label tip = new Label(parent, 16779328);
            GridData data = new GridData(256, 128, true, false, 1, 1);
            tip.setLayoutData((Object)data);
            tip.setText(this.messages.ProjectPart_noPlanning);
        }
    }

    protected void createTabItem(CTabFolder folder) {
        this.createPlanungProjektAllgemeinTab(folder, this.planingProject.getPlanungPAllg());
        this.createPlanungGruppeTabs(folder, (EList<Planung_Gruppe>)this.planingProject.getLSTPlanungGruppe());
    }

    protected void handleProjectDataChanged(ProjectDataChanged e) {
        Notification notification = e.getNotification();
        if (notification.getEventType() != 1) {
            return;
        }
        this.copyNameButton.refresh(notification);
    }

    private static boolean shouldCopyNameButtonEnable(Planung_Projekt planungProject) {
        String nameAkteur = "";
        try {
            nameAkteur = planungProject.getPlanungPAllg().getProjektleiter().getAkteurAllg().getNameAkteur().getWert();
        }
        catch (NullPointerException e) {
            return false;
        }
        return nameAkteur != null && !nameAkteur.isBlank();
    }

    private void createPlanungProjektAllgemeinTab(CTabFolder folder, Planung_P_Allg_AttributeGroup pAllg) {
        CTabItem cTabItem = new CTabItem(folder, 1024);
        cTabItem.setText("Projekt");
        this.tabItems.add(cTabItem);
        this.tabItemToObject.put(cTabItem, pAllg);
        this.tabItemToComposite.put(cTabItem, new ScrolledComposite((Composite)folder, 768));
    }

    private void createPlanungGruppeTabs(CTabFolder folder, EList<Planung_Gruppe> lstPlanungGruppe) {
        lstPlanungGruppe.forEach(group -> {
            CTabItem cTabItem = new CTabItem(folder, 1024);
            String gruppeName = "";
            try {
                gruppeName = this.enumTranslationService.translate((Enumerator)group.getPlanungGAllg().getUntergewerkArt().getWert()).getPresentation();
            }
            catch (Exception e) {
                this.getDialogService().error(this.getToolboxShell(), e);
            }
            cTabItem.setText(gruppeName);
            this.tabItems.add(cTabItem);
            this.dateAutofill.setGroup((Planung_Gruppe)group);
            this.tabItemToObject.put(cTabItem, group);
            this.tabItemToComposite.put(cTabItem, new ScrolledComposite((Composite)folder, 768));
        });
    }

    private void createDateAutoFill(Composite parent, IModelSession session, Planung_Projekt element) {
        this.dateAutofill = new DateAutofill(date -> this.getDialogService().doApplyAutofill(this.getToolboxShell(), date), (Consumer<Exception>)new ExceptionHandler(this.getToolboxShell(), this.getDialogService()));
        Consumer<Text> dateAutofillConsumer = this.dateAutofill.getTextConsumer();
        this.viewModelService.put(COPY_DATE_TRIGGER, dateAutofillConsumer);
        this.dateAutofill.setEditingDomain(session.getEditingDomain());
        this.dateAutofill.setPlanning((Control)parent, element);
    }

    private void createButtonRow(Composite parent) {
        ButtonRow buttonRow = new ButtonRow(parent);
        Button discardButton = this.createDiscardButton(buttonRow);
        Button saveButton = this.createSaveButton(buttonRow);
        Composite rowComposite = buttonRow.getComposite();
        rowComposite.setLayoutData((Object)new GridData(4, 1024, true, false, 1, 1));
        this.stackListener = event -> {
            discardButton.setEnabled(this.getModelSession().isDirty());
            saveButton.setEnabled(this.getModelSession().isDirty());
        };
    }

    private Button createDiscardButton(ButtonRow buttonRow) {
        Button discardButton = buttonRow.add(this.messages.ProjectPart_discardChanges);
        discardButton.setEnabled(this.getModelSession().isDirty());
        discardButton.addDisposeListener(event -> this.getModelSession().getEditingDomain().getCommandStack().removeCommandStackListener(this.stackListener));
        discardButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ProjectPart.this.dateAutofill.setEnable(false);
                ProjectPart.this.discardChanges();
                ProjectPart.this.dateAutofill.setEnable(true);
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        return discardButton;
    }

    private Button createSaveButton(ButtonRow buttonRow) {
        Button saveButton = buttonRow.add(this.messages.ProjectPart_save);
        saveButton.setEnabled(this.getModelSession().isDirty());
        saveButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ProjectPart.this.save();
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        return saveButton;
    }

    @Persist
    void save() {
        try {
            this.getModelSession().save(this.getToolboxShell());
        }
        catch (UserAbortion userAbortion) {
            // empty catch block
        }
    }

    public void discardChanges() {
        CommandStack commandStack = this.getModelSession().getEditingDomain().getCommandStack();
        while (commandStack.canUndo()) {
            commandStack.undo();
        }
        ToolboxEvents.send((IEventBroker)this.getBroker(), (ToolboxEvent)new EditingCompleted());
    }
}

