/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.set.basis.graph.DirectedEdge;
import org.eclipse.set.basis.graph.DirectedEdgePath;
import org.eclipse.set.ppmodel.extensions.BasisObjektExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektTopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.TopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.utils.CollectionExtensions;
import org.eclipse.set.ppmodel.extensions.utils.Debug;
import org.eclipse.set.ppmodel.extensions.utils.Distance;
import org.eclipse.set.ppmodel.extensions.utils.TopKantePath;
import org.eclipse.set.toolboxmodel.Basisobjekte.Begrenzung_A_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Begrenzung_B_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Bereich_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Bereich_Objekt_Teilbereich_AttributeGroup;
import org.eclipse.set.toolboxmodel.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Knoten;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BereichObjektExtensions
extends BasisObjektExtensions {
    private static final Logger logger = LoggerFactory.getLogger(BereichObjektExtensions.class);

    public static DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> getPath(Bereich_Objekt bereich, Punkt_Objekt_TOP_Kante_AttributeGroup start, Punkt_Objekt_TOP_Kante_AttributeGroup end) {
        return new TopKantePath(bereich, start, end);
    }

    public static DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> getPath(Bereich_Objekt bereich, Punkt_Objekt start, Punkt_Objekt end) {
        Set<Punkt_Objekt_TOP_Kante_AttributeGroup> s = BereichObjektExtensions.intersection(bereich, start);
        Set<Punkt_Objekt_TOP_Kante_AttributeGroup> e = BereichObjektExtensions.intersection(bereich, end);
        boolean _isEmpty = s.isEmpty();
        if (_isEmpty) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("start: topKante=");
            String _wert = CollectionExtensions.getUnique(PunktObjektExtensions.getTopKanten(start)).getIdentitaet().getWert();
            _builder.append(_wert);
            _builder.append(" abstand=");
            BigDecimal _wert_1 = PunktObjektExtensions.getSinglePoint(start).getAbstand().getWert();
            _builder.append((Object)_wert_1);
            logger.error(_builder.toString());
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("bereichObjektTeilbereich: ");
            String _debugString = Debug.debugString(bereich.getBereichObjektTeilbereich());
            _builder_1.append(_debugString);
            logger.error(_builder_1.toString());
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("Startsignal ");
            String _debugString_1 = Debug.debugString(start);
            _builder_2.append(_debugString_1);
            _builder_2.append(" not in Bereich ");
            String _debugName = Debug.debugName(bereich);
            _builder_2.append(_debugName);
            throw new IllegalArgumentException(_builder_2.toString());
        }
        boolean _isEmpty_1 = e.isEmpty();
        if (_isEmpty_1) {
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("Zielelement ");
            String _debugString_2 = Debug.debugString(end);
            _builder_3.append(_debugString_2);
            _builder_3.append(" not in Bereich ");
            String _debugName_1 = Debug.debugName(bereich);
            _builder_3.append(_debugName_1);
            throw new IllegalArgumentException(_builder_3.toString());
        }
        Punkt_Objekt_TOP_Kante_AttributeGroup _unique = CollectionExtensions.getUnique(s);
        Punkt_Objekt_TOP_Kante_AttributeGroup _unique_1 = CollectionExtensions.getUnique(e);
        return new TopKantePath(bereich, _unique, _unique_1);
    }

    public static Set<TOP_Kante> getTopKanten(Bereich_Objekt bereich) {
        Functions.Function1<Bereich_Objekt_Teilbereich_AttributeGroup, TOP_Kante> _function = new Functions.Function1<Bereich_Objekt_Teilbereich_AttributeGroup, TOP_Kante>(){

            public TOP_Kante apply(Bereich_Objekt_Teilbereich_AttributeGroup it) {
                return BereichObjektExtensions.getTopKante(it);
            }
        };
        return IterableExtensions.toSet((Iterable)ListExtensions.map((List)bereich.getBereichObjektTeilbereich(), (Functions.Function1)_function));
    }

    public static BigDecimal getLength(Bereich_Objekt bereich) {
        Functions.Function2<BigDecimal, Bereich_Objekt_Teilbereich_AttributeGroup, BigDecimal> _function = new Functions.Function2<BigDecimal, Bereich_Objekt_Teilbereich_AttributeGroup, BigDecimal>(){

            public BigDecimal apply(BigDecimal current, Bereich_Objekt_Teilbereich_AttributeGroup portion) {
                BigDecimal _length = BereichObjektExtensions.getLength(portion);
                return current.add(_length);
            }
        };
        return (BigDecimal)IterableExtensions.fold((Iterable)bereich.getBereichObjektTeilbereich(), (Object)BigDecimal.valueOf(0L), (Functions.Function2)_function);
    }

    public static TOP_Kante getTopKanteFor(Bereich_Objekt bereich, final Collection<Punkt_Objekt_TOP_Kante_AttributeGroup> singlePoints) {
        boolean _notEquals;
        Functions.Function1<TOP_Kante, Boolean> _function = new Functions.Function1<TOP_Kante, Boolean>(){

            public Boolean apply(final TOP_Kante e) {
                Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Boolean> _function = new Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Boolean>(){

                    public Boolean apply(Punkt_Objekt_TOP_Kante_AttributeGroup it) {
                        return TopKanteExtensions.isConnectedTo(e, it);
                    }
                };
                return IterableExtensions.exists((Iterable)singlePoints, (Functions.Function1)_function);
            }
        };
        List topKanten = IterableExtensions.toList((Iterable)IterableExtensions.filter(BereichObjektExtensions.getTopKanten(bereich), (Functions.Function1)_function));
        boolean _isEmpty = topKanten.isEmpty();
        if (_isEmpty) {
            return null;
        }
        int _size = topKanten.size();
        boolean bl = _notEquals = _size != 1;
        if (_notEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("bereich=");
            String _debugString = Debug.debugString(bereich);
            _builder.append(_debugString);
            _builder.append(" punktObjekte=");
            Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, String> _function_1 = new Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, String>(){

                public String apply(Punkt_Objekt_TOP_Kante_AttributeGroup it) {
                    return Debug.debugString(PunktObjektTopKanteExtensions.getPunktObjekt(it));
                }
            };
            Set _set = IterableExtensions.toSet((Iterable)IterableExtensions.map(singlePoints, (Functions.Function1)_function_1));
            _builder.append((Object)_set);
            _builder.append(" topKanten=");
            String _debugString_1 = Debug.debugString(topKanten);
            _builder.append(_debugString_1);
            throw new IllegalArgumentException(_builder.toString());
        }
        return (TOP_Kante)topKanten.get(0);
    }

    public static boolean intersects(Bereich_Objekt bereich, Punkt_Objekt punktObjekt) {
        boolean _isEmpty = BereichObjektExtensions.intersection(bereich, punktObjekt).isEmpty();
        return !_isEmpty;
    }

    public static boolean intersects(Bereich_Objekt bereich, DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt> path) {
        boolean _isEmpty = BereichObjektExtensions.intersection(bereich, path).isEmpty();
        return !_isEmpty;
    }

    public static boolean areaIntersects(Bereich_Objekt bereich, final DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> path) {
        Functions.Function1<Bereich_Objekt_Teilbereich_AttributeGroup, Boolean> _function = new Functions.Function1<Bereich_Objekt_Teilbereich_AttributeGroup, Boolean>(){

            public Boolean apply(Bereich_Objekt_Teilbereich_AttributeGroup it) {
                return BereichObjektExtensions.areaIntersects(it, (DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>)path);
            }
        };
        boolean result = IterableExtensions.exists((Iterable)bereich.getBereichObjektTeilbereich(), (Functions.Function1)_function);
        boolean _isDebugEnabled = logger.isDebugEnabled();
        if (_isDebugEnabled) {
            StringConcatenation _builder = new StringConcatenation();
            String _debugName = Debug.debugName(bereich);
            _builder.append(_debugName);
            _builder.append(" areaIntersects ");
            String _debugNodesAndEdges = Debug.debugNodesAndEdges(path);
            _builder.append(_debugNodesAndEdges);
            _builder.append(" = ");
            _builder.append((Object)result);
            logger.debug(_builder.toString());
        }
        return result;
    }

    public static boolean intersects(Bereich_Objekt bereich, final Bereich_Objekt other) {
        Functions.Function1<Bereich_Objekt_Teilbereich_AttributeGroup, Boolean> _function = new Functions.Function1<Bereich_Objekt_Teilbereich_AttributeGroup, Boolean>(){

            public Boolean apply(Bereich_Objekt_Teilbereich_AttributeGroup it) {
                return BereichObjektExtensions.intersects(other, it);
            }
        };
        return IterableExtensions.exists((Iterable)bereich.getBereichObjektTeilbereich(), (Functions.Function1)_function);
    }

    public static boolean intersects(Bereich_Objekt bereich, final Bereich_Objekt_Teilbereich_AttributeGroup teilbereich) {
        Functions.Function1<Bereich_Objekt_Teilbereich_AttributeGroup, Boolean> _function = new Functions.Function1<Bereich_Objekt_Teilbereich_AttributeGroup, Boolean>(){

            public Boolean apply(Bereich_Objekt_Teilbereich_AttributeGroup it) {
                return BereichObjektExtensions.intersects(it, teilbereich);
            }
        };
        return IterableExtensions.exists((Iterable)bereich.getBereichObjektTeilbereich(), (Functions.Function1)_function);
    }

    public static boolean intersects(Bereich_Objekt_Teilbereich_AttributeGroup teilbereich, Bereich_Objekt_Teilbereich_AttributeGroup other) {
        String _wert_1;
        boolean _notEquals;
        String _wert = BereichObjektExtensions.getTopKante(teilbereich).getIdentitaet().getWert();
        boolean bl = _notEquals = !Objects.equal((Object)_wert, (Object)(_wert_1 = BereichObjektExtensions.getTopKante(other).getIdentitaet().getWert()));
        if (_notEquals) {
            return false;
        }
        double tA = teilbereich.getBegrenzungA().getWert().doubleValue();
        double tB = teilbereich.getBegrenzungB().getWert().doubleValue();
        double oA = other.getBegrenzungA().getWert().doubleValue();
        double oB = other.getBegrenzungB().getWert().doubleValue();
        return BereichObjektExtensions.intersects(tA, tB, oA, oB);
    }

    protected static boolean intersects(double a1, double a2, double b1, double b2) {
        boolean _lessThan_1;
        boolean _lessThan;
        int _compare = Distance.compare(a1, a2);
        boolean _lessEqualsThan = _compare <= 0;
        Assert.isTrue((boolean)_lessEqualsThan);
        int _compare_1 = Distance.compare(b1, b2);
        boolean _lessEqualsThan_1 = _compare_1 <= 0;
        Assert.isTrue((boolean)_lessEqualsThan_1);
        int _compare_2 = Distance.compare(a2, b1);
        boolean bl = _lessThan = _compare_2 < 0;
        if (_lessThan) {
            return false;
        }
        int _compare_3 = Distance.compare(b2, a1);
        boolean bl2 = _lessThan_1 = _compare_3 < 0;
        return !_lessThan_1;
    }

    public static boolean intersectsStrictly(Bereich_Objekt bereich, final Bereich_Objekt other) {
        Functions.Function1<Bereich_Objekt_Teilbereich_AttributeGroup, Boolean> _function = new Functions.Function1<Bereich_Objekt_Teilbereich_AttributeGroup, Boolean>(){

            public Boolean apply(Bereich_Objekt_Teilbereich_AttributeGroup it) {
                return BereichObjektExtensions.intersectsStrictly(other, it);
            }
        };
        return IterableExtensions.exists((Iterable)bereich.getBereichObjektTeilbereich(), (Functions.Function1)_function);
    }

    public static boolean intersectsStrictly(Bereich_Objekt bereich, final Bereich_Objekt_Teilbereich_AttributeGroup teilbereich) {
        Functions.Function1<Bereich_Objekt_Teilbereich_AttributeGroup, Boolean> _function = new Functions.Function1<Bereich_Objekt_Teilbereich_AttributeGroup, Boolean>(){

            public Boolean apply(Bereich_Objekt_Teilbereich_AttributeGroup it) {
                return BereichObjektExtensions.intersectsStrictly(it, teilbereich);
            }
        };
        return IterableExtensions.exists((Iterable)bereich.getBereichObjektTeilbereich(), (Functions.Function1)_function);
    }

    public static boolean intersectsStrictly(Bereich_Objekt_Teilbereich_AttributeGroup teilbereich, Bereich_Objekt_Teilbereich_AttributeGroup other) {
        String _wert_1;
        boolean _notEquals;
        String _wert = BereichObjektExtensions.getTopKante(teilbereich).getIdentitaet().getWert();
        boolean bl = _notEquals = !Objects.equal((Object)_wert, (Object)(_wert_1 = BereichObjektExtensions.getTopKante(other).getIdentitaet().getWert()));
        if (_notEquals) {
            return false;
        }
        double tA = teilbereich.getBegrenzungA().getWert().doubleValue();
        double tB = teilbereich.getBegrenzungB().getWert().doubleValue();
        double oA = other.getBegrenzungA().getWert().doubleValue();
        double oB = other.getBegrenzungB().getWert().doubleValue();
        return BereichObjektExtensions.intersectsStrictly(tA, tB, oA, oB);
    }

    protected static boolean intersectsStrictly(double a1, double a2, double b1, double b2) {
        int _compare = Distance.compare(a1, a2);
        boolean _lessEqualsThan = _compare <= 0;
        Assert.isTrue((boolean)_lessEqualsThan);
        int _compare_1 = Distance.compare(b1, b2);
        boolean _lessEqualsThan_1 = _compare_1 <= 0;
        Assert.isTrue((boolean)_lessEqualsThan_1);
        int aEndBStart = Distance.compare(a2, b1);
        if (aEndBStart < 0) {
            return false;
        }
        int bEndAStart = Distance.compare(b2, a1);
        if (bEndAStart < 0) {
            return false;
        }
        if (aEndBStart == 0) {
            return bEndAStart == 0;
        }
        return true;
    }

    public static Set<Punkt_Objekt_TOP_Kante_AttributeGroup> intersection(final Bereich_Objekt bereich, Punkt_Objekt punktObjekt) {
        Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Boolean> _function = new Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Boolean>(){

            public Boolean apply(Punkt_Objekt_TOP_Kante_AttributeGroup it) {
                return BereichObjektExtensions.contains(bereich, it);
            }
        };
        return IterableExtensions.toSet((Iterable)IterableExtensions.filter(PunktObjektExtensions.getSinglePoints(punktObjekt), (Functions.Function1)_function));
    }

    public static Set<Punkt_Objekt_TOP_Kante_AttributeGroup> intersection(Bereich_Objekt bereich, DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt> path) {
        return BereichObjektExtensions.intersection(bereich, IteratorExtensions.toSet((Iterator)path.getPointIterator()));
    }

    public static Set<Punkt_Objekt_TOP_Kante_AttributeGroup> intersection(final Bereich_Objekt bereich, Set<Punkt_Objekt> punktObjekte) {
        Functions.Function1<Punkt_Objekt, List<Punkt_Objekt_TOP_Kante_AttributeGroup>> _function = new Functions.Function1<Punkt_Objekt, List<Punkt_Objekt_TOP_Kante_AttributeGroup>>(){

            public List<Punkt_Objekt_TOP_Kante_AttributeGroup> apply(Punkt_Objekt it) {
                return PunktObjektExtensions.getSinglePoints(it);
            }
        };
        Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Boolean> _function_1 = new Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Boolean>(){

            public Boolean apply(Punkt_Objekt_TOP_Kante_AttributeGroup it) {
                return BereichObjektExtensions.contains(bereich, it);
            }
        };
        return IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)Iterables.concat((Iterable)IterableExtensions.map(punktObjekte, (Functions.Function1)_function)), (Functions.Function1)_function_1));
    }

    public static boolean contains(Bereich_Objekt bereich, final Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        Functions.Function1<Bereich_Objekt_Teilbereich_AttributeGroup, Boolean> _function = new Functions.Function1<Bereich_Objekt_Teilbereich_AttributeGroup, Boolean>(){

            public Boolean apply(Bereich_Objekt_Teilbereich_AttributeGroup it) {
                return BereichObjektExtensions.contains(it, singlePoint);
            }
        };
        return IterableExtensions.exists((Iterable)bereich.getBereichObjektTeilbereich(), (Functions.Function1)_function);
    }

    public static boolean contains(Bereich_Objekt_Teilbereich_AttributeGroup teilbereich, Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        boolean sameTopKante;
        Identitaet_TypeClass _identitaet = teilbereich.getIDTOPKante().getIdentitaet();
        String _wert = null;
        if (_identitaet != null) {
            _wert = _identitaet.getWert();
        }
        Identitaet_TypeClass _identitaet_1 = singlePoint.getIDTOPKante().getIdentitaet();
        String _wert_1 = null;
        if (_identitaet_1 != null) {
            _wert_1 = _identitaet_1.getWert();
        }
        if (sameTopKante = Objects.equal((Object)_wert, (Object)_wert_1)) {
            boolean _greaterThan;
            double B;
            double A = teilbereich.getBegrenzungA().getWert().doubleValue();
            int _compare = Distance.compare(A, B = teilbereich.getBegrenzungB().getWert().doubleValue());
            boolean bl = _greaterThan = _compare > 0;
            if (_greaterThan) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Teilbereich with Begrenzungen A=");
                _builder.append((Object)A);
                _builder.append(" B=");
                _builder.append((Object)B);
                throw new IllegalArgumentException(_builder.toString());
            }
            double abstand = singlePoint.getAbstand().getWert().doubleValue();
            return Distance.compare(A, abstand) <= 0 && Distance.compare(abstand, B) <= 0;
        }
        return false;
    }

    public static BigDecimal getLength(Bereich_Objekt_Teilbereich_AttributeGroup portion) {
        BigDecimal _wert = portion.getBegrenzungB().getWert();
        BigDecimal _wert_1 = portion.getBegrenzungA().getWert();
        return _wert.subtract(_wert_1);
    }

    public static TOP_Kante getTopKante(Bereich_Objekt_Teilbereich_AttributeGroup portion) {
        return portion.getIDTOPKante();
    }

    public static <T extends Punkt_Objekt> List<T> filterContained(final Bereich_Objekt bereich, Iterable<T> punktObjekte) {
        Functions.Function1 _function = new Functions.Function1<T, Boolean>(){

            public Boolean apply(T it) {
                return BereichObjektExtensions.intersects(bereich, it);
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter(punktObjekte, (Functions.Function1)_function));
    }

    private static boolean areaIntersects(final Bereich_Objekt_Teilbereich_AttributeGroup teilbereich, DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> path) {
        final List edges = path.getEdgeList();
        int size = edges.size();
        if (size == 0) {
            return false;
        }
        if (size == 1) {
            return BereichObjektExtensions.areaIntersects(teilbereich, (Punkt_Objekt_TOP_Kante_AttributeGroup)path.getStart(), (DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>)((DirectedEdge)edges.get(0)), (Punkt_Objekt_TOP_Kante_AttributeGroup)path.getEnd());
        }
        Functions.Function1<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Boolean> _function = new Functions.Function1<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Boolean>(){

            public Boolean apply(DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> it) {
                return it != IterableExtensions.head((Iterable)edges) && it != IterableExtensions.last((Iterable)edges);
            }
        };
        Iterable middleEdges = IterableExtensions.filter((Iterable)edges, (Functions.Function1)_function);
        return BereichObjektExtensions.areaIntersects(teilbereich, (Punkt_Objekt_TOP_Kante_AttributeGroup)path.getStart(), (DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>)((DirectedEdge)IterableExtensions.head((Iterable)edges))) || BereichObjektExtensions.areaIntersects(teilbereich, (DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>)((DirectedEdge)IterableExtensions.last((Iterable)edges)), (Punkt_Objekt_TOP_Kante_AttributeGroup)path.getEnd()) || IterableExtensions.exists((Iterable)middleEdges, (Functions.Function1)new Functions.Function1<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Boolean>(){

            public Boolean apply(DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> it) {
                return BereichObjektExtensions.areaIntersects(teilbereich, it);
            }
        });
    }

    private static boolean areaIntersects(Bereich_Objekt_Teilbereich_AttributeGroup teilbereich, Punkt_Objekt_TOP_Kante_AttributeGroup start, DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> edge, Punkt_Objekt_TOP_Kante_AttributeGroup end) {
        String _wert_1;
        boolean _notEquals;
        TOP_Kante tTopKante = BereichObjektExtensions.getTopKante(teilbereich);
        TOP_Kante eTopKante = (TOP_Kante)edge.getElement();
        String _wert = tTopKante.getIdentitaet().getWert();
        boolean bl = _notEquals = !Objects.equal((Object)_wert, (Object)(_wert_1 = eTopKante.getIdentitaet().getWert()));
        if (_notEquals) {
            return false;
        }
        double tA = teilbereich.getBegrenzungA().getWert().doubleValue();
        double tB = teilbereich.getBegrenzungB().getWert().doubleValue();
        Assert.isNotNull((Object)start);
        Assert.isNotNull((Object)end);
        double aStart = TopKanteExtensions.getAbstand(eTopKante, start);
        double aEnd = TopKanteExtensions.getAbstand(eTopKante, end);
        double eA = Math.min(aStart, aEnd);
        double eB = Math.max(aStart, aEnd);
        return BereichObjektExtensions.intersects(tA, tB, eA, eB);
    }

    private static boolean areaIntersects(Bereich_Objekt_Teilbereich_AttributeGroup teilbereich, Punkt_Objekt_TOP_Kante_AttributeGroup start, DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> edge) {
        boolean _not;
        String _wert_1;
        boolean _notEquals;
        TOP_Kante tTopKante = BereichObjektExtensions.getTopKante(teilbereich);
        TOP_Kante eTopKante = (TOP_Kante)edge.getElement();
        String _wert = tTopKante.getIdentitaet().getWert();
        boolean bl = _notEquals = !Objects.equal((Object)_wert, (Object)(_wert_1 = eTopKante.getIdentitaet().getWert()));
        if (_notEquals) {
            return false;
        }
        double tA = teilbereich.getBegrenzungA().getWert().doubleValue();
        double tB = teilbereich.getBegrenzungB().getWert().doubleValue();
        Assert.isNotNull((Object)start);
        double aStart = TopKanteExtensions.getAbstand(eTopKante, start);
        double aEnd = TopKanteExtensions.getLaenge(eTopKante);
        boolean _isForwards = edge.isForwards();
        boolean bl2 = _not = !_isForwards;
        if (_not) {
            aEnd = 0.0;
        }
        double eA = Math.min(aStart, aEnd);
        double eB = Math.max(aStart, aEnd);
        return BereichObjektExtensions.intersects(tA, tB, eA, eB);
    }

    private static boolean areaIntersects(Bereich_Objekt_Teilbereich_AttributeGroup teilbereich, DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> edge, Punkt_Objekt_TOP_Kante_AttributeGroup end) {
        boolean _not;
        String _wert_1;
        boolean _notEquals;
        TOP_Kante tTopKante = BereichObjektExtensions.getTopKante(teilbereich);
        TOP_Kante eTopKante = (TOP_Kante)edge.getElement();
        String _wert = tTopKante.getIdentitaet().getWert();
        boolean bl = _notEquals = !Objects.equal((Object)_wert, (Object)(_wert_1 = eTopKante.getIdentitaet().getWert()));
        if (_notEquals) {
            return false;
        }
        double tA = teilbereich.getBegrenzungA().getWert().doubleValue();
        double tB = teilbereich.getBegrenzungB().getWert().doubleValue();
        Assert.isNotNull((Object)end);
        double aStart = 0.0;
        boolean _isForwards = edge.isForwards();
        boolean bl2 = _not = !_isForwards;
        if (_not) {
            aStart = TopKanteExtensions.getLaenge(eTopKante);
        }
        double aEnd = TopKanteExtensions.getAbstand(eTopKante, end);
        double eA = Math.min(aStart, aEnd);
        double eB = Math.max(aStart, aEnd);
        return BereichObjektExtensions.intersects(tA, tB, eA, eB);
    }

    private static boolean areaIntersects(Bereich_Objekt_Teilbereich_AttributeGroup teilbereich, DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> edge) {
        TOP_Kante tTopKante = BereichObjektExtensions.getTopKante(teilbereich);
        TOP_Kante eTopKante = (TOP_Kante)edge.getElement();
        String _wert = tTopKante.getIdentitaet().getWert();
        String _wert_1 = eTopKante.getIdentitaet().getWert();
        return Objects.equal((Object)_wert, (Object)_wert_1);
    }

    public static boolean contains(Bereich_Objekt_Teilbereich_AttributeGroup teilbereich, TOP_Kante topKante, double distance) {
        String _wert_1;
        boolean _notEquals;
        Identitaet_TypeClass _identitaet = teilbereich.getIDTOPKante().getIdentitaet();
        String _wert = null;
        if (_identitaet != null) {
            _wert = _identitaet.getWert();
        }
        boolean bl = _notEquals = !Objects.equal((Object)_wert, (Object)(_wert_1 = topKante.getIdentitaet().getWert()));
        if (_notEquals) {
            return false;
        }
        double A = teilbereich.getBegrenzungA().getWert().doubleValue();
        double B = teilbereich.getBegrenzungB().getWert().doubleValue();
        return Distance.compare(A, distance) <= 0 && Distance.compare(distance, B) <= 0;
    }

    public static BigDecimal getOverlappingLength(Bereich_Objekt_Teilbereich_AttributeGroup tba, Bereich_Objekt_Teilbereich_AttributeGroup tbb) {
        boolean _lessEqualsThan_1;
        boolean _lessThan;
        TOP_Kante _iDTOPKante_1;
        boolean _tripleNotEquals;
        TOP_Kante _iDTOPKante = tba.getIDTOPKante();
        boolean bl = _tripleNotEquals = _iDTOPKante != (_iDTOPKante_1 = tbb.getIDTOPKante());
        if (_tripleNotEquals) {
            return BigDecimal.ZERO;
        }
        Begrenzung_A_TypeClass _begrenzungA = tba.getBegrenzungA();
        BigDecimal _wert = null;
        if (_begrenzungA != null) {
            _wert = _begrenzungA.getWert();
        }
        BigDecimal taA = _wert;
        Begrenzung_B_TypeClass _begrenzungB = tba.getBegrenzungB();
        BigDecimal _wert_1 = null;
        if (_begrenzungB != null) {
            _wert_1 = _begrenzungB.getWert();
        }
        BigDecimal taB = _wert_1;
        Begrenzung_A_TypeClass _begrenzungA_1 = tbb.getBegrenzungA();
        BigDecimal _wert_2 = null;
        if (_begrenzungA_1 != null) {
            _wert_2 = _begrenzungA_1.getWert();
        }
        BigDecimal tbA = _wert_2;
        Begrenzung_B_TypeClass _begrenzungB_1 = tbb.getBegrenzungB();
        BigDecimal _wert_3 = null;
        if (_begrenzungB_1 != null) {
            _wert_3 = _begrenzungB_1.getWert();
        }
        BigDecimal tbB = _wert_3;
        BigDecimal minA = taA.min(taB);
        BigDecimal maxA = taA.max(taB);
        BigDecimal minB = tbA.min(tbB);
        BigDecimal maxB = tbA.max(tbB);
        boolean bl2 = _lessThan = minA.compareTo(minB) < 0;
        if (_lessThan) {
            boolean _lessEqualsThan;
            boolean bl3 = _lessEqualsThan = maxA.compareTo(minB) <= 0;
            if (_lessEqualsThan) {
                return BigDecimal.ZERO;
            }
            BigDecimal _min = maxA.min(maxB);
            return _min.subtract(minB);
        }
        boolean bl4 = _lessEqualsThan_1 = maxB.compareTo(minA) <= 0;
        if (_lessEqualsThan_1) {
            return BigDecimal.ZERO;
        }
        BigDecimal _min_1 = maxB.min(maxA);
        return _min_1.subtract(minA);
    }

    public static BigDecimal getOverlappingLength(Bereich_Objekt bo, final Bereich_Objekt_Teilbereich_AttributeGroup tbb) {
        Functions.Function1<Bereich_Objekt_Teilbereich_AttributeGroup, BigDecimal> _function = new Functions.Function1<Bereich_Objekt_Teilbereich_AttributeGroup, BigDecimal>(){

            public BigDecimal apply(Bereich_Objekt_Teilbereich_AttributeGroup it) {
                return BereichObjektExtensions.getOverlappingLength(it, tbb);
            }
        };
        Functions.Function2<BigDecimal, BigDecimal, BigDecimal> _function_1 = new Functions.Function2<BigDecimal, BigDecimal, BigDecimal>(){

            public BigDecimal apply(BigDecimal a, BigDecimal b) {
                return a.add(b);
            }
        };
        return (BigDecimal)IterableExtensions.reduce((Iterable)ListExtensions.map((List)bo.getBereichObjektTeilbereich(), (Functions.Function1)_function), (Functions.Function2)_function_1);
    }

    public static BigDecimal getOverlappingLength(Bereich_Objekt bo, final Bereich_Objekt bo2) {
        Functions.Function1<Bereich_Objekt_Teilbereich_AttributeGroup, BigDecimal> _function = new Functions.Function1<Bereich_Objekt_Teilbereich_AttributeGroup, BigDecimal>(){

            public BigDecimal apply(Bereich_Objekt_Teilbereich_AttributeGroup it) {
                return BereichObjektExtensions.getOverlappingLength(bo2, it);
            }
        };
        Functions.Function2<BigDecimal, BigDecimal, BigDecimal> _function_1 = new Functions.Function2<BigDecimal, BigDecimal, BigDecimal>(){

            public BigDecimal apply(BigDecimal a, BigDecimal b) {
                return a.add(b);
            }
        };
        return (BigDecimal)IterableExtensions.reduce((Iterable)ListExtensions.map((List)bo.getBereichObjektTeilbereich(), (Functions.Function1)_function), (Functions.Function2)_function_1);
    }
}

