/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.graph.DirectedEdgePath;
import org.eclipse.set.basis.graph.DirectedEdgePoint;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.BasisObjektExtensions;
import org.eclipse.set.ppmodel.extensions.BueAnlageExtensions;
import org.eclipse.set.ppmodel.extensions.BueEinschaltungZuordnungExtension;
import org.eclipse.set.ppmodel.extensions.BueGleisbezogenerGefahrraumExtensions;
import org.eclipse.set.ppmodel.extensions.ENUMWirkrichtungExtensions;
import org.eclipse.set.ppmodel.extensions.FahrwegExtensions;
import org.eclipse.set.ppmodel.extensions.FstrSignalisierungExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektTopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.SignalExtensions;
import org.eclipse.set.ppmodel.extensions.SignalRahmenExtensions;
import org.eclipse.set.ppmodel.extensions.SignalbegriffExtensions;
import org.eclipse.set.ppmodel.extensions.WKrGspKomponenteExtensions;
import org.eclipse.set.ppmodel.extensions.utils.CrossingRoute;
import org.eclipse.set.ppmodel.extensions.utils.GestellteWeiche;
import org.eclipse.set.ppmodel.extensions.utils.IterableExtensions;
import org.eclipse.set.ppmodel.extensions.utils.WeichenSchenkel;
import org.eclipse.set.toolboxmodel.Bahnuebergang.BUE_Anlage;
import org.eclipse.set.toolboxmodel.Bahnuebergang.BUE_Einschaltung;
import org.eclipse.set.toolboxmodel.Bahnuebergang.BUE_Einschaltung_Zuordnung;
import org.eclipse.set.toolboxmodel.Bahnuebergang.BUE_Gleisbezogener_Gefahrraum;
import org.eclipse.set.toolboxmodel.BasisTypen.Bezeichnung_Element_AttributeGroup;
import org.eclipse.set.toolboxmodel.BasisTypen.Bezeichnung_Tabelle_TypeClass;
import org.eclipse.set.toolboxmodel.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.toolboxmodel.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.toolboxmodel.Basisobjekte.Wirkrichtung_TypeClass;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Bezeichnung_Fstr_DWeg_TypeClass;
import org.eclipse.set.toolboxmodel.Fahrstrasse.ENUMFstrRangierArt;
import org.eclipse.set.toolboxmodel.Fahrstrasse.ENUMFstrZugArt;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_DWeg;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_DWeg_Bezeichnung_AttributeGroup;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_DWeg_Spezifisch_AttributeGroup;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Fahrweg;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Nichthaltfall;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Rangier_Art_TypeClass;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Rangier_AttributeGroup;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Rangier_Fla_Zuordnung;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Reihenfolge_TypeClass;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Signalisierung;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Zug_Art_TypeClass;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Zug_AttributeGroup;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Zug_DWeg_AttributeGroup;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Zug_Rangier;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Zug_Rangier_Allg_AttributeGroup;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Knoten;
import org.eclipse.set.toolboxmodel.Gleis.ENUMGleisart;
import org.eclipse.set.toolboxmodel.Gleis.Geschwindigkeit_TypeClass;
import org.eclipse.set.toolboxmodel.Gleis.Gleis_Abschnitt;
import org.eclipse.set.toolboxmodel.Ortung.FMA_Anlage;
import org.eclipse.set.toolboxmodel.Signalbegriffe_Ril_301.Kl;
import org.eclipse.set.toolboxmodel.Signale.ENUMSignalArt;
import org.eclipse.set.toolboxmodel.Signale.Signal;
import org.eclipse.set.toolboxmodel.Signale.Signal_Art_TypeClass;
import org.eclipse.set.toolboxmodel.Signale.Signal_Real_Aktiv_Schirm_AttributeGroup;
import org.eclipse.set.toolboxmodel.Signale.Signal_Real_AttributeGroup;
import org.eclipse.set.toolboxmodel.Signale.Signal_Signalbegriff;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Geschwindigkeit_L_TypeClass;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Geschwindigkeit_R_TypeClass;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Kreuzung_AttributeGroup;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Gsp_Komponente;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Zungenpaar_AttributeGroup;
import org.eclipse.set.utils.math.BigIntegerExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class FstrZugRangierExtensions
extends BasisObjektExtensions {
    public static List<Fstr_Signalisierung> fstrSignalisierung(Fstr_Zug_Rangier fstr) {
        LinkedList<Fstr_Signalisierung> result = new LinkedList<Fstr_Signalisierung>();
        Iterable signalisierungen = BasisAttributExtensions.getContainer((EObject)fstr).getFstrSignalisierung();
        for (Fstr_Signalisierung signalisierung : signalisierungen) {
            String _wert_1;
            boolean _equals;
            Identitaet_TypeClass _identitaet = signalisierung.getIDFstrZugRangier().getIdentitaet();
            String _wert = null;
            if (_identitaet != null) {
                _wert = _identitaet.getWert();
            }
            if (!(_equals = Objects.equal((Object)_wert, (Object)(_wert_1 = fstr.getIdentitaet().getWert())))) continue;
            result.add(signalisierung);
        }
        return result;
    }

    public static Fstr_DWeg getFstrDWeg(Fstr_Zug_Rangier zugRangier) {
        Fstr_Zug_AttributeGroup _fstrZug = null;
        if (zugRangier != null) {
            _fstrZug = zugRangier.getFstrZug();
        }
        Fstr_Zug_DWeg_AttributeGroup _fstrZugDWeg = null;
        if (_fstrZug != null) {
            _fstrZugDWeg = _fstrZug.getFstrZugDWeg();
        }
        Fstr_DWeg _iDFstrDWeg = null;
        if (_fstrZugDWeg != null) {
            _iDFstrDWeg = _fstrZugDWeg.getIDFstrDWeg();
        }
        return _iDFstrDWeg;
    }

    public static Fstr_Fahrweg getFstrFahrweg(Fstr_Zug_Rangier zugRangier) {
        return zugRangier.getIDFstrFahrweg();
    }

    public static Iterable<Fstr_Rangier_Fla_Zuordnung> getFstrRangierFlaZuordnung(final Fstr_Zug_Rangier fstrZugRangier) {
        Functions.Function1<Fstr_Rangier_Fla_Zuordnung, Boolean> _function = new Functions.Function1<Fstr_Rangier_Fla_Zuordnung, Boolean>(){

            public Boolean apply(Fstr_Rangier_Fla_Zuordnung it) {
                Fstr_Zug_Rangier _iDFstrRangier = it.getIDFstrRangier();
                return _iDFstrRangier == fstrZugRangier;
            }
        };
        return org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)fstrZugRangier).getFstrRangierFlaZuordnung(), (Functions.Function1)_function);
    }

    public static List<Fstr_Nichthaltfall> getFstrNichthaltfall(final Fstr_Zug_Rangier fstrZugRangier) {
        Functions.Function1<Fstr_Nichthaltfall, Boolean> _function = new Functions.Function1<Fstr_Nichthaltfall, Boolean>(){

            public Boolean apply(Fstr_Nichthaltfall it) {
                Identitaet_TypeClass _identitaet = it.getIDFstrFahrweg().getIdentitaet();
                String _wert = null;
                if (_identitaet != null) {
                    _wert = _identitaet.getWert();
                }
                Identitaet_TypeClass _identitaet_1 = fstrZugRangier.getIDFstrFahrweg().getIdentitaet();
                String _wert_1 = null;
                if (_identitaet_1 != null) {
                    _wert_1 = _identitaet_1.getWert();
                }
                return Objects.equal((Object)_wert, (Object)_wert_1);
            }
        };
        return org.eclipse.xtext.xbase.lib.IterableExtensions.toList((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)fstrZugRangier).getFstrNichthaltfall(), (Functions.Function1)_function));
    }

    public static List<GestellteWeiche> getEntscheidungsweichen(Fstr_Zug_Rangier fstrZugRangier, final List<ENUMGleisart> notUsable) {
        final Fstr_Fahrweg fstrFahrweg = FstrZugRangierExtensions.getFstrFahrweg(fstrZugRangier);
        DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> path = FahrwegExtensions.getPath(fstrFahrweg);
        List fwSinglePoints = IteratorExtensions.toList((Iterator)path.getPointIterator());
        Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Punkt_Objekt> _function = new Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Punkt_Objekt>(){

            public Punkt_Objekt apply(Punkt_Objekt_TOP_Kante_AttributeGroup it) {
                return PunktObjektTopKanteExtensions.getPunktObjekt(it);
            }
        };
        Functions.Function1<W_Kr_Gsp_Komponente, Boolean> _function_1 = new Functions.Function1<W_Kr_Gsp_Komponente, Boolean>(){

            public Boolean apply(W_Kr_Gsp_Komponente it) {
                return WKrGspKomponenteExtensions.hasZungenpaar(it);
            }
        };
        List wKomponenten = IterableExtensions.toUniqueList(org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)Iterables.filter((Iterable)ListExtensions.map((List)fwSinglePoints, (Functions.Function1)_function), W_Kr_Gsp_Komponente.class), (Functions.Function1)_function_1));
        Functions.Function1<W_Kr_Gsp_Komponente, GestellteWeiche> _function_2 = new Functions.Function1<W_Kr_Gsp_Komponente, GestellteWeiche>(){

            public GestellteWeiche apply(W_Kr_Gsp_Komponente it) {
                return FahrwegExtensions.getEntscheidungsweiche(fstrFahrweg, it, notUsable);
            }
        };
        List<GestellteWeiche> weichen = IterableExtensions.toUniqueList(org.eclipse.xtext.xbase.lib.IterableExtensions.filterNull((Iterable)ListExtensions.map(wKomponenten, (Functions.Function1)_function_2)));
        return weichen;
    }

    public static int geschwindigkeit(Fstr_Zug_Rangier fstrZugRangier) {
        boolean _not;
        int vmin = -1;
        final Fstr_Fahrweg fw = FstrZugRangierExtensions.getFstrFahrweg(fstrZugRangier);
        Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Punkt_Objekt> _function = new Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Punkt_Objekt>(){

            public Punkt_Objekt apply(Punkt_Objekt_TOP_Kante_AttributeGroup it) {
                return PunktObjektTopKanteExtensions.getPunktObjekt(it);
            }
        };
        Functions.Function1<Punkt_Objekt, Integer> _function_1 = new Functions.Function1<Punkt_Objekt, Integer>(){

            public Integer apply(Punkt_Objekt it) {
                return FstrZugRangierExtensions.getVmax(it, fw);
            }
        };
        Functions.Function1<Integer, Boolean> _function_2 = new Functions.Function1<Integer, Boolean>(){

            public Boolean apply(Integer it) {
                return it >= 0;
            }
        };
        List vmax = IteratorExtensions.toList((Iterator)IteratorExtensions.filter((Iterator)IteratorExtensions.map((Iterator)IteratorExtensions.map((Iterator)FahrwegExtensions.getPath(fw).getPointIterator(), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
        Functions.Function1<Gleis_Abschnitt, Integer> _function_3 = new Functions.Function1<Gleis_Abschnitt, Integer>(){

            public Integer apply(Gleis_Abschnitt it) {
                return FstrZugRangierExtensions.getVmax(it, fw);
            }
        };
        Functions.Function1<Integer, Boolean> _function_4 = new Functions.Function1<Integer, Boolean>(){

            public Boolean apply(Integer it) {
                return it >= 0;
            }
        };
        Iterables.addAll((Collection)vmax, (Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.map(FahrwegExtensions.getGleisabschnitte(fw), (Functions.Function1)_function_3), (Functions.Function1)_function_4));
        boolean _isEmpty = vmax.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            vmin = (Integer)org.eclipse.xtext.xbase.lib.IterableExtensions.min((Iterable)vmax);
        }
        if (vmin < 0) {
            return Integer.MAX_VALUE;
        }
        return vmin;
    }

    public static boolean isImFahrweg(Fstr_Zug_Rangier fstrZugRangier, Signal_Signalbegriff signalbegriff) {
        return FahrwegExtensions.getSignalbegriffeImFahrweg(FstrZugRangierExtensions.getFstrFahrweg(fstrZugRangier)).contains(signalbegriff);
    }

    public static Set<BUE_Anlage> getBUesImGefahrraum(final Fstr_Zug_Rangier fstrZugRangier) {
        Functions.Function1<BUE_Anlage, Boolean> _function = new Functions.Function1<BUE_Anlage, Boolean>(){

            public Boolean apply(BUE_Anlage it) {
                Functions.Function1<BUE_Gleisbezogener_Gefahrraum, List<BUE_Einschaltung_Zuordnung>> _function = new Functions.Function1<BUE_Gleisbezogener_Gefahrraum, List<BUE_Einschaltung_Zuordnung>>(){

                    public List<BUE_Einschaltung_Zuordnung> apply(BUE_Gleisbezogener_Gefahrraum it_1) {
                        return BueGleisbezogenerGefahrraumExtensions.getEinschaltungZuordnungen(it_1);
                    }
                };
                Functions.Function1<BUE_Einschaltung_Zuordnung, BUE_Einschaltung> _function_1 = new Functions.Function1<BUE_Einschaltung_Zuordnung, BUE_Einschaltung>(){

                    public BUE_Einschaltung apply(BUE_Einschaltung_Zuordnung it_1) {
                        return BueEinschaltungZuordnungExtension.getEinschaltung(it_1);
                    }
                };
                Functions.Function1<BUE_Einschaltung, Boolean> _function_2 = new Functions.Function1<BUE_Einschaltung, Boolean>(){

                    public Boolean apply(BUE_Einschaltung it_1) {
                        Functions.Function1<BUE_Einschaltung, String> _function = new Functions.Function1<BUE_Einschaltung, String>(){

                            public String apply(BUE_Einschaltung it_2) {
                                return it_2.getIdentitaet().getWert();
                            }
                        };
                        return ListExtensions.map((List)fstrZugRangier.getFstrZug().getIDBUEEinschaltung(), (Functions.Function1)_function).contains(it_1.getIdentitaet().getWert());
                    }
                };
                return org.eclipse.xtext.xbase.lib.IterableExtensions.exists((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)ListExtensions.map(BueAnlageExtensions.getGleisbezogeneGefahrraeume(it), (Functions.Function1)_function))), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
            }
        };
        return org.eclipse.xtext.xbase.lib.IterableExtensions.toSet((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)fstrZugRangier).getBUEAnlage(), (Functions.Function1)_function));
    }

    public static List<Signal> getVorsignalisierung(final Fstr_Zug_Rangier fstrZugRangier) {
        Functions.Function1<DirectedEdgePoint<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Boolean> _function = new Functions.Function1<DirectedEdgePoint<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Boolean>(){

            public Boolean apply(DirectedEdgePoint<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> it) {
                return FstrZugRangierExtensions.isVorsignalisierung(fstrZugRangier, it);
            }
        };
        Functions.Function1<DirectedEdgePoint<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Punkt_Objekt_TOP_Kante_AttributeGroup> _function_1 = new Functions.Function1<DirectedEdgePoint<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Punkt_Objekt_TOP_Kante_AttributeGroup>(){

            public Punkt_Objekt_TOP_Kante_AttributeGroup apply(DirectedEdgePoint<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> it) {
                return (Punkt_Objekt_TOP_Kante_AttributeGroup)it.getPoint();
            }
        };
        Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Punkt_Objekt> _function_2 = new Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Punkt_Objekt>(){

            public Punkt_Objekt apply(Punkt_Objekt_TOP_Kante_AttributeGroup it) {
                return PunktObjektTopKanteExtensions.getPunktObjekt(it);
            }
        };
        return IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)IteratorExtensions.map((Iterator)IteratorExtensions.map((Iterator)IteratorExtensions.filter((Iterator)FahrwegExtensions.getPath(FstrZugRangierExtensions.getFstrFahrweg(fstrZugRangier)).getEdgePointIterator(), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2), Signal.class));
    }

    public static boolean isKennlichtSignalisierung(Fstr_Zug_Rangier fstrZugRangier, final Signal signal) {
        Functions.Function1<Fstr_Signalisierung, Boolean> _function = new Functions.Function1<Fstr_Signalisierung, Boolean>(){

            public Boolean apply(Fstr_Signalisierung it) {
                return SignalbegriffExtensions.hasSignalbegriffID(FstrSignalisierungExtensions.getSignalSignalbegriff(it), Kl.class);
            }
        };
        Functions.Function1<Fstr_Signalisierung, Boolean> _function_1 = new Functions.Function1<Fstr_Signalisierung, Boolean>(){

            public Boolean apply(Fstr_Signalisierung it) {
                String _wert = SignalRahmenExtensions.getSignal(SignalbegriffExtensions.signalRahmen(FstrSignalisierungExtensions.getSignalSignalbegriff(it))).getIdentitaet().getWert();
                String _wert_1 = signal.getIdentitaet().getWert();
                return Objects.equal((Object)_wert, (Object)_wert_1);
            }
        };
        return org.eclipse.xtext.xbase.lib.IterableExtensions.exists((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter(FstrZugRangierExtensions.fstrSignalisierung(fstrZugRangier), (Functions.Function1)_function), (Functions.Function1)_function_1);
    }

    public static Set<FMA_Anlage> getFmaAnlageRangierFrei(Fstr_Zug_Rangier fstrZugRangier) {
        Fstr_Rangier_AttributeGroup _fstrRangier = null;
        if (fstrZugRangier != null) {
            _fstrRangier = fstrZugRangier.getFstrRangier();
        }
        EList _iDFMAAnlageRangierFrei = null;
        if (_fstrRangier != null) {
            _iDFMAAnlageRangierFrei = _fstrRangier.getIDFMAAnlageRangierFrei();
        }
        Set _set = null;
        if (_iDFMAAnlageRangierFrei != null) {
            _set = org.eclipse.xtext.xbase.lib.IterableExtensions.toSet((Iterable)_iDFMAAnlageRangierFrei);
        }
        return _set;
    }

    public static <T> String getFstrZugRangierBezeichnung(Fstr_Zug_Rangier fstrZugRangier) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        Fstr_Zug_AttributeGroup _fstrZug = null;
        if (fstrZugRangier != null) {
            _fstrZug = fstrZugRangier.getFstrZug();
        }
        boolean bl = _tripleNotEquals = _fstrZug != null;
        if (_tripleNotEquals) {
            Functions.Function1<Fstr_Zug_Art_TypeClass, Boolean> _function = new Functions.Function1<Fstr_Zug_Art_TypeClass, Boolean>(){

                public Boolean apply(Fstr_Zug_Art_TypeClass it) {
                    return FstrZugRangierExtensions.isZ(it);
                }
            };
            return FstrZugRangierExtensions.getZugFstrBezeichnung(fstrZugRangier, (Functions.Function1<? super Fstr_Zug_Art_TypeClass, ? extends Boolean>)_function);
        }
        Fstr_Rangier_AttributeGroup _fstrRangier = null;
        if (fstrZugRangier != null) {
            _fstrRangier = fstrZugRangier.getFstrRangier();
        }
        boolean bl2 = _tripleNotEquals_1 = _fstrRangier != null;
        if (_tripleNotEquals_1) {
            Functions.Function1<Fstr_Zug_Rangier, Boolean> _function_1 = new Functions.Function1<Fstr_Zug_Rangier, Boolean>(){

                public Boolean apply(Fstr_Zug_Rangier it) {
                    return FstrZugRangierExtensions.isR(it);
                }
            };
            return FstrZugRangierExtensions.getRangierFstrBezeichnung(fstrZugRangier, (Functions.Function1<? super Fstr_Zug_Rangier, ? extends Boolean>)_function_1);
        }
        return null;
    }

    public static String getRangierFstrBezeichnung(Fstr_Zug_Rangier fstrZugRangier, Functions.Function1<? super Fstr_Zug_Rangier, ? extends Boolean> condition) {
        int fstrReihenfolge;
        boolean _not;
        Boolean _apply = (Boolean)condition.apply((Object)fstrZugRangier);
        boolean bl = _not = _apply == false;
        if (_not) {
            return null;
        }
        String _elvis = null;
        Fstr_Fahrweg _fstrFahrweg = FstrZugRangierExtensions.getFstrFahrweg(fstrZugRangier);
        Signal _start = null;
        if (_fstrFahrweg != null) {
            _start = FahrwegExtensions.getStart(_fstrFahrweg);
        }
        Bezeichnung_Element_AttributeGroup _bezeichnung = null;
        if (_start != null) {
            _bezeichnung = _start.getBezeichnung();
        }
        Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
        if (_bezeichnung != null) {
            _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
        }
        String _wert = null;
        if (_bezeichnungTabelle != null) {
            _wert = _bezeichnungTabelle.getWert();
        }
        _elvis = _wert != null ? _wert : "";
        String fstrFahrwegStartSignalBezeichnung = _elvis;
        String _elvis_1 = null;
        Fstr_Fahrweg _fstrFahrweg_1 = FstrZugRangierExtensions.getFstrFahrweg(fstrZugRangier);
        Signal _zielSignal = null;
        if (_fstrFahrweg_1 != null) {
            _zielSignal = FahrwegExtensions.getZielSignal(_fstrFahrweg_1);
        }
        Bezeichnung_Element_AttributeGroup _bezeichnung_1 = null;
        if (_zielSignal != null) {
            _bezeichnung_1 = _zielSignal.getBezeichnung();
        }
        Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle_1 = null;
        if (_bezeichnung_1 != null) {
            _bezeichnungTabelle_1 = _bezeichnung_1.getBezeichnungTabelle();
        }
        String _wert_1 = null;
        if (_bezeichnungTabelle_1 != null) {
            _wert_1 = _bezeichnungTabelle_1.getWert();
        }
        _elvis_1 = _wert_1 != null ? _wert_1 : "";
        String fstrFahrwegZielSignalBezeichnung = _elvis_1;
        Fstr_Zug_Rangier_Allg_AttributeGroup _fstrZugRangierAllg = null;
        if (fstrZugRangier != null) {
            _fstrZugRangierAllg = fstrZugRangier.getFstrZugRangierAllg();
        }
        Fstr_Reihenfolge_TypeClass _fstrReihenfolge = null;
        if (_fstrZugRangierAllg != null) {
            _fstrReihenfolge = _fstrZugRangierAllg.getFstrReihenfolge();
        }
        BigInteger _wert_2 = null;
        if (_fstrReihenfolge != null) {
            _wert_2 = _fstrReihenfolge.getWert();
        }
        if ((fstrReihenfolge = _wert_2.compareTo(BigInteger.ZERO)) == 0) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(fstrFahrwegStartSignalBezeichnung);
            _builder.append("/");
            _builder.append(fstrFahrwegZielSignalBezeichnung);
            return _builder.toString();
        }
        if (fstrReihenfolge > 0) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(fstrFahrwegStartSignalBezeichnung);
            _builder_1.append("/");
            _builder_1.append(fstrFahrwegZielSignalBezeichnung);
            _builder_1.append(" [U");
            String _string = fstrZugRangier.getFstrZugRangierAllg().getFstrReihenfolge().getWert().toString();
            _builder_1.append(_string);
            _builder_1.append("]");
            return _builder_1.toString();
        }
        return null;
    }

    public static String getZugFstrBezeichnung(Fstr_Zug_Rangier fstrZugRangier, Functions.Function1<? super Fstr_Zug_Art_TypeClass, ? extends Boolean> condition) {
        boolean _tripleNotEquals;
        boolean _tripleEquals;
        Boolean _apply;
        boolean _not;
        Fstr_Zug_AttributeGroup _fstrZug = null;
        if (fstrZugRangier != null) {
            _fstrZug = fstrZugRangier.getFstrZug();
        }
        Fstr_Zug_Art_TypeClass _fstrZugArt = null;
        if (_fstrZug != null) {
            _fstrZugArt = _fstrZug.getFstrZugArt();
        }
        boolean bl = _not = (_apply = (Boolean)condition.apply((Object)_fstrZugArt)) == false;
        if (_not) {
            return null;
        }
        boolean _or = false;
        Fstr_Zug_AttributeGroup _fstrZug_1 = null;
        if (fstrZugRangier != null) {
            _fstrZug_1 = fstrZugRangier.getFstrZug();
        }
        Fstr_Zug_DWeg_AttributeGroup _fstrZugDWeg = null;
        if (_fstrZug_1 != null) {
            _fstrZugDWeg = _fstrZug_1.getFstrZugDWeg();
        }
        boolean bl2 = _tripleEquals = _fstrZugDWeg == null;
        if (_tripleEquals) {
            _or = true;
        } else {
            boolean _tripleEquals_1;
            Fstr_DWeg _fstrDWeg = null;
            if (fstrZugRangier != null) {
                _fstrDWeg = FstrZugRangierExtensions.getFstrDWeg(fstrZugRangier);
            }
            Fstr_DWeg_Spezifisch_AttributeGroup _fstrDWegSpezifisch = null;
            if (_fstrDWeg != null) {
                _fstrDWegSpezifisch = _fstrDWeg.getFstrDWegSpezifisch();
            }
            _or = _tripleEquals_1 = _fstrDWegSpezifisch == null;
        }
        if (_or) {
            boolean _isNotNullAndGreater;
            boolean _equals;
            Fstr_Zug_Rangier_Allg_AttributeGroup _fstrZugRangierAllg = null;
            if (fstrZugRangier != null) {
                _fstrZugRangierAllg = fstrZugRangier.getFstrZugRangierAllg();
            }
            Fstr_Reihenfolge_TypeClass _fstrReihenfolge = null;
            if (_fstrZugRangierAllg != null) {
                _fstrReihenfolge = _fstrZugRangierAllg.getFstrReihenfolge();
            }
            BigInteger _wert = null;
            if (_fstrReihenfolge != null) {
                _wert = _fstrReihenfolge.getWert();
            }
            if (_equals = Objects.equal((Object)_wert, (Object)BigInteger.ZERO)) {
                Fstr_Fahrweg _fstrFahrweg = null;
                if (fstrZugRangier != null) {
                    _fstrFahrweg = FstrZugRangierExtensions.getFstrFahrweg(fstrZugRangier);
                }
                String _transformFahrwegStartZiel = null;
                if (_fstrFahrweg != null) {
                    _transformFahrwegStartZiel = FstrZugRangierExtensions.transformFahrwegStartZiel(_fstrFahrweg);
                }
                return _transformFahrwegStartZiel;
            }
            Fstr_Zug_Rangier_Allg_AttributeGroup _fstrZugRangierAllg_1 = null;
            if (fstrZugRangier != null) {
                _fstrZugRangierAllg_1 = fstrZugRangier.getFstrZugRangierAllg();
            }
            Fstr_Reihenfolge_TypeClass _fstrReihenfolge_1 = null;
            if (_fstrZugRangierAllg_1 != null) {
                _fstrReihenfolge_1 = _fstrZugRangierAllg_1.getFstrReihenfolge();
            }
            BigInteger _wert_1 = null;
            if (_fstrReihenfolge_1 != null) {
                _wert_1 = _fstrReihenfolge_1.getWert();
            }
            if (_isNotNullAndGreater = BigIntegerExtensions.isNotNullAndGreater((BigInteger)_wert_1, (BigInteger)BigInteger.ZERO)) {
                StringConcatenation _builder = new StringConcatenation();
                Fstr_Fahrweg _fstrFahrweg_1 = null;
                if (fstrZugRangier != null) {
                    _fstrFahrweg_1 = FstrZugRangierExtensions.getFstrFahrweg(fstrZugRangier);
                }
                String _transformFahrwegStartZiel_1 = null;
                if (_fstrFahrweg_1 != null) {
                    _transformFahrwegStartZiel_1 = FstrZugRangierExtensions.transformFahrwegStartZiel(_fstrFahrweg_1);
                }
                _builder.append(_transformFahrwegStartZiel_1);
                _builder.append(" [U");
                Fstr_Zug_Rangier_Allg_AttributeGroup _fstrZugRangierAllg_2 = null;
                if (fstrZugRangier != null) {
                    _fstrZugRangierAllg_2 = fstrZugRangier.getFstrZugRangierAllg();
                }
                Fstr_Reihenfolge_TypeClass _fstrReihenfolge_2 = null;
                if (_fstrZugRangierAllg_2 != null) {
                    _fstrReihenfolge_2 = _fstrZugRangierAllg_2.getFstrReihenfolge();
                }
                BigInteger _wert_2 = null;
                if (_fstrReihenfolge_2 != null) {
                    _wert_2 = _fstrReihenfolge_2.getWert();
                }
                _builder.append((Object)_wert_2);
                _builder.append("]");
                return _builder.toString();
            }
        }
        Fstr_Zug_AttributeGroup _fstrZug_2 = null;
        if (fstrZugRangier != null) {
            _fstrZug_2 = fstrZugRangier.getFstrZug();
        }
        Fstr_Zug_DWeg_AttributeGroup _fstrZugDWeg_1 = null;
        if (_fstrZug_2 != null) {
            _fstrZugDWeg_1 = _fstrZug_2.getFstrZugDWeg();
        }
        boolean bl3 = _tripleNotEquals = _fstrZugDWeg_1 != null;
        if (_tripleNotEquals) {
            boolean _isNotNullAndGreater_1;
            boolean _equals_1;
            Fstr_Zug_Rangier_Allg_AttributeGroup _fstrZugRangierAllg_3 = null;
            if (fstrZugRangier != null) {
                _fstrZugRangierAllg_3 = fstrZugRangier.getFstrZugRangierAllg();
            }
            Fstr_Reihenfolge_TypeClass _fstrReihenfolge_3 = null;
            if (_fstrZugRangierAllg_3 != null) {
                _fstrReihenfolge_3 = _fstrZugRangierAllg_3.getFstrReihenfolge();
            }
            BigInteger _wert_3 = null;
            if (_fstrReihenfolge_3 != null) {
                _wert_3 = _fstrReihenfolge_3.getWert();
            }
            if (_equals_1 = Objects.equal((Object)_wert_3, (Object)BigInteger.ZERO)) {
                StringConcatenation _builder_1 = new StringConcatenation();
                Fstr_Fahrweg _fstrFahrweg_2 = null;
                if (fstrZugRangier != null) {
                    _fstrFahrweg_2 = FstrZugRangierExtensions.getFstrFahrweg(fstrZugRangier);
                }
                String _transformFahrwegStartZiel_2 = null;
                if (_fstrFahrweg_2 != null) {
                    _transformFahrwegStartZiel_2 = FstrZugRangierExtensions.transformFahrwegStartZiel(_fstrFahrweg_2);
                }
                _builder_1.append(_transformFahrwegStartZiel_2);
                _builder_1.append(" (");
                Fstr_DWeg _fstrDWeg_1 = null;
                if (fstrZugRangier != null) {
                    _fstrDWeg_1 = FstrZugRangierExtensions.getFstrDWeg(fstrZugRangier);
                }
                Fstr_DWeg_Bezeichnung_AttributeGroup _bezeichnung = null;
                if (_fstrDWeg_1 != null) {
                    _bezeichnung = _fstrDWeg_1.getBezeichnung();
                }
                Bezeichnung_Fstr_DWeg_TypeClass _bezeichnungFstrDWeg = null;
                if (_bezeichnung != null) {
                    _bezeichnungFstrDWeg = _bezeichnung.getBezeichnungFstrDWeg();
                }
                String _wert_4 = null;
                if (_bezeichnungFstrDWeg != null) {
                    _wert_4 = _bezeichnungFstrDWeg.getWert();
                }
                _builder_1.append(_wert_4);
                _builder_1.append(")");
                return _builder_1.toString();
            }
            Fstr_Zug_Rangier_Allg_AttributeGroup _fstrZugRangierAllg_4 = null;
            if (fstrZugRangier != null) {
                _fstrZugRangierAllg_4 = fstrZugRangier.getFstrZugRangierAllg();
            }
            Fstr_Reihenfolge_TypeClass _fstrReihenfolge_4 = null;
            if (_fstrZugRangierAllg_4 != null) {
                _fstrReihenfolge_4 = _fstrZugRangierAllg_4.getFstrReihenfolge();
            }
            BigInteger _wert_5 = null;
            if (_fstrReihenfolge_4 != null) {
                _wert_5 = _fstrReihenfolge_4.getWert();
            }
            if (_isNotNullAndGreater_1 = BigIntegerExtensions.isNotNullAndGreater((BigInteger)_wert_5, (BigInteger)BigInteger.ZERO)) {
                StringConcatenation _builder_2 = new StringConcatenation();
                Fstr_Fahrweg _fstrFahrweg_3 = null;
                if (fstrZugRangier != null) {
                    _fstrFahrweg_3 = FstrZugRangierExtensions.getFstrFahrweg(fstrZugRangier);
                }
                String _transformFahrwegStartZiel_3 = null;
                if (_fstrFahrweg_3 != null) {
                    _transformFahrwegStartZiel_3 = FstrZugRangierExtensions.transformFahrwegStartZiel(_fstrFahrweg_3);
                }
                _builder_2.append(_transformFahrwegStartZiel_3);
                _builder_2.append(" [U");
                Fstr_Zug_Rangier_Allg_AttributeGroup _fstrZugRangierAllg_5 = null;
                if (fstrZugRangier != null) {
                    _fstrZugRangierAllg_5 = fstrZugRangier.getFstrZugRangierAllg();
                }
                Fstr_Reihenfolge_TypeClass _fstrReihenfolge_5 = null;
                if (_fstrZugRangierAllg_5 != null) {
                    _fstrReihenfolge_5 = _fstrZugRangierAllg_5.getFstrReihenfolge();
                }
                BigInteger _wert_6 = null;
                if (_fstrReihenfolge_5 != null) {
                    _wert_6 = _fstrReihenfolge_5.getWert();
                }
                _builder_2.append((Object)_wert_6);
                _builder_2.append("] (");
                Fstr_DWeg _fstrDWeg_2 = null;
                if (fstrZugRangier != null) {
                    _fstrDWeg_2 = FstrZugRangierExtensions.getFstrDWeg(fstrZugRangier);
                }
                Fstr_DWeg_Bezeichnung_AttributeGroup _bezeichnung_1 = null;
                if (_fstrDWeg_2 != null) {
                    _bezeichnung_1 = _fstrDWeg_2.getBezeichnung();
                }
                Bezeichnung_Fstr_DWeg_TypeClass _bezeichnungFstrDWeg_1 = null;
                if (_bezeichnung_1 != null) {
                    _bezeichnungFstrDWeg_1 = _bezeichnung_1.getBezeichnungFstrDWeg();
                }
                String _wert_7 = null;
                if (_bezeichnungFstrDWeg_1 != null) {
                    _wert_7 = _bezeichnungFstrDWeg_1.getWert();
                }
                _builder_2.append(_wert_7);
                _builder_2.append(")");
                return _builder_2.toString();
            }
        }
        return null;
    }

    private static boolean isVorsignalisierung(Fstr_Zug_Rangier fstrZugRangier, DirectedEdgePoint<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> edgePoint) {
        ENUMSignalArt signalArt;
        boolean _isInWirkrichtung;
        boolean _not_1;
        boolean _not;
        boolean _contains = edgePoint.getEdge().contains((Object)((Punkt_Objekt_TOP_Kante_AttributeGroup)edgePoint.getPoint()));
        boolean bl = _not = !_contains;
        if (_not) {
            return false;
        }
        Punkt_Objekt_TOP_Kante_AttributeGroup _point = (Punkt_Objekt_TOP_Kante_AttributeGroup)edgePoint.getPoint();
        Wirkrichtung_TypeClass _wirkrichtung = null;
        if (_point != null) {
            _wirkrichtung = _point.getWirkrichtung();
        }
        ENUMWirkrichtung _wert = null;
        if (_wirkrichtung != null) {
            _wert = _wirkrichtung.getWert();
        }
        boolean bl2 = _not_1 = !(_isInWirkrichtung = ENUMWirkrichtungExtensions.isInWirkrichtung(_wert, edgePoint.getEdge()));
        if (_not_1) {
            return false;
        }
        Punkt_Objekt punktObjekt = PunktObjektTopKanteExtensions.getPunktObjekt((Punkt_Objekt_TOP_Kante_AttributeGroup)edgePoint.getPoint());
        if (!(punktObjekt instanceof Signal)) {
            return false;
        }
        Signal signal = (Signal)punktObjekt;
        Signal_Real_AttributeGroup _signalReal = signal.getSignalReal();
        Signal_Real_Aktiv_Schirm_AttributeGroup _signalRealAktivSchirm = null;
        if (_signalReal != null) {
            _signalRealAktivSchirm = _signalReal.getSignalRealAktivSchirm();
        }
        Signal_Art_TypeClass _signalArt = null;
        if (_signalRealAktivSchirm != null) {
            _signalArt = _signalRealAktivSchirm.getSignalArt();
        }
        ENUMSignalArt _wert_1 = null;
        if (_signalArt != null) {
            _wert_1 = _signalArt.getWert();
        }
        if ((signalArt = _wert_1) != ENUMSignalArt.ENUM_SIGNAL_ART_VORSIGNAL && signalArt != ENUMSignalArt.ENUM_SIGNAL_ART_VORSIGNALWIEDERHOLER && !SignalExtensions.isAlleinstehendesZusatzsignal(signal)) {
            return false;
        }
        boolean _isKennlichtSignalisierung = FstrZugRangierExtensions.isKennlichtSignalisierung(fstrZugRangier, signal);
        return !_isKennlichtSignalisierung;
    }

    public static String transformFahrwegStartZiel(Fstr_Fahrweg fahrweg) {
        StringConcatenation _builder = new StringConcatenation();
        Signal _start = null;
        if (fahrweg != null) {
            _start = FahrwegExtensions.getStart(fahrweg);
        }
        Bezeichnung_Element_AttributeGroup _bezeichnung = null;
        if (_start != null) {
            _bezeichnung = _start.getBezeichnung();
        }
        Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
        if (_bezeichnung != null) {
            _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
        }
        String _wert = null;
        if (_bezeichnungTabelle != null) {
            _wert = _bezeichnungTabelle.getWert();
        }
        _builder.append(_wert);
        _builder.append("/");
        Signal _zielSignal = null;
        if (fahrweg != null) {
            _zielSignal = FahrwegExtensions.getZielSignal(fahrweg);
        }
        Bezeichnung_Element_AttributeGroup _bezeichnung_1 = null;
        if (_zielSignal != null) {
            _bezeichnung_1 = _zielSignal.getBezeichnung();
        }
        Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle_1 = null;
        if (_bezeichnung_1 != null) {
            _bezeichnungTabelle_1 = _bezeichnung_1.getBezeichnungTabelle();
        }
        String _wert_1 = null;
        if (_bezeichnungTabelle_1 != null) {
            _wert_1 = _bezeichnungTabelle_1.getWert();
        }
        _builder.append(_wert_1);
        return _builder.toString();
    }

    public static boolean isZOrGz(Fstr_Zug_Art_TypeClass fstrZugArt) {
        String rangierArt;
        ENUMFstrZugArt _wert = null;
        if (fstrZugArt != null) {
            _wert = fstrZugArt.getWert();
        }
        String _literal = null;
        if (_wert != null) {
            _literal = _wert.getLiteral();
        }
        return (rangierArt = _literal).matches("Z.*") || rangierArt.matches("GZ.*");
    }

    public static boolean isZ(Fstr_Zug_Art_TypeClass typeClazz) {
        String lit;
        ENUMFstrZugArt _wert = null;
        if (typeClazz != null) {
            _wert = typeClazz.getWert();
        }
        String _literal = null;
        if (_wert != null) {
            _literal = _wert.getLiteral();
        }
        return (lit = _literal) != null && lit.matches("Z.*");
    }

    public static boolean isR(Fstr_Zug_Rangier fstrZugRangier) {
        Fstr_Rangier_AttributeGroup _fstrRangier = null;
        if (fstrZugRangier != null) {
            _fstrRangier = fstrZugRangier.getFstrRangier();
        }
        Fstr_Rangier_Art_TypeClass _fstrRangierArt = null;
        if (_fstrRangier != null) {
            _fstrRangierArt = _fstrRangier.getFstrRangierArt();
        }
        ENUMFstrRangierArt _wert = null;
        if (_fstrRangierArt != null) {
            _wert = _fstrRangierArt.getWert();
        }
        String _literal = null;
        if (_wert != null) {
            _literal = _wert.getLiteral();
        }
        String _substring = null;
        if (_literal != null) {
            _substring = _literal.substring(0, 1);
        }
        return Objects.equal(_substring, (Object)"R");
    }

    private static int _getVmax(Object object, Fstr_Fahrweg fw) {
        return -1;
    }

    private static int _getVmax(W_Kr_Gsp_Komponente object, Fstr_Fahrweg fw) {
        Kreuzung_AttributeGroup kreuzung = object.getKreuzung();
        Zungenpaar_AttributeGroup zungenpaar = object.getZungenpaar();
        if (kreuzung != null && zungenpaar == null) {
            return FstrZugRangierExtensions.getVmaxKreuzung(kreuzung, fw);
        }
        if (kreuzung == null && zungenpaar != null) {
            return FstrZugRangierExtensions.getVmaxWeiche(zungenpaar, FahrwegExtensions.getWeichenSchenkel(fw, object));
        }
        return Integer.MAX_VALUE;
    }

    private static int _getVmax(Gleis_Abschnitt object, Fstr_Fahrweg fw) {
        BigInteger geschwindigkeit;
        Geschwindigkeit_TypeClass _geschwindigkeit = object.getGeschwindigkeit();
        BigInteger _wert = null;
        if (_geschwindigkeit != null) {
            _wert = _geschwindigkeit.getWert();
        }
        if ((geschwindigkeit = _wert) != null) {
            return geschwindigkeit.intValue();
        }
        return -1;
    }

    private static int getVmaxKreuzung(Kreuzung_AttributeGroup object, Fstr_Fahrweg fw) {
        CrossingRoute crossingRoute = FahrwegExtensions.getCrossingRoute(fw, object);
        boolean _equals = Objects.equal((Object)((Object)crossingRoute), (Object)((Object)CrossingRoute.LEFT));
        if (_equals) {
            return object.getGeschwindigkeitL().getWert().intValue();
        }
        boolean _equals_1 = Objects.equal((Object)((Object)crossingRoute), (Object)((Object)CrossingRoute.RIGHT));
        if (_equals_1) {
            return object.getGeschwindigkeitR().getWert().intValue();
        }
        String _string = crossingRoute.toString();
        throw new IllegalArgumentException(_string);
    }

    private static int getVmaxWeiche(Zungenpaar_AttributeGroup object, WeichenSchenkel schenkel) {
        if (schenkel.lage == WeichenSchenkel.Lage.L) {
            BigInteger _elvis = null;
            Geschwindigkeit_L_TypeClass _geschwindigkeitL = null;
            if (object != null) {
                _geschwindigkeitL = object.getGeschwindigkeitL();
            }
            BigInteger _wert = null;
            if (_geschwindigkeitL != null) {
                _wert = _geschwindigkeitL.getWert();
            }
            _elvis = _wert != null ? _wert : BigInteger.ZERO;
            return _elvis.intValue();
        }
        BigInteger _elvis_1 = null;
        Geschwindigkeit_R_TypeClass _geschwindigkeitR = null;
        if (object != null) {
            _geschwindigkeitR = object.getGeschwindigkeitR();
        }
        BigInteger _wert_1 = null;
        if (_geschwindigkeitR != null) {
            _wert_1 = _geschwindigkeitR.getWert();
        }
        _elvis_1 = _wert_1 != null ? _wert_1 : BigInteger.ZERO;
        return _elvis_1.intValue();
    }

    private static int getVmax(Object object, Fstr_Fahrweg fw) {
        if (object instanceof Gleis_Abschnitt) {
            return FstrZugRangierExtensions._getVmax((Gleis_Abschnitt)object, fw);
        }
        if (object instanceof W_Kr_Gsp_Komponente) {
            return FstrZugRangierExtensions._getVmax((W_Kr_Gsp_Komponente)object, fw);
        }
        if (object != null) {
            return FstrZugRangierExtensions._getVmax(object, fw);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(object, fw).toString());
    }
}

