/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.graph.Digraph;
import org.eclipse.set.basis.graph.Digraphs;
import org.eclipse.set.basis.graph.DirectedEdge;
import org.eclipse.set.basis.graph.DirectedEdgePath;
import org.eclipse.set.basis.graph.Routing;
import org.eclipse.set.ppmodel.extensions.AussenelementansteuerungExtensions;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.FahrwegExtensions;
import org.eclipse.set.ppmodel.extensions.FstrZugRangierExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektTopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.SignalRahmenExtensions;
import org.eclipse.set.ppmodel.extensions.SignalbegriffExtensions;
import org.eclipse.set.ppmodel.extensions.StellelementExtensions;
import org.eclipse.set.ppmodel.extensions.UrObjectExtensions;
import org.eclipse.set.ppmodel.extensions.utils.CollectionExtensions;
import org.eclipse.set.ppmodel.extensions.utils.Debug;
import org.eclipse.set.ppmodel.extensions.utils.DirectedTopKante;
import org.eclipse.set.ppmodel.extensions.utils.TopGraph;
import org.eclipse.set.ppmodel.extensions.utils.TopRouting;
import org.eclipse.set.toolboxmodel.Ansteuerung_Element.AEA_Allg_AttributeGroup;
import org.eclipse.set.toolboxmodel.Ansteuerung_Element.Aussenelementansteuerung;
import org.eclipse.set.toolboxmodel.Ansteuerung_Element.Aussenelementansteuerung_Art_TypeClass;
import org.eclipse.set.toolboxmodel.Ansteuerung_Element.ENUMAussenelementansteuerungArt;
import org.eclipse.set.toolboxmodel.Ansteuerung_Element.Stellelement;
import org.eclipse.set.toolboxmodel.Ansteuerung_Element.Unterbringung;
import org.eclipse.set.toolboxmodel.BasisTypen.Bezeichnung_Element_AttributeGroup;
import org.eclipse.set.toolboxmodel.BasisTypen.Bezeichnung_Tabelle_TypeClass;
import org.eclipse.set.toolboxmodel.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.toolboxmodel.Basisobjekte.Basis_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Fahrweg;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Rangier_AttributeGroup;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Zug_AttributeGroup;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Zug_Rangier;
import org.eclipse.set.toolboxmodel.Flankenschutz.Fla_Schutz;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Knoten;
import org.eclipse.set.toolboxmodel.Gleis.Gleis_Bezeichnung;
import org.eclipse.set.toolboxmodel.Ortung.Schaltmittel_Zuordnung;
import org.eclipse.set.toolboxmodel.Signalbegriffe_Ril_301.Zs3v;
import org.eclipse.set.toolboxmodel.Signalbegriffe_Struktur.Signalbegriff_ID_TypeClass;
import org.eclipse.set.toolboxmodel.Signale.ENUMSignalFunktion;
import org.eclipse.set.toolboxmodel.Signale.Signal;
import org.eclipse.set.toolboxmodel.Signale.Signal_Befestigung;
import org.eclipse.set.toolboxmodel.Signale.Signal_Fstr_Aus_Inselgleis_AttributeGroup;
import org.eclipse.set.toolboxmodel.Signale.Signal_Fstr_S_AttributeGroup;
import org.eclipse.set.toolboxmodel.Signale.Signal_Funktion_TypeClass;
import org.eclipse.set.toolboxmodel.Signale.Signal_Rahmen;
import org.eclipse.set.toolboxmodel.Signale.Signal_Real_Aktiv_AttributeGroup;
import org.eclipse.set.toolboxmodel.Signale.Signal_Real_AttributeGroup;
import org.eclipse.set.toolboxmodel.Signale.Signal_Signalbegriff;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Gsp_Element;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Weiche_Element_AttributeGroup;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalExtensions
extends PunktObjektExtensions {
    private static final Logger logger = LoggerFactory.getLogger(SignalExtensions.class);
    private static final double ABSTAND_VORSIGNALBAKE = 260.0;
    private static final String PREFIX_VORSIGNALBAKE = "Ne3";

    public static List<Fla_Schutz> flaSchutz(final Signal signal) {
        Functions.Function1<Fla_Schutz, Boolean> _function = new Functions.Function1<Fla_Schutz, Boolean>(){

            public Boolean apply(Fla_Schutz it) {
                return it.getFlaSchutzSignal() != null && Objects.equal((Object)it.getFlaSchutzSignal().getIDFlaSignal().getIdentitaet().getWert(), (Object)signal.getIdentitaet().getWert());
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)signal).getFlaSchutz(), (Functions.Function1)_function));
    }

    public static boolean isStartOfAnyTrainRoute(Signal signal) {
        Iterable _fstrZugRangier = BasisAttributExtensions.getContainer((EObject)signal).getFstrZugRangier();
        for (Fstr_Zug_Rangier zugRangier : _fstrZugRangier) {
            boolean _tripleNotEquals;
            boolean _and = false;
            Fstr_Zug_AttributeGroup _fstrZug = null;
            if (zugRangier != null) {
                _fstrZug = zugRangier.getFstrZug();
            }
            boolean bl = _tripleNotEquals = _fstrZug != null;
            if (!_tripleNotEquals) {
                _and = false;
            } else {
                boolean _equals;
                Fstr_Fahrweg _fstrFahrweg = null;
                if (zugRangier != null) {
                    _fstrFahrweg = FstrZugRangierExtensions.getFstrFahrweg(zugRangier);
                }
                Signal _start = null;
                if (_fstrFahrweg != null) {
                    _start = FahrwegExtensions.getStart(_fstrFahrweg);
                }
                Identitaet_TypeClass _identitaet = null;
                if (_start != null) {
                    _identitaet = _start.getIdentitaet();
                }
                String _wert = null;
                if (_identitaet != null) {
                    _wert = _identitaet.getWert();
                }
                Identitaet_TypeClass _identitaet_1 = null;
                if (signal != null) {
                    _identitaet_1 = signal.getIdentitaet();
                }
                String _wert_1 = null;
                if (_identitaet_1 != null) {
                    _wert_1 = _identitaet_1.getWert();
                }
                _and = _equals = _wert.equals(_wert_1);
            }
            if (!_and) continue;
            return true;
        }
        return false;
    }

    public static boolean isStartOrDestinationOfAnyShuntingRoute(Signal signal, boolean isStart) {
        Iterable _fstrZugRangier = BasisAttributExtensions.getContainer((EObject)signal).getFstrZugRangier();
        for (Fstr_Zug_Rangier zugRangier : _fstrZugRangier) {
            boolean _equals;
            boolean _tripleNotEquals;
            String IDEnd = null;
            if (isStart) {
                Fstr_Fahrweg _fstrFahrweg = null;
                if (zugRangier != null) {
                    _fstrFahrweg = FstrZugRangierExtensions.getFstrFahrweg(zugRangier);
                }
                Signal _iDStart = null;
                if (_fstrFahrweg != null) {
                    _iDStart = _fstrFahrweg.getIDStart();
                }
                Identitaet_TypeClass _identitaet = null;
                if (_iDStart != null) {
                    _identitaet = _iDStart.getIdentitaet();
                }
                String _wert = null;
                if (_identitaet != null) {
                    _wert = _identitaet.getWert();
                }
                IDEnd = _wert;
            } else {
                Fstr_Fahrweg _fstrFahrweg_1 = null;
                if (zugRangier != null) {
                    _fstrFahrweg_1 = FstrZugRangierExtensions.getFstrFahrweg(zugRangier);
                }
                Basis_Objekt _iDZiel = null;
                if (_fstrFahrweg_1 != null) {
                    _iDZiel = _fstrFahrweg_1.getIDZiel();
                }
                Identitaet_TypeClass _identitaet_1 = null;
                if (_iDZiel != null) {
                    _identitaet_1 = _iDZiel.getIdentitaet();
                }
                String _wert_1 = null;
                if (_identitaet_1 != null) {
                    _wert_1 = _identitaet_1.getWert();
                }
                IDEnd = _wert_1;
            }
            boolean _and = false;
            Fstr_Rangier_AttributeGroup _fstrRangier = null;
            if (zugRangier != null) {
                _fstrRangier = zugRangier.getFstrRangier();
            }
            if (!(_and = !(_tripleNotEquals = _fstrRangier != null) ? false : (_equals = signal.getIdentitaet().getWert().equals(IDEnd)))) continue;
            return true;
        }
        return false;
    }

    public static List<Signal_Rahmen> signalRahmen(final Signal signal) {
        Functions.Function1<Signal_Rahmen, Boolean> _function = new Functions.Function1<Signal_Rahmen, Boolean>(){

            public Boolean apply(Signal_Rahmen r) {
                Signal _signal = SignalRahmenExtensions.getSignal(r);
                return Objects.equal((Object)_signal, (Object)signal);
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)signal).getSignalRahmen(), (Functions.Function1)_function));
    }

    public static boolean isAlleinstehendesZusatzsignal(Signal signal) {
        Signal_Real_AttributeGroup _signalReal = signal.getSignalReal();
        Signal_Funktion_TypeClass _signalFunktion = null;
        if (_signalReal != null) {
            _signalFunktion = _signalReal.getSignalFunktion();
        }
        ENUMSignalFunktion _wert = null;
        if (_signalFunktion != null) {
            _wert = _signalFunktion.getWert();
        }
        ENUMSignalFunktion signalFunktion = _wert;
        Set<Signal_Signalbegriff> signalbegriffe = SignalExtensions.getSignalbegriffe(signal);
        return signalFunktion == ENUMSignalFunktion.ENUM_SIGNAL_FUNKTION_ALLEINSTEHENDES_ZUSATZSIGNAL && SignalbegriffExtensions.containsSignalbegriffID(signalbegriffe, Zs3v.class);
    }

    public static boolean isInWirkrichtungOfSignal(TopGraph topGraph, Signal signal, Punkt_Objekt object) {
        Functions.Function1<DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Set<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>>> _function = new Functions.Function1<DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Set<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>>>(){

            public Set<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>> apply(DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> it) {
                return it.getEdges();
            }
        };
        Functions.Function1<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Boolean> _function_1 = new Functions.Function1<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Boolean>(){

            public Boolean apply(DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> it) {
                boolean _isForwards = it.isForwards();
                return _isForwards;
            }
        };
        return IterableExtensions.forall((Iterable)IterableExtensions.flatMap((Iterable)Digraphs.getPaths((Digraph)topGraph, PunktObjektExtensions.getSinglePoints((Punkt_Objekt)signal), PunktObjektExtensions.getSinglePoints(object)), (Functions.Function1)_function), (Functions.Function1)_function_1);
    }

    public static List<Signal_Rahmen> signalRahmenForBefestigung(Signal signal, final List<Signal_Befestigung> gruppe) {
        Functions.Function1<Signal_Rahmen, Boolean> _function = new Functions.Function1<Signal_Rahmen, Boolean>(){

            public Boolean apply(Signal_Rahmen it) {
                Functions.Function1<Signal_Befestigung, String> _function = new Functions.Function1<Signal_Befestigung, String>(){

                    public String apply(Signal_Befestigung it_1) {
                        return it_1.getIdentitaet().getWert();
                    }
                };
                Identitaet_TypeClass _identitaet = it.getIDSignalBefestigung().getIdentitaet();
                String _wert = null;
                if (_identitaet != null) {
                    _wert = _identitaet.getWert();
                }
                return ListExtensions.map((List)gruppe, (Functions.Function1)_function).contains(_wert);
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter(SignalExtensions.signalRahmen(signal), (Functions.Function1)_function));
    }

    public static double rotation(Signal signal) {
        return PunktObjektTopKanteExtensions.getCoordinate(PunktObjektExtensions.getSinglePoints((Punkt_Objekt)signal).get(0)).getEffectiveRotation();
    }

    public static List<Signal> getVorsignalbaken(final Signal signal) {
        List<TOP_Kante> topKanten = PunktObjektExtensions.getTopKanten((Punkt_Objekt)signal);
        int _size = topKanten.size();
        boolean _equals = _size == 1;
        Assert.isTrue((boolean)_equals);
        TOP_Kante topKante = topKanten.get(0);
        ENUMWirkrichtung wirkrichtung = PunktObjektExtensions.getWirkrichtung((Punkt_Objekt)signal, topKante);
        boolean isForward = Objects.equal((Object)wirkrichtung, (Object)ENUMWirkrichtung.ENUM_WIRKRICHTUNG_GEGEN);
        DirectedTopKante start = new DirectedTopKante(topKante, isForward);
        TopRouting _topRouting = new TopRouting();
        Set paths = Digraphs.getPaths((DirectedEdge)start, (Routing)_topRouting, (double)260.0);
        Consumer<DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>> _function = new Consumer<DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>>(){

            @Override
            public void accept(DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> it) {
                it.setStart((Object)PunktObjektExtensions.getSinglePoint((Punkt_Objekt)signal));
            }
        };
        paths.forEach(_function);
        boolean _isDebugEnabled = logger.isDebugEnabled();
        if (_isDebugEnabled) {
            Bezeichnung_Element_AttributeGroup _bezeichnung = null;
            if (signal != null) {
                _bezeichnung = signal.getBezeichnung();
            }
            Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
            if (_bezeichnung != null) {
                _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
            }
            String _wert = null;
            if (_bezeichnungTabelle != null) {
                _wert = _bezeichnungTabelle.getWert();
            }
            String bezeichnung = _wert;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Searchpaths for Vorsignalbaken of ");
            _builder.append(bezeichnung);
            _builder.append(":");
            logger.debug(_builder.toString());
            logger.debug(Debug.debugString(paths));
        }
        Functions.Function1<DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, List<Signal>> _function_1 = new Functions.Function1<DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, List<Signal>>(){

            public List<Signal> apply(DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> it) {
                List _xblockexpression = null;
                final DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> itsPath = it;
                Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Punkt_Objekt> _function = new Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Punkt_Objekt>(){

                    public Punkt_Objekt apply(Punkt_Objekt_TOP_Kante_AttributeGroup it_1) {
                        return PunktObjektTopKanteExtensions.getPunktObjekt(it_1);
                    }
                };
                Functions.Function1<Signal, Boolean> _function_1 = new Functions.Function1<Signal, Boolean>(){

                    public Boolean apply(Signal it_1) {
                        double _distance = itsPath.distance((Object)PunktObjektExtensions.getSinglePoint((Punkt_Objekt)signal), (Object)PunktObjektExtensions.getSinglePoint((Punkt_Objekt)it_1));
                        return _distance < 260.0;
                    }
                };
                Functions.Function1<Signal, Boolean> _function_2 = new Functions.Function1<Signal, Boolean>(){

                    public Boolean apply(Signal it_1) {
                        return SignalExtensions.isVorsignalbake(it_1);
                    }
                };
                _xblockexpression = IteratorExtensions.toList((Iterator)IteratorExtensions.filter((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)IteratorExtensions.map((Iterator)it.getPointIterator(), (Functions.Function1)_function), Signal.class), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
                return _xblockexpression;
            }
        };
        return IterableExtensions.toList((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)paths, (Functions.Function1)_function_1)));
    }

    public static Set<Signalbegriff_ID_TypeClass> getSignalbegriffIds(Signal signal) {
        Functions.Function1<Signal_Rahmen, List<Signal_Signalbegriff>> _function = new Functions.Function1<Signal_Rahmen, List<Signal_Signalbegriff>>(){

            public List<Signal_Signalbegriff> apply(Signal_Rahmen it) {
                return SignalRahmenExtensions.getSignalbegriffe(it);
            }
        };
        Functions.Function1<Signal_Signalbegriff, Signalbegriff_ID_TypeClass> _function_1 = new Functions.Function1<Signal_Signalbegriff, Signalbegriff_ID_TypeClass>(){

            public Signalbegriff_ID_TypeClass apply(Signal_Signalbegriff it) {
                return it.getSignalbegriffID();
            }
        };
        return IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)Iterables.concat((Iterable)ListExtensions.map(SignalExtensions.signalRahmen(signal), (Functions.Function1)_function)), (Functions.Function1)_function_1));
    }

    public static Set<Signal_Signalbegriff> getSignalbegriffe(Signal signal) {
        Functions.Function1<Signal_Rahmen, List<Signal_Signalbegriff>> _function = new Functions.Function1<Signal_Rahmen, List<Signal_Signalbegriff>>(){

            public List<Signal_Signalbegriff> apply(Signal_Rahmen it) {
                return SignalRahmenExtensions.getSignalbegriffe(it);
            }
        };
        return IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)ListExtensions.map(SignalExtensions.signalRahmen(signal), (Functions.Function1)_function)));
    }

    public static boolean isVorsignalbake(Signal signal) {
        Functions.Function1<Signalbegriff_ID_TypeClass, Boolean> _function = new Functions.Function1<Signalbegriff_ID_TypeClass, Boolean>(){

            public Boolean apply(Signalbegriff_ID_TypeClass it) {
                return UrObjectExtensions.getTypeName((EObject)it).startsWith(SignalExtensions.PREFIX_VORSIGNALBAKE);
            }
        };
        return IterableExtensions.exists(SignalExtensions.getSignalbegriffIds(signal), (Functions.Function1)_function);
    }

    public static List<Schaltmittel_Zuordnung> getAnrueckverschluss(Signal signal) {
        Object _elvis = null;
        Signal_Fstr_S_AttributeGroup _signalFstrS = null;
        if (signal != null) {
            _signalFstrS = signal.getSignalFstrS();
        }
        EList _iDAnrueckverschluss = null;
        if (_signalFstrS != null) {
            _iDAnrueckverschluss = _signalFstrS.getIDAnrueckverschluss();
        }
        if (_iDAnrueckverschluss != null) {
            _elvis = _iDAnrueckverschluss;
        } else {
            List _emptyList = Collections.emptyList();
            _elvis = _emptyList;
        }
        return _elvis;
    }

    public static Unterbringung getControlBox(Signal signal) {
        boolean _tripleEquals;
        Stellelement _realAktivStellelement = SignalExtensions.getRealAktivStellelement(signal);
        Aussenelementansteuerung _energie = null;
        if (_realAktivStellelement != null) {
            _energie = StellelementExtensions.getEnergie(_realAktivStellelement);
        }
        Aussenelementansteuerung energie = _energie;
        AEA_Allg_AttributeGroup _aEAAllg = null;
        if (energie != null) {
            _aEAAllg = energie.getAEAAllg();
        }
        Aussenelementansteuerung_Art_TypeClass _aussenelementansteuerungArt = null;
        if (_aEAAllg != null) {
            _aussenelementansteuerungArt = _aEAAllg.getAussenelementansteuerungArt();
        }
        ENUMAussenelementansteuerungArt _wert = null;
        if (_aussenelementansteuerungArt != null) {
            _wert = _aussenelementansteuerungArt.getWert();
        }
        boolean bl = _tripleEquals = _wert == ENUMAussenelementansteuerungArt.ENUM_AUSSENELEMENTANSTEUERUNG_ART_OBJEKTCONTROLLER;
        if (_tripleEquals) {
            return AussenelementansteuerungExtensions.getUnterbringung(energie);
        }
        return null;
    }

    public static Stellelement getRealAktivStellelement(Signal signal) {
        Signal_Real_AttributeGroup _signalReal = signal.getSignalReal();
        Signal_Real_Aktiv_AttributeGroup _signalRealAktiv = null;
        if (_signalReal != null) {
            _signalRealAktiv = _signalReal.getSignalRealAktiv();
        }
        Stellelement _iDStellelement = null;
        if (_signalRealAktiv != null) {
            _iDStellelement = _signalRealAktiv.getIDStellelement();
        }
        return _iDStellelement;
    }

    public static Stellelement getStellelement(Signal signal) {
        Signal_Real_AttributeGroup _signalReal = signal.getSignalReal();
        Signal_Real_Aktiv_AttributeGroup _signalRealAktiv = null;
        if (_signalReal != null) {
            _signalRealAktiv = _signalReal.getSignalRealAktiv();
        }
        Signal_Real_Aktiv_AttributeGroup signalRealAktiv = _signalRealAktiv;
        Stellelement _iDStellelement = null;
        if (signalRealAktiv != null) {
            _iDStellelement = signalRealAktiv.getIDStellelement();
        }
        return _iDStellelement;
    }

    public static W_Kr_Gsp_Element getWKrGspElement(final Signal signal) {
        boolean _equals;
        Functions.Function1<W_Kr_Gsp_Element, Boolean> _function = new Functions.Function1<W_Kr_Gsp_Element, Boolean>(){

            public Boolean apply(W_Kr_Gsp_Element it) {
                Weiche_Element_AttributeGroup _weicheElement = it.getWeicheElement();
                Signal _iDGrenzzeichen = null;
                if (_weicheElement != null) {
                    _iDGrenzzeichen = _weicheElement.getIDGrenzzeichen();
                }
                Identitaet_TypeClass _identitaet = null;
                if (_iDGrenzzeichen != null) {
                    _identitaet = _iDGrenzzeichen.getIdentitaet();
                }
                String _wert = null;
                if (_identitaet != null) {
                    _wert = _identitaet.getWert();
                }
                String _wert_1 = signal.getIdentitaet().getWert();
                return Objects.equal((Object)_wert, (Object)_wert_1);
            }
        };
        Iterable weichenElemente = IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)signal).getWKrGspElement(), (Functions.Function1)_function);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)weichenElemente);
        if (_isEmpty) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("No weicheElement.IDGrenzzeichen found for Signal ");
            String _wert = signal.getIdentitaet().getWert();
            _builder.append(_wert);
            _builder.append(".");
            logger.debug(_builder.toString());
            return null;
        }
        int _size = IterableExtensions.size((Iterable)weichenElemente);
        boolean bl = _equals = _size == 1;
        if (_equals) {
            return ((W_Kr_Gsp_Element[])Conversions.unwrapArray((Object)weichenElemente, W_Kr_Gsp_Element.class))[0];
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Signal ");
        String _wert_1 = signal.getIdentitaet().getWert();
        _builder_1.append(_wert_1);
        _builder_1.append(" is Grenzzeichen for {");
        boolean _hasElements = false;
        for (W_Kr_Gsp_Element e : weichenElemente) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder_1.appendImmediate((Object)", ", "");
            }
            Bezeichnung_Element_AttributeGroup _bezeichnung = e.getBezeichnung();
            Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
            if (_bezeichnung != null) {
                _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
            }
            String _wert_2 = null;
            if (_bezeichnungTabelle != null) {
                _wert_2 = _bezeichnungTabelle.getWert();
            }
            _builder_1.append(_wert_2);
        }
        _builder_1.append("}");
        throw new IllegalArgumentException(_builder_1.toString());
    }

    public static <T extends Signalbegriff_ID_TypeClass> boolean hasSignalbegriffID(Signal signal, Class<T> type) {
        return SignalbegriffExtensions.containsSignalbegriffID(SignalExtensions.getSignalbegriffe(signal), type);
    }

    public static <T extends Signalbegriff_ID_TypeClass> Set<Signal_Signalbegriff> getSignalbegriffe(Signal signal, final Class<T> type) {
        Functions.Function1<Signal_Signalbegriff, Boolean> _function = new Functions.Function1<Signal_Signalbegriff, Boolean>(){

            public Boolean apply(Signal_Signalbegriff it) {
                return SignalbegriffExtensions.hasSignalbegriffID(it, type);
            }
        };
        return IterableExtensions.toSet((Iterable)IterableExtensions.filter(SignalExtensions.getSignalbegriffe(signal), (Functions.Function1)_function));
    }

    public static Set<Gleis_Bezeichnung> getRaFahrtGleichzeitigVerbot(Signal signal) {
        Object _elvis = null;
        Signal_Fstr_Aus_Inselgleis_AttributeGroup _signalFstrAusInselgleis = null;
        if (signal != null) {
            _signalFstrAusInselgleis = signal.getSignalFstrAusInselgleis();
        }
        EList _iDRaFahrtGleichzeitigVerbot = null;
        if (_signalFstrAusInselgleis != null) {
            _iDRaFahrtGleichzeitigVerbot = _signalFstrAusInselgleis.getIDRaFahrtGleichzeitigVerbot();
        }
        if (_iDRaFahrtGleichzeitigVerbot != null) {
            _elvis = _iDRaFahrtGleichzeitigVerbot;
        } else {
            Set _emptySet = Collections.emptySet();
            _elvis = _emptySet;
        }
        return IterableExtensions.toSet((Iterable)_elvis);
    }

    public static Set<Gleis_Bezeichnung> getZgFahrtGleichzeitigVerbot(Signal signal) {
        Object _elvis = null;
        Signal_Fstr_Aus_Inselgleis_AttributeGroup _signalFstrAusInselgleis = null;
        if (signal != null) {
            _signalFstrAusInselgleis = signal.getSignalFstrAusInselgleis();
        }
        EList _iDZgFahrtGleichzeitigVerbot = null;
        if (_signalFstrAusInselgleis != null) {
            _iDZgFahrtGleichzeitigVerbot = _signalFstrAusInselgleis.getIDZgFahrtGleichzeitigVerbot();
        }
        if (_iDZgFahrtGleichzeitigVerbot != null) {
            _elvis = _iDZgFahrtGleichzeitigVerbot;
        } else {
            Set _emptySet = Collections.emptySet();
            _elvis = _emptySet;
        }
        return IterableExtensions.toSet((Iterable)_elvis);
    }

    public static Schaltmittel_Zuordnung getZweitesHaltfallkriterium(Signal signal) {
        Signal_Fstr_S_AttributeGroup _signalFstrS = null;
        if (signal != null) {
            _signalFstrS = signal.getSignalFstrS();
        }
        Schaltmittel_Zuordnung _iDZweitesHaltfallkriterium = null;
        if (_signalFstrS != null) {
            _iDZweitesHaltfallkriterium = _signalFstrS.getIDZweitesHaltfallkriterium();
        }
        return _iDZweitesHaltfallkriterium;
    }

    public static Punkt_Objekt_TOP_Kante_AttributeGroup getMountPoint(Signal signal, final Signal_Befestigung signalBefestigung) {
        Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Boolean> _function = new Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Boolean>(){

            public Boolean apply(Punkt_Objekt_TOP_Kante_AttributeGroup e) {
                Identitaet_TypeClass _identitaet_1;
                Identitaet_TypeClass _identitaet = PunktObjektTopKanteExtensions.getTopKante(e).getIdentitaet();
                return _identitaet == (_identitaet_1 = PunktObjektTopKanteExtensions.getTopKante(CollectionExtensions.getUnique(PunktObjektExtensions.getSinglePoints((Punkt_Objekt)signalBefestigung))).getIdentitaet());
            }
        };
        return (Punkt_Objekt_TOP_Kante_AttributeGroup)CollectionExtensions.getUnique(IterableExtensions.toList((Iterable)IterableExtensions.filter(PunktObjektExtensions.getSinglePoints((Punkt_Objekt)signal), (Functions.Function1)_function)));
    }
}

