/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.table;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.set.model.tablemodel.CellContent;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.RowGroup;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.extensions.CellContentExtensions;
import org.eclipse.set.model.tablemodel.extensions.ColumnDescriptorExtensions;
import org.eclipse.set.utils.table.TableRowData;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class TableDataProvider
implements IDataProvider {
    private int columnCount;
    protected List<TableRowData> tableContents;
    private UnaryOperator<Integer> getSourceLine;
    protected Map<Integer, Object> filters = CollectionLiterals.newHashMap();
    protected Table table;
    private static final String EXCULDE_FILTER_SIGN = "-";
    protected Pair<Integer, Comparator<? super String>> currentComparator;

    public TableDataProvider(Table table, UnaryOperator<Integer> getSourceLine) {
        this.getSourceLine = getSourceLine;
        this.table = table;
        this.refresh();
    }

    public void refresh(Table table) {
        this.table = table;
        this.refresh();
    }

    public void refresh() {
        Functions.Function1<ColumnDescriptor, List<ColumnDescriptor>> _function = new Functions.Function1<ColumnDescriptor, List<ColumnDescriptor>>(){

            public List<ColumnDescriptor> apply(ColumnDescriptor it) {
                return ColumnDescriptorExtensions.getLeaves((ColumnDescriptor)it);
            }
        };
        this.columnCount = IterableExtensions.toSet((Iterable)IterableExtensions.flatMap((Iterable)this.table.getColumndescriptors(), (Functions.Function1)_function)).size();
        List rowGroups = IterableExtensions.toList((Iterable)IterableExtensions.sortWith((Iterable)this.table.getTablecontent().getRowgroups(), this.tableRowGroupComparator()));
        Functions.Function1<RowGroup, EList<TableRow>> _function_1 = new Functions.Function1<RowGroup, EList<TableRow>>(){

            public EList<TableRow> apply(RowGroup it) {
                return it.getRows();
            }
        };
        Functions.Function1<Pair<Integer, TableRow>, TableRowData> _function_2 = new Functions.Function1<Pair<Integer, TableRow>, TableRowData>(){

            public TableRowData apply(Pair<Integer, TableRow> it) {
                Integer _key = (Integer)it.getKey();
                TableRow _value = (TableRow)it.getValue();
                return new TableRowData(_key, _value);
            }
        };
        Functions.Function1<TableRowData, Boolean> _function_3 = new Functions.Function1<TableRowData, Boolean>(){

            public Boolean apply(TableRowData it) {
                return TableDataProvider.this.filterMatch(it);
            }
        };
        this.tableContents = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)IterableExtensions.indexed((Iterable)IterableExtensions.flatMap((Iterable)rowGroups, (Functions.Function1)_function_1)), (Functions.Function1)_function_2), (Functions.Function1)_function_3));
    }

    protected boolean filterMatch(TableRowData row) {
        int i = 0;
        while (i < this.columnCount) {
            boolean _containsKey = this.filters.containsKey(i);
            if (_containsKey) {
                boolean _tripleEquals;
                String content = CellContentExtensions.getPlainStringValue((CellContent)row.getContents().get(i)).toLowerCase();
                String filterValue = this.filters.get(i).toString().toLowerCase();
                boolean isExcludeFilter = filterValue.substring(0, 1).equals(EXCULDE_FILTER_SIGN);
                String _xifexpression = null;
                _xifexpression = isExcludeFilter ? filterValue.substring(1) : filterValue;
                filterValue = _xifexpression;
                boolean _contains = content.contains(filterValue);
                boolean bl = _tripleEquals = Boolean.valueOf(isExcludeFilter) == Boolean.valueOf(_contains);
                if (_tripleEquals) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public int getOriginalRowIndex(int row) {
        return this.tableContents.get(row).getRow().getRowIndex();
    }

    public int getObjectSourceLine(int row) {
        Integer _xifexpression = null;
        _xifexpression = this.getSourceLine == null ? Integer.valueOf(-1) : (Integer)this.getSourceLine.apply(row);
        return _xifexpression;
    }

    public TableRowData getRowData(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.tableContents.size()) {
            return this.findRow(rowIndex);
        }
        return null;
    }

    public int getCurrentRowIndex(TableRowData row) {
        return this.tableContents.indexOf(row);
    }

    public TableRowData findRow(final TableRow rowtoFind) {
        Functions.Function1<TableRowData, Boolean> _function = new Functions.Function1<TableRowData, Boolean>(){

            public Boolean apply(TableRowData it) {
                TableRow _row = it.getRow();
                return _row == rowtoFind;
            }
        };
        return (TableRowData)IterableExtensions.findFirst(this.tableContents, (Functions.Function1)_function);
    }

    public TableRowData findRow(final int originalIndex) {
        Functions.Function1<TableRowData, Boolean> _function = new Functions.Function1<TableRowData, Boolean>(){

            public Boolean apply(TableRowData it) {
                int _rowIndex = it.getRow().getRowIndex();
                return _rowIndex == originalIndex;
            }
        };
        return (TableRowData)IterableExtensions.findFirst(this.tableContents, (Functions.Function1)_function);
    }

    public TableRowData getRow(int tableRowPosition) {
        return this.tableContents.get(tableRowPosition);
    }

    public String getObjectScope(int tableRowPosition) {
        CellContent zustandCell;
        Functions.Function1<ColumnDescriptor, Boolean> _function = new Functions.Function1<ColumnDescriptor, Boolean>(){

            public Boolean apply(ColumnDescriptor it) {
                return it.getLabel() != null && it.getLabel().equals("Bereich");
            }
        };
        ColumnDescriptor scopeColumn = (ColumnDescriptor)IterableExtensions.findFirst((Iterable)this.table.getColumndescriptors(), (Functions.Function1)_function);
        if (scopeColumn == null) {
            return null;
        }
        TableRowData _row = this.getRow(tableRowPosition);
        List<CellContent> _contents = null;
        if (_row != null) {
            _contents = _row.getContents();
        }
        CellContent _get = null;
        if (_contents != null) {
            int _indexOf = this.table.getColumndescriptors().indexOf((Object)scopeColumn);
            int _minus = _indexOf - 1;
            _get = _contents.get(_minus);
        }
        if ((zustandCell = _get) == null) {
            return null;
        }
        return CellContentExtensions.getPlainStringValue(zustandCell);
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public Object getDataValue(int columnIndex, int rowIndex) {
        return CellContentExtensions.getRichTextValue((CellContent)this.tableContents.get(rowIndex).getContents().get(columnIndex));
    }

    public int getRowCount() {
        return this.tableContents.size();
    }

    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
        throw new UnsupportedOperationException("Cannot set values in a table");
    }

    public void applyFilter(Map<Integer, Object> filterIndexToObjectMap) {
        this.filters = filterIndexToObjectMap;
        this.refresh();
        this.sort();
    }

    public void sort() {
        if (this.currentComparator != null) {
            this.sort((Integer)this.currentComparator.getKey(), (Comparator)this.currentComparator.getValue());
        }
    }

    public void sort(int column, Comparator<? super String> comparator) {
        Pair _pair;
        this.tableContents = IterableExtensions.sortWith(this.tableContents, this.tableRowDataComparator(column, comparator));
        this.currentComparator = _pair = new Pair((Object)column, comparator);
    }

    protected Comparator<RowGroup> tableRowGroupComparator() {
        Comparator<RowGroup> _function = new Comparator<RowGroup>(){

            @Override
            public int compare(RowGroup group1, RowGroup group2) {
                TableRow lastRow1 = (TableRow)IterableExtensions.last((Iterable)group1.getRows());
                TableRow lastRow2 = (TableRow)IterableExtensions.last((Iterable)group2.getRows());
                return Integer.valueOf(lastRow1.getRowIndex()).compareTo(lastRow2.getRowIndex());
            }
        };
        return _function;
    }

    protected Comparator<TableRowData> tableRowDataComparator(final int column, final Comparator<? super String> comparator) {
        Comparator<TableRowData> _function = new Comparator<TableRowData>(){

            @Override
            public int compare(TableRowData row1, TableRowData row2) {
                return TableDataProvider.this.rowComparator(comparator, column).compare(row1.getContents(), row2.getContents());
            }
        };
        return _function;
    }

    protected Comparator<CellContent> cellComparator(final Comparator<? super String> comparator) {
        Comparator<CellContent> _function = new Comparator<CellContent>(){

            @Override
            public int compare(CellContent cell1, CellContent cell2) {
                return comparator.compare(CellContentExtensions.getPlainStringValue((CellContent)cell1), CellContentExtensions.getPlainStringValue((CellContent)cell2));
            }
        };
        return _function;
    }

    protected Comparator<List<CellContent>> rowComparator(final Comparator<? super String> comparator, final int column) {
        Comparator<List<CellContent>> _function = new Comparator<List<CellContent>>(){

            @Override
            public int compare(List<CellContent> cells1, List<CellContent> cells2) {
                return TableDataProvider.this.cellComparator(comparator).compare(cells1.get(column), cells2.get(column));
            }
        };
        return _function;
    }

    public List<String> transformToCSV() {
        Functions.Function1<TableRowData, String> _function = new Functions.Function1<TableRowData, String>(){

            public String apply(TableRowData it) {
                StringConcatenation _builder = new StringConcatenation();
                List<CellContent> _contents = it.getContents();
                boolean _hasElements = false;
                for (CellContent value : _contents) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)";", "");
                    }
                    _builder.append("\"");
                    String _plainStringValue = CellContentExtensions.getPlainStringValue((CellContent)value);
                    _builder.append(_plainStringValue);
                    _builder.append("\"");
                }
                String _lineSeparator = System.lineSeparator();
                _builder.append(_lineSeparator);
                return _builder.toString();
            }
        };
        return ListExtensions.map(this.tableContents, (Functions.Function1)_function);
    }
}

