/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.table;

import java.util.List;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.RowMergeMode;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.extensions.TableRowExtensions;

public class TableSpanUtils {
    private final List<TableRow> instances;

    public TableSpanUtils(List<TableRow> rows) {
        this.instances = rows;
    }

    public int getRowSpanUp(int column, int row) {
        if (row == 0) {
            return 0;
        }
        if (this.getCellsMergable(column, row, row - 1)) {
            return 1 + this.getRowSpanUp(column, row - 1);
        }
        return 0;
    }

    public int getRowSpanDown(int column, int row) {
        if (row + 1 >= this.instances.size()) {
            return 0;
        }
        if (this.getCellsMergable(column, row, row + 1)) {
            return 1 + this.getRowSpanDown(column, row + 1);
        }
        return 0;
    }

    private boolean getCellsMergable(int column, int rowIndexA, int rowIndexB) {
        TableRow rowA = this.instances.get(rowIndexA);
        TableRow rowB = this.instances.get(rowIndexB);
        if (TableRowExtensions.getGroup((TableRow)rowA) != TableRowExtensions.getGroup((TableRow)rowB)) {
            return false;
        }
        String valueA = TableRowExtensions.getPlainStringValue((TableRow)rowA, (int)column);
        String valueB = TableRowExtensions.getPlainStringValue((TableRow)rowB, (int)column);
        if (valueA == null) {
            return valueB == null;
        }
        return valueA.equals(valueB);
    }

    public boolean isMergeAllowed(int column, int row) {
        TableRow tableRow = this.instances.get(row);
        ColumnDescriptor cd = (ColumnDescriptor)TableRowExtensions.getColumnDescriptors((TableRow)tableRow).get(column);
        while (true) {
            if (cd == null) {
                return false;
            }
            if (cd.getMergeCommonValues() != RowMergeMode.DEFAULT) break;
            cd = cd.getParent();
        }
        return cd.getMergeCommonValues() == RowMergeMode.ENABLED;
    }
}

