/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.table.transform;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.eclipse.set.utils.excel.ExcelWorkbookExtension;
import org.eclipse.set.utils.table.transform.TransformStyle;
import org.eclipse.set.utils.table.transform.XSLConstant;
import org.eclipse.xtext.xbase.lib.ArrayExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TransformTableBody {
    private Document doc;
    private Sheet sheet;

    public TransformTableBody(Document doc, Sheet sheet) {
        this.doc = doc;
        this.sheet = sheet;
    }

    public Set<Element> getDefaultStyles() {
        Functions.Function1<Set<Cell>, List<Element>> _function = new Functions.Function1<Set<Cell>, List<Element>>(){

            public List<Element> apply(Set<Cell> it) {
                Element _rowStyle = TransformTableBody.this.rowStyle((Cell[])Conversions.unwrapArray(it, Cell.class));
                Element _lastRowStyle = TransformTableBody.this.lastRowStyle((Cell[])Conversions.unwrapArray(it, Cell.class));
                return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Element[]{_rowStyle, _lastRowStyle}));
            }
        };
        return IterableExtensions.toSet((Iterable)IterableExtensions.flatMap(this.groupCellByStyle(new int[0]), (Functions.Function1)_function));
    }

    public Set<Element> getDefaultStyles(Set<Set<Cell>> styleGroup) {
        Functions.Function1<Set<Cell>, List<Element>> _function = new Functions.Function1<Set<Cell>, List<Element>>(){

            public List<Element> apply(Set<Cell> it) {
                Element _rowStyle = TransformTableBody.this.rowStyle((Cell[])Conversions.unwrapArray(it, Cell.class));
                Element _lastRowStyle = TransformTableBody.this.lastRowStyle((Cell[])Conversions.unwrapArray(it, Cell.class));
                return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Element[]{_rowStyle, _lastRowStyle}));
            }
        };
        return IterableExtensions.toSet((Iterable)IterableExtensions.flatMap(styleGroup, (Functions.Function1)_function));
    }

    private Set<Set<Cell>> groupCellByStyle(int[] pageBreakAt) {
        LinkedHashSet result = CollectionLiterals.newLinkedHashSet();
        int lastHeaderRowIndex = ExcelWorkbookExtension.getHeaderLastRowIndex((Sheet)this.sheet);
        int[] parentGroupLastIndex = this.getColumnWithWideBorderRight();
        Row firstDataRow = this.sheet.getRow(lastHeaderRowIndex + 2);
        if (firstDataRow == null) {
            throw new RuntimeException("Missing first data row. Is the printing area configured correctly?");
        }
        int i = 0;
        while (i <= ExcelWorkbookExtension.getHeaderLastColumnIndex((Sheet)this.sheet)) {
            final Optional cell = ExcelWorkbookExtension.getCellAt((Sheet)this.sheet, (int)firstDataRow.getRowNum(), (int)i);
            boolean _isPresent = cell.isPresent();
            if (_isPresent) {
                boolean _not;
                boolean _contains = ArrayExtensions.contains((int[])parentGroupLastIndex, (int)i);
                if (_contains) {
                    TransformStyle.setExcelCellBorderStyle(cell, XSLConstant.TableAttribute.BorderDirection.RIGHT, BorderStyle.MEDIUM);
                } else {
                    boolean _contains_1 = ArrayExtensions.contains((int[])pageBreakAt, (int)(i - 1));
                    if (_contains_1) {
                        TransformStyle.setExcelCellBorderStyle(cell, XSLConstant.TableAttribute.BorderDirection.LEFT, BorderStyle.MEDIUM);
                    } else {
                        boolean _contains_2 = ArrayExtensions.contains((int[])pageBreakAt, (int)i);
                        if (_contains_2) {
                            TransformStyle.setExcelCellBorderStyle(cell, XSLConstant.TableAttribute.BorderDirection.RIGHT, BorderStyle.MEDIUM);
                        }
                    }
                }
                boolean _isDefaultStyle = this.isDefaultStyle(((Cell)cell.get()).getCellStyle());
                boolean bl = _not = !_isDefaultStyle;
                if (_not) {
                    Functions.Function1<Set<Cell>, Boolean> _function = new Functions.Function1<Set<Cell>, Boolean>(){

                        public Boolean apply(Set<Cell> it) {
                            Functions.Function1<Cell, Boolean> _function = new Functions.Function1<Cell, Boolean>(){

                                public Boolean apply(Cell lastColumnCell) {
                                    return TransformTableBody.this.isEquals(((Cell)cell.get()).getCellStyle(), lastColumnCell.getCellStyle());
                                }
                            };
                            Cell _findFirst = (Cell)IterableExtensions.findFirst(it, (Functions.Function1)_function);
                            return _findFirst != null;
                        }
                    };
                    Set sameStyleGroup = (Set)IterableExtensions.findFirst((Iterable)result, (Functions.Function1)_function);
                    if (sameStyleGroup != null) {
                        sameStyleGroup.add((Cell)cell.get());
                    } else {
                        result.add(CollectionLiterals.newLinkedHashSet((Object[])new Cell[]{(Cell)cell.get()}));
                    }
                }
            }
            ++i;
        }
        return result;
    }

    private boolean isDefaultStyle(CellStyle cellStyle) {
        boolean isDefaultBorder;
        Functions.Function2<XSLConstant.TableAttribute.BorderDirection, String, Boolean> _function;
        HashMap<XSLConstant.TableAttribute.BorderDirection, String> borderStyle = TransformStyle.transformBorderStyle(cellStyle);
        int _size = MapExtensions.filter(borderStyle, (Functions.Function2)(_function = new Functions.Function2<XSLConstant.TableAttribute.BorderDirection, String, Boolean>(){

            public Boolean apply(XSLConstant.TableAttribute.BorderDirection direction, String style) {
                boolean _isEmpty = style.isEmpty();
                return !_isEmpty;
            }
        })).size();
        boolean bl = isDefaultBorder = _size == 0;
        return isDefaultBorder && cellStyle.getAlignment() == HorizontalAlignment.CENTER;
    }

    private boolean isEquals(CellStyle first, CellStyle second) {
        HorizontalAlignment _alignment_1;
        boolean _tripleNotEquals;
        HorizontalAlignment _alignment = first.getAlignment();
        boolean bl = _tripleNotEquals = _alignment != (_alignment_1 = second.getAlignment());
        if (_tripleNotEquals) {
            return false;
        }
        HashMap<XSLConstant.TableAttribute.BorderDirection, String> firstBorderStyle = TransformStyle.transformBorderStyle(first);
        HashMap<XSLConstant.TableAttribute.BorderDirection, String> secondBorderStyle = TransformStyle.transformBorderStyle(second);
        return firstBorderStyle.equals(secondBorderStyle);
    }

    private int[] getColumnWithWideBorderRight() {
        Row headerRow = this.sheet.getRow(1);
        ArrayList result = CollectionLiterals.newArrayList();
        int i = 1;
        while (i <= ExcelWorkbookExtension.getHeaderLastColumnIndex((Sheet)this.sheet)) {
            Cell cell = headerRow.getCell(i);
            BorderStyle _borderRight = cell.getCellStyle().getBorderRight();
            boolean _equals = Objects.equal((Object)_borderRight, (Object)BorderStyle.MEDIUM);
            if (_equals) {
                result.add(i);
            }
            if (i != 1 && Objects.equal((Object)cell.getCellStyle().getBorderLeft(), (Object)BorderStyle.MEDIUM)) {
                result.add(i - 1);
            }
            ++i;
        }
        return (int[])Conversions.unwrapArray((Object)IterableExtensions.toSet((Iterable)result), Integer.TYPE);
    }

    public Set<Element> pageBreakColumnCellStyle(final int[] pageBreakAt) {
        Set<Set<Cell>> groupStyles = this.groupCellByStyle(pageBreakAt);
        Functions.Function1<Set<Cell>, Iterable<Cell>> _function = new Functions.Function1<Set<Cell>, Iterable<Cell>>(){

            public Iterable<Cell> apply(Set<Cell> it) {
                Functions.Function1<Cell, Cell> _function = new Functions.Function1<Cell, Cell>(){

                    public Cell apply(Cell cell) {
                        boolean _contains = ArrayExtensions.contains((int[])pageBreakAt, (int)cell.getColumnIndex());
                        if (_contains) {
                            return cell;
                        }
                        return null;
                    }
                };
                return IterableExtensions.map(it, (Functions.Function1)_function);
            }
        };
        List pageBreakColumns = IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.flatMap(groupStyles, (Functions.Function1)_function)));
        Functions.Function1<Set<Cell>, Set<Cell>> _function_1 = new Functions.Function1<Set<Cell>, Set<Cell>>(){

            public Set<Cell> apply(Set<Cell> it) {
                Predicate<Cell> _function = new Predicate<Cell>(){

                    @Override
                    public boolean test(Cell cell) {
                        return ArrayExtensions.contains((int[])pageBreakAt, (int)cell.getColumnIndex());
                    }
                };
                it.removeIf(_function);
                return it;
            }
        };
        Functions.Function1<Set<Cell>, List<Element>> _function_2 = new Functions.Function1<Set<Cell>, List<Element>>(){

            public List<Element> apply(Set<Cell> it) {
                Element _rowStyle = TransformTableBody.this.rowStyle((Cell[])Conversions.unwrapArray(it, Cell.class));
                Element _lastRowStyle = TransformTableBody.this.lastRowStyle((Cell[])Conversions.unwrapArray(it, Cell.class));
                return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Element[]{_rowStyle, _lastRowStyle}));
            }
        };
        Set defaultStyle = IterableExtensions.toSet((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.map(groupStyles, (Functions.Function1)_function_1), (Functions.Function1)_function_2)));
        Element _rowStyle = this.rowStyle((Cell[])Conversions.unwrapArray((Object)pageBreakColumns, Cell.class));
        Element _lastRowStyle = this.lastRowStyle((Cell[])Conversions.unwrapArray((Object)pageBreakColumns, Cell.class));
        Set pageBreakColumnsStyle = IterableExtensions.toSet((Iterable)IterableExtensions.filterNull(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Element[]{_rowStyle, _lastRowStyle}))));
        Consumer<Element> _function_3 = new Consumer<Element>(){

            @Override
            public void accept(Element it) {
                Element numberCountColStyle = TransformTableBody.this.doc.createElement("fo:table-cell");
                numberCountColStyle.setAttribute(XSLConstant.TableAttribute.XSL_USE_ATTRIBUTE_SETS, "body-row-cell-style");
                numberCountColStyle.setAttribute(XSLConstant.TableAttribute.NUMBER_ROWS_SPANNED, String.format("{@%s}", XSLConstant.TableAttribute.NUMBER_ROWS_SPANNED));
                Element block = TransformTableBody.this.doc.createElement("fo:block");
                Element valueof = TransformTableBody.this.doc.createElement("xsl:value-of");
                valueof.setAttribute("select", "../@group-number");
                block.appendChild(valueof);
                numberCountColStyle.appendChild(block);
                Element applyTemplates = TransformTableBody.this.doc.createElement("xsl:apply-templates");
                applyTemplates.setAttribute("select", "../*[@column-number = '1']");
                it.appendChild(numberCountColStyle);
                it.appendChild(applyTemplates);
            }
        };
        pageBreakColumnsStyle.forEach(_function_3);
        pageBreakColumnsStyle.addAll(defaultStyle);
        return pageBreakColumnsStyle;
    }

    private Element rowStyle(Cell[] exclusionColumns) {
        boolean _isEmpty = ((List)Conversions.doWrapArray((Object)exclusionColumns)).isEmpty();
        if (_isEmpty) {
            return null;
        }
        Functions.Function1<Cell, String> _function = new Functions.Function1<Cell, String>(){

            public String apply(Cell it) {
                return Integer.toString(it.getColumnIndex());
            }
        };
        String expression = String.format("Cell[contains(' %s ', concat(' ', @column-number, ' '))]", String.join((CharSequence)" ", ListExtensions.map((List)((List)Conversions.doWrapArray((Object)exclusionColumns)), (Functions.Function1)_function)));
        Element template = TransformTableBody.createStyleTemplate(this.doc, expression);
        Element tableCell = TransformTableBody.createCellStyleElement(this.doc, "default-cell-style", exclusionColumns[0]);
        template.appendChild(tableCell);
        return template;
    }

    private Element lastRowStyle(Cell[] exclusionColumns) {
        boolean _isEmpty = ((List)Conversions.doWrapArray((Object)exclusionColumns)).isEmpty();
        if (_isEmpty) {
            return null;
        }
        Functions.Function1<Cell, String> _function = new Functions.Function1<Cell, String>(){

            public String apply(Cell it) {
                return Integer.toString(it.getColumnIndex());
            }
        };
        String expression = String.format("Cell[contains(' %s ', concat(' ', @column-number, ' ')) and ../@group-number = count(/Table/Rows/Row)]", String.join((CharSequence)" ", ListExtensions.map((List)((List)Conversions.doWrapArray((Object)exclusionColumns)), (Functions.Function1)_function)));
        Element template = TransformTableBody.createStyleTemplate(this.doc, expression);
        Element tableCell = TransformTableBody.createCellStyleElement(this.doc, "last-row-cell-style", exclusionColumns[0]);
        template.appendChild(tableCell);
        return template;
    }

    private static Element createStyleTemplate(Document doc, String expression) {
        Element template = doc.createElement("xsl:template");
        template.setAttribute("match", expression);
        return template;
    }

    private static Element createCellStyleElement(Document doc, String styleSets, Cell cell) {
        Element tableCell = doc.createElement("fo:table-cell");
        TransformStyle.transformCellStyle(tableCell, Optional.of(cell));
        tableCell.setAttribute(XSLConstant.TableAttribute.XSL_USE_ATTRIBUTE_SETS, styleSets);
        tableCell.setAttribute(XSLConstant.TableAttribute.NUMBER_ROWS_SPANNED, String.format("{@%s}", XSLConstant.TableAttribute.NUMBER_ROWS_SPANNED));
        tableCell.appendChild(doc.createElement("xsl:apply-templates"));
        return tableCell;
    }
}

