/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.pt1.sskp;

import com.google.common.collect.Streams;
import java.math.BigDecimal;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.stream.Stream;
import org.eclipse.set.basis.graph.TopPoint;
import org.eclipse.set.core.services.graph.TopologicalGraphService;
import org.eclipse.set.toolboxmodel.Bahnsteig.Bahnsteig_Kante;
import org.eclipse.set.toolboxmodel.Basisobjekte.Bereich_Objekt_Teilbereich_AttributeGroup;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.toolboxmodel.Basisobjekte.Seitliche_Lage_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Wirkrichtung_TypeClass;
import org.eclipse.set.toolboxmodel.PZB.PZB_Element;

public class SskpBahnsteigUtils {
    private static boolean isInBOTB(Bereich_Objekt_Teilbereich_AttributeGroup botb, Punkt_Objekt_TOP_Kante_AttributeGroup point) {
        double limitA = botb.getBegrenzungA().getWert().doubleValue();
        double limitB = botb.getBegrenzungB().getWert().doubleValue();
        double position = point.getAbstand().getWert().doubleValue();
        return limitA < position && position < limitB || limitB < position && position < limitA;
    }

    static BahnsteigDistance getBahnsteigDistances(TopologicalGraphService topGraphService, List<Bahnsteig_Kante> bahnsteigs, PZB_Element pzb) {
        Punkt_Objekt_TOP_Kante_AttributeGroup point = (Punkt_Objekt_TOP_Kante_AttributeGroup)pzb.getPunktObjektTOPKante().get(0);
        boolean isPZBAtBahnsteig = bahnsteigs.stream().anyMatch(bahnsteig -> bahnsteig.getBereichObjektTeilbereich().stream().filter(tb -> tb.getIDTOPKante().equals(point.getIDTOPKante())).anyMatch(tb -> SskpBahnsteigUtils.isInBOTB(tb, point)));
        if (isPZBAtBahnsteig) {
            return SskpBahnsteigUtils.getBahnsteigDistanceAtMagnet(topGraphService, bahnsteigs, pzb);
        }
        return SskpBahnsteigUtils.getBahnsteigDistancesNotAtMagnet(topGraphService, bahnsteigs, pzb);
    }

    private static boolean isPZBWirkrichtungTopDirection(PZB_Element pzb) {
        Seitliche_Lage_TypeClass seitlicheLage;
        Punkt_Objekt_TOP_Kante_AttributeGroup poto = (Punkt_Objekt_TOP_Kante_AttributeGroup)pzb.getPunktObjektTOPKante().get(0);
        Wirkrichtung_TypeClass wirkrichtung = poto.getWirkrichtung();
        if (wirkrichtung != null) {
            switch (wirkrichtung.getWert()) {
                case ENUM_WIRKRICHTUNG_GEGEN: {
                    return false;
                }
                case ENUM_WIRKRICHTUNG_IN: {
                    return true;
                }
            }
        }
        if ((seitlicheLage = poto.getSeitlicheLage()) != null) {
            switch (seitlicheLage.getWert()) {
                case ENUM_LINKS_RECHTS_LINKS: {
                    return false;
                }
                case ENUM_LINKS_RECHTS_RECHTS: {
                    return true;
                }
            }
        }
        throw new UnsupportedOperationException("PZB_Element has no wirkrichtung");
    }

    private static BahnsteigDistance getBahnsteigDistancesNotAtMagnet(TopologicalGraphService topGraphService, Iterable<Bahnsteig_Kante> bahnsteig, PZB_Element pzb) {
        boolean searchDirection = !SskpBahnsteigUtils.isPZBWirkrichtungTopDirection(pzb);
        TopPoint pzbPoint = new TopPoint((Punkt_Objekt)pzb);
        DoubleSummaryStatistics statistics = Streams.stream(bahnsteig).flatMap(bsk -> bsk.getBereichObjektTeilbereich().stream().flatMap(tb -> SskpBahnsteigUtils.toTopPoints(tb))).map(point -> topGraphService.findShortestDistanceInDirection(pzbPoint, point, searchDirection)).filter(Optional::isPresent).mapToDouble(c -> ((BigDecimal)c.get()).doubleValue()).collect(DoubleSummaryStatistics::new, DoubleSummaryStatistics::accept, DoubleSummaryStatistics::combine);
        if (statistics.getCount() == 0L) {
            return new BahnsteigDistance(OptionalDouble.empty(), OptionalDouble.empty());
        }
        return new BahnsteigDistance(statistics.getMax(), statistics.getMin());
    }

    private static BahnsteigDistance getBahnsteigDistanceAtMagnet(TopologicalGraphService topGraphService, Iterable<Bahnsteig_Kante> bahnsteig, PZB_Element pzb) {
        boolean isWirkrichtungTopDirection = SskpBahnsteigUtils.isPZBWirkrichtungTopDirection(pzb);
        TopPoint pzbPoint = new TopPoint((Punkt_Objekt)pzb);
        OptionalDouble start = Streams.stream(bahnsteig).flatMap(bsk -> bsk.getBereichObjektTeilbereich().stream().flatMap(tb -> SskpBahnsteigUtils.toTopPoints(tb))).map(point -> topGraphService.findShortestDistanceInDirection(pzbPoint, point, !isWirkrichtungTopDirection)).filter(Optional::isPresent).mapToDouble(c -> ((BigDecimal)c.get()).doubleValue()).max();
        OptionalDouble end = Streams.stream(bahnsteig).flatMap(bsk -> bsk.getBereichObjektTeilbereich().stream().flatMap(tb -> SskpBahnsteigUtils.toTopPoints(tb))).map(point -> topGraphService.findShortestDistanceInDirection(pzbPoint, point, isWirkrichtungTopDirection)).filter(Optional::isPresent).mapToDouble(c -> ((BigDecimal)c.get()).doubleValue()).map(c -> -c).min();
        return new BahnsteigDistance(start, end);
    }

    private static Stream<TopPoint> toTopPoints(Bereich_Objekt_Teilbereich_AttributeGroup tb) {
        return Stream.of(new TopPoint(tb.getIDTOPKante(), tb.getBegrenzungA().getWert()), new TopPoint(tb.getIDTOPKante(), tb.getBegrenzungB().getWert()));
    }

    public static class BahnsteigDistance {
        private final OptionalDouble distanceEnd;
        private final OptionalDouble distanceStart;

        public BahnsteigDistance(OptionalDouble min, OptionalDouble max) {
            this.distanceStart = min;
            this.distanceEnd = max;
        }

        public BahnsteigDistance(double start, double end) {
            this.distanceStart = OptionalDouble.of(start);
            this.distanceEnd = OptionalDouble.of(end);
        }

        public OptionalDouble getDistanceStart() {
            return this.distanceStart;
        }

        public OptionalDouble getDistanceEnd() {
            return this.distanceEnd;
        }
    }
}

