/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.extensions;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.eclipse.set.basis.exceptions.NotReadable;
import org.eclipse.set.basis.exceptions.NotWritable;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class PathExtensions {
    public static final List<String> IMAGE_FILE_EXTENSIONS = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"jpg", "gif", "png"}));
    public static final List<String> CSV_FILE_EXTENSIONS = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"csv"}));
    public static final List<String> DOKUMENT_FILE_EXTENSIONS = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"pdf"}));
    public static final List<String> EXCEL_FILE_EXTENSION = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"xlsx"}));
    public static final List<String> ALL_FILE_EXTENSION = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"*"}));

    public static String toString(Path path, String separator) {
        StringConcatenation _builder = new StringConcatenation();
        String _root = PathExtensions.root(path, separator);
        _builder.append(_root);
        boolean _hasElements = false;
        for (Path segment : path) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)separator, "");
            }
            String _string = segment.toString();
            _builder.append(_string);
        }
        return _builder.toString();
    }

    public static String rootWithoutSeparator(Path path) {
        Path root = path.getRoot();
        if (root == null) {
            return null;
        }
        String rootString = root.toString();
        int _length = rootString.length();
        int _minus = _length - 1;
        return rootString.substring(0, _minus);
    }

    public static String root(Path path, String separator) {
        String r = PathExtensions.rootWithoutSeparator(path);
        if (r == null) {
            return "";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(r);
        _builder.append(separator);
        return _builder.toString();
    }

    public static String getBaseFileName(Path path) {
        return path.getFileName().toString().replaceFirst("\\.[^.]*$", "");
    }

    public static String getExtension(Path path) {
        boolean _greaterThan;
        String[] parts = path.getFileName().toString().split("\\.");
        int _size = ((List)Conversions.doWrapArray((Object)parts)).size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            return ((String)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)parts)))).toLowerCase();
        }
        return "";
    }

    public static Path replaceExtension(Path path, String fileExtension) {
        String _elvis = null;
        Path _parent = path.getParent();
        String _string = null;
        if (_parent != null) {
            _string = _parent.toString();
        }
        _elvis = _string != null ? _string : "";
        StringConcatenation _builder = new StringConcatenation();
        String _baseFileName = PathExtensions.getBaseFileName(path);
        _builder.append(_baseFileName);
        _builder.append(".");
        _builder.append(fileExtension);
        return Paths.get(_elvis, _builder.toString());
    }

    public static Path toLowerCaseExtension(Path path) {
        String ex = PathExtensions.getExtension(path);
        return PathExtensions.replaceExtension(path, ex.toLowerCase());
    }

    public static void checkCanRead(Path path) throws NotReadable {
        boolean _not;
        File file = path.toFile();
        boolean _canRead = file.canRead();
        boolean bl = _not = !_canRead;
        if (_not) {
            throw new NotReadable(file);
        }
    }

    public static void checkCanWrite(Path path) throws NotWritable {
        File file = path.toFile();
        if (file.exists() && !file.canWrite()) {
            throw new NotWritable(path);
        }
    }
}

