/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.graph;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.eclipse.set.basis.graph.TopPoint;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante;

public class TopPath {
    private final List<TOP_Kante> edges;
    private final BigDecimal length;
    private final BigDecimal offset;

    public TopPath(List<TOP_Kante> edges, BigDecimal length, BigDecimal offset) {
        this.edges = edges;
        this.length = length;
        this.offset = offset;
    }

    public List<TOP_Kante> edges() {
        return this.edges;
    }

    public BigDecimal length() {
        return this.length;
    }

    public BigDecimal offset() {
        return this.offset;
    }

    public Optional<BigDecimal> getDistance(TopPoint point) {
        BigDecimal pathOffset = this.offset.negate();
        TOP_Kante previousEdge = null;
        for (TOP_Kante edge : this.edges()) {
            BigDecimal edgeLength = edge.getTOPKanteAllg().getTOPLaenge().getWert();
            if (point.edge().equals(edge)) {
                if (previousEdge == null || previousEdge.getIDTOPKnotenB() == edge.getIDTOPKnotenA() || previousEdge.getIDTOPKnotenA() == edge.getIDTOPKnotenA()) {
                    BigDecimal pointDistance = pathOffset.add(point.distance());
                    if (pointDistance.compareTo(BigDecimal.ZERO) < 0 || pointDistance.compareTo(this.length) > 0) {
                        return Optional.empty();
                    }
                    return Optional.of(pointDistance);
                }
                BigDecimal pointDistance = pathOffset.add(edgeLength).subtract(point.distance());
                if (pointDistance.compareTo(BigDecimal.ZERO) < 0 || pointDistance.compareTo(this.length) > 0) {
                    return Optional.empty();
                }
                return Optional.of(pointDistance);
            }
            previousEdge = edge;
            pathOffset = pathOffset.add(edgeLength);
        }
        return Optional.empty();
    }
}

