/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.set.basis.integration.DiffLabelProvider;
import org.eclipse.set.basis.integration.Matcher;
import org.eclipse.set.toolboxmodel.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Ur_Objekt;
import org.eclipse.set.utils.EClassExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public abstract class AbstractMatcher
implements Matcher {
    private final DiffLabelProvider labelProvider;

    public AbstractMatcher(DiffLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public boolean isDifferent(EObject first, EObject second) {
        boolean _isEmpty = this.getDifferences(first, second).isEmpty();
        return !_isEmpty;
    }

    public List<List<String>> getNonEmptyAttributes(final EObject first, final EObject second) {
        boolean _tripleNotEquals;
        Functions.Function1<EObject, EClass> _function = new Functions.Function1<EObject, EClass>(){

            public EClass apply(EObject it) {
                return it.eClass();
            }
        };
        Set types = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filterNull(Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new EObject[]{first, second}))), (Functions.Function1)_function));
        int _size = types.size();
        boolean bl = _tripleNotEquals = _size != 1;
        if (_tripleNotEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("types=");
            _builder.append((Object)types);
            throw new IllegalArgumentException(_builder.toString());
        }
        EClass type = (EClass)IterableExtensions.head((Iterable)types);
        Functions.Function1<List<String>, Boolean> _function_1 = new Functions.Function1<List<String>, Boolean>(){

            public Boolean apply(List<String> it) {
                return AbstractMatcher.this.hasNonEmptyValues(first, second, it);
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter(EClassExtensions.getAttributePaths(type, false), (Functions.Function1)_function_1));
    }

    public List<List<String>> getDifferences(final EObject first, final EObject second) {
        boolean _tripleNotEquals;
        Functions.Function1<EObject, EClass> _function = new Functions.Function1<EObject, EClass>(){

            public EClass apply(EObject it) {
                return it.eClass();
            }
        };
        Set types = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filterNull(Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new EObject[]{first, second}))), (Functions.Function1)_function));
        int _size = types.size();
        boolean bl = _tripleNotEquals = _size != 1;
        if (_tripleNotEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("types=");
            _builder.append((Object)types);
            throw new IllegalArgumentException(_builder.toString());
        }
        EClass type = (EClass)IterableExtensions.head((Iterable)types);
        Functions.Function1<List<String>, Boolean> _function_1 = new Functions.Function1<List<String>, Boolean>(){

            public Boolean apply(List<String> it) {
                boolean _hasEqualValues = AbstractMatcher.this.hasEqualValues(first, second, it);
                return !_hasEqualValues;
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter(EClassExtensions.getAttributePaths(type, false), (Functions.Function1)_function_1));
    }

    private boolean hasEqualValues(EObject first, EObject second, List<String> path) {
        boolean _greaterThan;
        Object firstValue = this.labelProvider.getAttributeValue(first, path);
        Object secondValue = this.labelProvider.getAttributeValue(second, path);
        if (firstValue instanceof Ur_Objekt && secondValue == null) {
            Identitaet_TypeClass _identitaet = ((Ur_Objekt)firstValue).getIdentitaet();
            String _wert = null;
            if (_identitaet != null) {
                _wert = _identitaet.getWert();
            }
            String _eObjectGuidFromPath = this.getEObjectGuidFromPath(second, path);
            return Objects.equal((Object)_wert, (Object)_eObjectGuidFromPath);
        }
        if (secondValue instanceof Ur_Objekt && firstValue == null) {
            Identitaet_TypeClass _identitaet_1 = ((Ur_Objekt)secondValue).getIdentitaet();
            String _wert_1 = null;
            if (_identitaet_1 != null) {
                _wert_1 = _identitaet_1.getWert();
            }
            String _eObjectGuidFromPath_1 = this.getEObjectGuidFromPath(first, path);
            return Objects.equal((Object)_wert_1, (Object)_eObjectGuidFromPath_1);
        }
        if (firstValue == null || secondValue == null) {
            return firstValue == secondValue;
        }
        Functions.Function1 _function = new Functions.Function1<Object, Class<?>>(){

            public Class<?> apply(Object it) {
                return it.getClass();
            }
        };
        Set types = IterableExtensions.toSet((Iterable)IterableExtensions.map(Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Object[]{firstValue, secondValue})), (Functions.Function1)_function));
        int _size = types.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            return false;
        }
        Class type = (Class)IterableExtensions.head((Iterable)types);
        boolean _isAssignableFrom = List.class.isAssignableFrom(type);
        if (_isAssignableFrom) {
            boolean result = this.equal((List)firstValue, (List)secondValue);
            return result;
        }
        boolean _isArray = type.isArray();
        if (_isArray) {
            return this.equalArrays(firstValue, secondValue);
        }
        if (firstValue instanceof Ur_Objekt && secondValue instanceof Ur_Objekt) {
            Identitaet_TypeClass _identitaet_2 = ((Ur_Objekt)firstValue).getIdentitaet();
            String _wert_2 = null;
            if (_identitaet_2 != null) {
                _wert_2 = _identitaet_2.getWert();
            }
            Identitaet_TypeClass _identitaet_3 = ((Ur_Objekt)secondValue).getIdentitaet();
            String _wert_3 = null;
            if (_identitaet_3 != null) {
                _wert_3 = _identitaet_3.getWert();
            }
            return Objects.equal((Object)_wert_2, (Object)_wert_3);
        }
        return firstValue.equals(secondValue);
    }

    private boolean hasNonEmptyValues(EObject first, EObject second, List<String> path) {
        boolean _greaterThan;
        Object firstValue = this.labelProvider.getAttributeValue(first, path);
        Object secondValue = this.labelProvider.getAttributeValue(second, path);
        if (firstValue == null && secondValue == null) {
            return false;
        }
        Object aNonNullValue = IterableExtensions.head((Iterable)IterableExtensions.filterNull(Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Object[]{firstValue, secondValue}))));
        Functions.Function1 _function = new Functions.Function1<Object, Class<?>>(){

            public Class<?> apply(Object it) {
                return it.getClass();
            }
        };
        Set types = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filterNull(Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Object[]{firstValue, secondValue}))), (Functions.Function1)_function));
        int _size = types.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("types=");
            _builder.append((Object)types);
            throw new IllegalArgumentException(_builder.toString());
        }
        Class type = (Class)IterableExtensions.head((Iterable)types);
        if (aNonNullValue instanceof List || type.isArray()) {
            return this.size(firstValue) > 0 || this.size(secondValue) > 0;
        }
        if (aNonNullValue instanceof String) {
            return !Strings.isNullOrEmpty((String)((String)firstValue)) || !Strings.isNullOrEmpty((String)((String)firstValue));
        }
        return true;
    }

    public int size(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof List) {
            return ((List)object).size();
        }
        if (object instanceof byte[]) {
            return ((byte[])object).length;
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Unsupported array type ");
        Class<?> _class = object.getClass();
        _builder.append(_class);
        throw new IllegalArgumentException(_builder.toString());
    }

    private boolean equalArrays(Object first, Object second) {
        if (first instanceof byte[]) {
            if (second instanceof byte[]) {
                return Arrays.equals((byte[])first, (byte[])second);
            }
            return false;
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Unsupported array type ");
        Class<?> _class = first.getClass();
        _builder.append(_class);
        throw new IllegalArgumentException(_builder.toString());
    }

    private boolean _equal(List<?> firstValue, List<?> secondValue) {
        return this.equalList(firstValue, secondValue, null, null, null);
    }

    private boolean equalList(List<?> firstValue, List<?> secondValue, EObject firstContainer, EObject secondContainer, EReference reference) {
        int _size_1;
        boolean _tripleNotEquals;
        int _size = firstValue.size();
        boolean bl = _tripleNotEquals = _size != (_size_1 = secondValue.size());
        if (_tripleNotEquals) {
            return false;
        }
        int size = firstValue.size();
        int i = 0;
        while (i < size) {
            Object firstObject = firstValue.get(i);
            Object secondObject = secondValue.get(i);
            if (!(reference == null || reference.isContainment() || firstObject != null && !(firstObject instanceof Ur_Objekt) || secondObject != null && !(secondObject instanceof Ur_Objekt))) {
                String _eObjectGuid_1;
                boolean _notEquals;
                String _eObjectGuid = this.getEObjectGuid(firstObject, firstContainer, reference);
                boolean bl2 = _notEquals = !Objects.equal((Object)_eObjectGuid, (Object)(_eObjectGuid_1 = this.getEObjectGuid(secondObject, secondContainer, reference)));
                if (_notEquals) {
                    return false;
                }
            } else if (firstObject instanceof EObject && secondObject instanceof EObject) {
                boolean _not;
                boolean _equal = this.equal((EObject)firstObject, (EObject)secondObject);
                boolean bl3 = _not = !_equal;
                if (_not) {
                    return false;
                }
            } else {
                boolean _not_1;
                boolean _equals = firstObject.equals(secondObject);
                boolean bl4 = _not_1 = !_equals;
                if (_not_1) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean _equal(EObject firstObject, EObject secondObject) {
        EClass _eClass_1;
        boolean _tripleNotEquals;
        if (firstObject == secondObject) {
            return true;
        }
        EClass _eClass = firstObject.eClass();
        boolean bl = _tripleNotEquals = _eClass != (_eClass_1 = secondObject.eClass());
        if (_tripleNotEquals) {
            return false;
        }
        Functions.Function1<EStructuralFeature, Boolean> _function = new Functions.Function1<EStructuralFeature, Boolean>(){

            public Boolean apply(EStructuralFeature it) {
                boolean _isDerived = it.isDerived();
                return !_isDerived;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)firstObject.eClass().getEStructuralFeatures(), (Functions.Function1)_function);
        for (EStructuralFeature feature : _filter) {
            boolean _not_1;
            boolean _eIsSet_1;
            boolean _eIsSet = firstObject.eIsSet(feature);
            boolean _notEquals = _eIsSet ^ (_eIsSet_1 = secondObject.eIsSet(feature));
            if (_notEquals) {
                return false;
            }
            if (feature instanceof EReference) {
                boolean _not;
                boolean _equalReference = this.equalReference(firstObject, secondObject, (EReference)feature);
                boolean bl2 = _not = !_equalReference;
                if (!_not) continue;
                return false;
            }
            if (!(feature instanceof EAttribute)) continue;
            boolean _equalAttribute = this.equalAttribute(firstObject, secondObject, (EAttribute)feature);
            boolean bl3 = _not_1 = !_equalAttribute;
            if (!_not_1) continue;
            return false;
        }
        return true;
    }

    private boolean equalReference(EObject firstObject, EObject secondObject, EReference reference) {
        Object firstValue = firstObject.eGet((EStructuralFeature)reference);
        Object secondValue = secondObject.eGet((EStructuralFeature)reference);
        if (!(reference.isContainment() || firstObject != null && !(firstValue instanceof Ur_Objekt) || secondObject != null && !(secondValue instanceof Ur_Objekt))) {
            String _eObjectGuid = this.getEObjectGuid(firstValue, firstObject, reference);
            String _eObjectGuid_1 = this.getEObjectGuid(secondValue, secondObject, reference);
            return Objects.equal((Object)_eObjectGuid, (Object)_eObjectGuid_1);
        }
        if (reference.isMany() && firstValue != null && secondValue != null) {
            return this.equalList((List<?>)((EList)firstValue), (List<?>)((EList)secondValue), firstObject, secondObject, reference);
        }
        if (firstValue == null) {
            return secondValue == null;
        }
        if (secondValue == null) {
            return firstValue == null;
        }
        return this.equal(firstValue, secondValue);
    }

    private String getEObjectGuid(Object value, EObject container, EReference reference) {
        if (value instanceof Ur_Objekt) {
            Identitaet_TypeClass _identitaet = ((Ur_Objekt)value).getIdentitaet();
            String _wert = null;
            if (_identitaet != null) {
                _wert = _identitaet.getWert();
            }
            return _wert;
        }
        if (value != null) {
            return null;
        }
        return null;
    }

    private String getEObjectGuidFromPath(EObject container, List<String> path) {
        EStructuralFeature feature = this.getFeatureFromPath(container, path);
        return this.getEObjectGuid(null, container, (EReference)feature);
    }

    private EStructuralFeature getFeatureFromPath(EObject container, Iterable<String> path) {
        Iterable tail = IterableExtensions.tail(path);
        EStructuralFeature feature = container.eClass().getEStructuralFeature((String)IterableExtensions.head(path));
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)tail);
        if (_isEmpty) {
            return feature;
        }
        Object value = container.eGet(feature);
        return this.getFeatureFromPath((EObject)value, tail);
    }

    private boolean equalAttribute(EObject firstObject, EObject secondObject, EAttribute attribute) {
        Object _eGet = firstObject.eGet((EStructuralFeature)attribute);
        Object _eGet_1 = secondObject.eGet((EStructuralFeature)attribute);
        return Objects.equal((Object)_eGet, (Object)_eGet_1);
    }

    private boolean equal(Object firstValue, Object secondValue) {
        if (firstValue instanceof List && secondValue instanceof List) {
            return this._equal((List)firstValue, (List)secondValue);
        }
        if (firstValue instanceof EObject && secondValue instanceof EObject) {
            return this._equal((EObject)firstValue, (EObject)secondValue);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(firstValue, secondValue).toString());
    }
}

