/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.emfforms;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.set.utils.VDomainModelReferenceExtensions;
import org.eclipse.set.utils.emfforms.ToolboxRenderer;
import org.eclipse.set.utils.emfforms.TypedSetting;

public class Renderers {
    public static Optional<EClassifier> getFeaturePathDomainType(VElement vElement, boolean noLists) {
        EStructuralFeature domainModelEFeature;
        if (!VControl.class.isInstance(vElement)) {
            throw new IllegalArgumentException(String.format("%s is no VControl", vElement.toString()));
        }
        VControl control = (VControl)vElement;
        VDomainModelReference domainModelReference = control.getDomainModelReference();
        if (!(domainModelReference instanceof VFeaturePathDomainModelReference)) {
            throw new IllegalArgumentException(String.format("%s has no VFeaturePathDomainModelReference", vElement.toString()));
        }
        VFeaturePathDomainModelReference featurePathDomainModelReference = (VFeaturePathDomainModelReference)domainModelReference;
        EStructuralFeature domainModelEReference = domainModelEFeature = featurePathDomainModelReference.getDomainModelEFeature();
        if (domainModelEFeature == null) {
            return Optional.empty();
        }
        if (noLists && domainModelEReference.getUpperBound() != 1) {
            return Optional.empty();
        }
        return Optional.of(domainModelEFeature.getEType());
    }

    public static <S> TypedSetting<S> getTypedSetting(Class<S> domainType, VElement vElement, ViewModelContext viewModelContext) {
        if (!VControl.class.isInstance(vElement)) {
            return null;
        }
        VControl control = (VControl)vElement;
        VDomainModelReference domainModelReference = control.getDomainModelReference();
        if (!(domainModelReference instanceof VFeaturePathDomainModelReference)) {
            return null;
        }
        VFeaturePathDomainModelReference featurePathDomainModelReference = (VFeaturePathDomainModelReference)domainModelReference;
        EStructuralFeature domainModelEFeature = featurePathDomainModelReference.getDomainModelEFeature();
        if (domainModelEFeature == null) {
            return null;
        }
        if (!domainType.isAssignableFrom(domainModelEFeature.getEType().getInstanceClass())) {
            return null;
        }
        EObject domainModel = viewModelContext.getDomainModel();
        EObject featureValueContainingTheDomainElement = VDomainModelReferenceExtensions.resolve((VDomainModelReference)featurePathDomainModelReference, domainModel);
        S domainElement = domainType.cast(featureValueContainingTheDomainElement.eGet(domainModelEFeature));
        return new TypedSetting<S>(featureValueContainingTheDomainElement, domainModelEFeature, Optional.ofNullable(domainElement));
    }

    public static VElement getVElement(String vElementName, ViewModelContext viewModelContext) {
        VElement viewModel = viewModelContext.getViewModel();
        LinkedList eAllContents = new LinkedList();
        viewModel.eAllContents().forEachRemaining(e -> eAllContents.add(e));
        List matchingElements = eAllContents.stream().filter(e -> Renderers.isVElementWithName(e, vElementName)).collect(Collectors.toList());
        if (matchingElements.size() == 1) {
            return (VElement)matchingElements.get(0);
        }
        throw new IllegalArgumentException(vElementName);
    }

    public static boolean isDisposed(ToolboxRenderer renderer) {
        try {
            renderer.checkToolboxRenderer();
        }
        catch (IllegalStateException e) {
            return true;
        }
        return false;
    }

    private static boolean isVElementWithName(EObject e, String vElementName) {
        if (!(e instanceof VElement)) {
            return false;
        }
        VElement vElement = (VElement)e;
        return vElementName.equals(vElement.getName());
    }
}

