/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.graph;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.set.basis.graph.TopPoint;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Knoten;
import org.jgrapht.Graph;
import org.jgrapht.GraphType;
import org.jgrapht.graph.AbstractGraph;
import org.jgrapht.graph.AsGraphUnion;
import org.jgrapht.graph.AsSubgraph;
import org.jgrapht.graph.WeightedPseudograph;

public class AsSplitTopGraph
extends AbstractGraph<Node, Edge> {
    private final Graph<Node, Edge> baseGraph;
    private final Graph<Node, Edge> pointEdgeGraph;
    private final Graph<Node, Edge> unionGraph;

    public AsSplitTopGraph(Graph<Node, Edge> base) {
        this.baseGraph = new AsSubgraph(base);
        this.pointEdgeGraph = new WeightedPseudograph(Edge.class);
        this.unionGraph = new AsGraphUnion(this.baseGraph, this.pointEdgeGraph);
    }

    public Node splitGraphAt(TopPoint at) {
        return this.splitGraphAt(at, null);
    }

    public Node splitGraphAt(TopPoint at, Boolean inTopDirection) {
        TOP_Kante edge = at.edge();
        List<Edge> pointEdgeList = this.pointEdgeGraph.edgeSet().stream().filter(c -> c.edge == edge).filter(c -> c.offset.compareTo(at.distance()) <= 0).filter(c -> c.offset.add(c.length).compareTo(at.distance()) >= 0).toList();
        Optional pointGraphEdge = pointEdgeList.stream().max((e1, e2) -> e1.offset.compareTo(e2.offset));
        if (pointGraphEdge.isPresent()) {
            return this.splitGraphAt(this.pointEdgeGraph, at, (Edge)pointGraphEdge.get(), inTopDirection);
        }
        Optional<Edge> graphEdge = this.baseGraph.edgeSet().stream().filter(c -> c.edge == edge).findFirst();
        if (graphEdge.isPresent()) {
            return this.splitGraphAt(this.baseGraph, at, graphEdge.get(), inTopDirection);
        }
        throw new IllegalArgumentException("Cannot split graph on a point outside the graph");
    }

    private Node addPointGraphNode(TopPoint point) {
        Node node = new Node(point);
        this.pointEdgeGraph.addVertex((Object)node);
        return node;
    }

    private void addPointGraphEdge(Node from, Node to, Edge edge) {
        this.pointEdgeGraph.addEdge((Object)from, (Object)to, (Object)edge);
        this.pointEdgeGraph.setEdgeWeight((Object)edge, edge.getWeight().doubleValue());
    }

    private Node splitGraphAt(Graph<Node, Edge> sourceGraph, TopPoint point, Edge existingEdge, Boolean inTopDirection) {
        Node topDirNode = this.addPointGraphNode(point);
        Node againstTopDirNode = this.addPointGraphNode(point);
        Node sourceVertex = (Node)sourceGraph.getEdgeSource((Object)existingEdge);
        Node targetVertex = (Node)sourceGraph.getEdgeTarget((Object)existingEdge);
        this.pointEdgeGraph.addVertex((Object)sourceVertex);
        this.pointEdgeGraph.addVertex((Object)targetVertex);
        Edge edge = new Edge(point, existingEdge, true);
        this.addPointGraphEdge(sourceVertex, topDirNode, edge);
        this.addPointGraphEdge(againstTopDirNode, targetVertex, new Edge(point, existingEdge, false));
        if (inTopDirection == null) {
            this.addPointGraphEdge(topDirNode, againstTopDirNode, new Edge(point.edge(), edge.offset, BigDecimal.ZERO));
        }
        sourceGraph.removeEdge((Object)existingEdge);
        if (inTopDirection == null || inTopDirection.equals(Boolean.TRUE)) {
            return topDirNode;
        }
        return againstTopDirNode;
    }

    public Set<Edge> getAllEdges(Node sourceVertex, Node targetVertex) {
        return this.unionGraph.getAllEdges((Object)sourceVertex, (Object)targetVertex);
    }

    public Edge getEdge(Node sourceVertex, Node targetVertex) {
        return (Edge)this.unionGraph.getEdge((Object)sourceVertex, (Object)targetVertex);
    }

    public Supplier<Node> getVertexSupplier() {
        return this.unionGraph.getVertexSupplier();
    }

    public Supplier<Edge> getEdgeSupplier() {
        return this.unionGraph.getEdgeSupplier();
    }

    public Edge addEdge(Node sourceVertex, Node targetVertex) {
        return (Edge)this.unionGraph.addEdge((Object)sourceVertex, (Object)targetVertex);
    }

    public boolean addEdge(Node sourceVertex, Node targetVertex, Edge e) {
        return this.unionGraph.addEdge((Object)sourceVertex, (Object)targetVertex, (Object)e);
    }

    public Node addVertex() {
        return (Node)this.unionGraph.addVertex();
    }

    public boolean addVertex(Node v) {
        return this.unionGraph.addVertex((Object)v);
    }

    public boolean containsEdge(Edge e) {
        return this.unionGraph.containsEdge((Object)e);
    }

    public boolean containsVertex(Node v) {
        return this.unionGraph.containsVertex((Object)v);
    }

    public Set<Edge> edgeSet() {
        return this.unionGraph.edgeSet();
    }

    public int degreeOf(Node vertex) {
        return this.unionGraph.degreeOf((Object)vertex);
    }

    public Set<Edge> edgesOf(Node vertex) {
        return this.unionGraph.edgesOf((Object)vertex);
    }

    public int inDegreeOf(Node vertex) {
        return this.unionGraph.inDegreeOf((Object)vertex);
    }

    public Set<Edge> incomingEdgesOf(Node vertex) {
        return this.unionGraph.incomingEdgesOf((Object)vertex);
    }

    public int outDegreeOf(Node vertex) {
        return this.unionGraph.outDegreeOf((Object)vertex);
    }

    public Set<Edge> outgoingEdgesOf(Node vertex) {
        return this.unionGraph.outgoingEdgesOf((Object)vertex);
    }

    public Edge removeEdge(Node sourceVertex, Node targetVertex) {
        return (Edge)this.unionGraph.removeEdge((Object)sourceVertex, (Object)targetVertex);
    }

    public boolean removeEdge(Edge e) {
        return this.unionGraph.removeEdge((Object)e);
    }

    public boolean removeVertex(Node v) {
        return this.unionGraph.removeVertex((Object)v);
    }

    public Set<Node> vertexSet() {
        return this.unionGraph.vertexSet();
    }

    public Node getEdgeSource(Edge e) {
        return (Node)this.unionGraph.getEdgeSource((Object)e);
    }

    public Node getEdgeTarget(Edge e) {
        return (Node)this.unionGraph.getEdgeTarget((Object)e);
    }

    public GraphType getType() {
        return this.unionGraph.getType();
    }

    public double getEdgeWeight(Edge e) {
        return this.unionGraph.getEdgeWeight((Object)e);
    }

    public void setEdgeWeight(Edge e, double weight) {
        this.unionGraph.setEdgeWeight((Object)e, weight);
    }

    public record Edge(TOP_Kante edge, BigDecimal offset, BigDecimal length) {
        public Edge(TOP_Kante baseEdge) {
            this(baseEdge, null, null);
        }

        private Edge(TopPoint point, Edge oldEdge, boolean inTopDirection) {
            this(point.edge(), Edge.calculateOffset(point, oldEdge, inTopDirection), Edge.calculateLength(point, oldEdge, inTopDirection));
        }

        private static BigDecimal calculateOffset(TopPoint point, Edge oldEdge, boolean inTopDirection) {
            if (inTopDirection) {
                if (oldEdge.offset == null) {
                    return BigDecimal.ZERO;
                }
                return oldEdge.offset;
            }
            return point.distance();
        }

        private static BigDecimal calculateLength(TopPoint point, Edge oldEdge, boolean inTopDirection) {
            if (inTopDirection) {
                if (oldEdge.offset == null) {
                    return point.distance();
                }
                return point.distance().subtract(oldEdge.offset);
            }
            if (oldEdge.length == null) {
                return point.edge().getTOPKanteAllg().getTOPLaenge().getWert().subtract(point.distance());
            }
            return oldEdge.length.subtract(point.distance()).add(oldEdge.offset);
        }

        public BigDecimal getWeight() {
            if (this.length != null) {
                return this.length;
            }
            return this.edge.getTOPKanteAllg().getTOPLaenge().getWert();
        }
    }

    public record Node(TOP_Knoten node, TopPoint point) {
        public Node(TOP_Knoten baseNode) {
            this(baseNode, null);
        }

        private Node(TopPoint point) {
            this(null, point);
        }
    }
}

