/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.internal;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.set.basis.attachments.Attachment;
import org.eclipse.set.basis.attachments.FileKind;
import org.eclipse.swt.widgets.Composite;

public class FileKindEditingSupport
extends EditingSupport {
    private final String[] fileKindItems;
    private final List<FileKind> fileKinds;
    private final TableViewer viewer;

    public FileKindEditingSupport(TableViewer viewer, List<FileKind> fileKinds) {
        super((ColumnViewer)viewer);
        this.viewer = viewer;
        this.fileKindItems = new String[fileKinds.size()];
        this.fileKinds = fileKinds;
        int i = 0;
        while (i < this.fileKindItems.length) {
            this.fileKindItems[i] = fileKinds.get(i).getTranslation();
            ++i;
        }
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected CellEditor getCellEditor(Object element) {
        return new ComboBoxCellEditor((Composite)this.viewer.getTable(), this.fileKindItems, 8);
    }

    protected Object getValue(Object element) {
        Attachment attachment = (Attachment)element;
        FileKind fileKind = attachment.getFileKind();
        int i = 0;
        while (i < this.fileKindItems.length) {
            if (this.fileKindItems[i].equals(fileKind.getTranslation())) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException(String.valueOf(fileKind) + " not in " + String.valueOf(Arrays.asList(this.fileKindItems)));
    }

    protected void setValue(Object element, Object value) {
        Attachment attachment = (Attachment)element;
        attachment.setFileKind(this.fileKinds.get((Integer)value));
    }
}

