/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan;

import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.ENUMWKrArt;

public class TrackSwitchMetadata {
    private static final int COLUMN_TYPE = 5;
    private static final int COLUMN_DESIGN = 6;
    private static final int COLUMN_LENGTH_MAIN = 8;
    private static final int COLUMN_LENGTH_SIDE = 9;
    private static final int COLUMN_CROSSING_RIGHT_MAIN = 13;
    private static final int COLUMN_CROSSING_RIGHT_SIDE = 14;
    private static final int COLUMN_CROSSING_LEFT_MAIN = 18;
    private static final int COLUMN_CROSSING_LEFT_SIDE = 19;
    private static final int COLUMN_CROSSING_TRIANGLE_RIGHT_MAIN = 15;
    private static final int COLUMN_CROSSING_TRIANGLE_RIGHT_SIDE = 16;
    private static final int COLUMN_CROSSING_TRIANGLE_LEFT_MAIN = 20;
    private static final int COLUMN_CROSSING_TRIANGLE_LEFT_SIDE = 21;
    public String design;
    public ENUMWKrArt type;
    public LegLength trackSwitchLength;
    public CrossingSide leftCrossing;
    public CrossingSide rightCrossing;

    private TrackSwitchMetadata() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TrackSwitchMetadata fromCSVLine(String line) {
        TrackSwitchMetadata entry = new TrackSwitchMetadata();
        String[] columns = line.split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)");
        if (columns.length < 10) {
            return null;
        }
        try {
            entry.design = columns[6];
            entry.type = ENUMWKrArt.get((String)columns[5]);
            if (entry.type == null) {
                return null;
            }
            switch (entry.type) {
                case ENUMW_KR_ART_DKW: 
                case ENUMW_KR_ART_EKW: {
                    entry.rightCrossing = new CrossingSide(Double.parseDouble(columns[13]), Double.parseDouble(columns[14]));
                    entry.leftCrossing = new CrossingSide(Double.parseDouble(columns[18]), Double.parseDouble(columns[19]));
                    if (!columns[15].isEmpty()) {
                        entry.rightCrossing.crossingTriangle = new LegLength(Double.parseDouble(columns[15]), Double.parseDouble(columns[16]));
                    }
                    if (columns[20].isEmpty()) return entry;
                    entry.leftCrossing.crossingTriangle = new LegLength(Double.parseDouble(columns[20]), Double.parseDouble(columns[21]));
                    return entry;
                }
                case ENUMW_KR_ART_EW: {
                    entry.trackSwitchLength = new LegLength(Double.parseDouble(columns[8]), Double.parseDouble(columns[9]));
                    return entry;
                }
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String getDesignString() {
        return String.format("%s %s", this.type.toString(), this.design);
    }

    public static class CrossingSide {
        public LegLength crossingTriangle;
        public final LegLength crossing;

        private CrossingSide(double mainLeg, double sideLeg) {
            this.crossing = new LegLength(mainLeg, sideLeg);
        }
    }

    public static class LegLength {
        public final double mainLeg;
        public final double sideLeg;

        private LegLength(double mainLeg, double sideLeg) {
            this.mainLeg = mainLeg;
            this.sideLeg = sideLeg;
        }
    }
}

