/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.parts;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.emfcloud.jackson.module.EMFModule;
import org.eclipse.set.basis.files.ToolboxFileFilterBuilder;
import org.eclipse.set.feature.siteplan.Messages;
import org.eclipse.set.feature.siteplan.json.SiteplanEObjectSerializer;
import org.eclipse.set.feature.siteplan.transform.SiteplanTransformator;
import org.eclipse.set.model.siteplan.Siteplan;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.events.SelectedRowEvent;
import org.eclipse.set.utils.events.ToolboxEventHandler;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class WebSiteplanDevelopmentPart
extends BasePart {
    @Inject
    @Translation
    protected Messages messages;
    @Inject
    IEclipseContext context;
    ToolboxEventHandler<SelectedRowEvent> selectRowEvent;

    protected void createView(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Lageplanmodell exportieren (JSON)");
        button.addListener(13, event -> this.getDialogService().saveFileDialog(this.getToolboxShell(), List.of(ToolboxFileFilterBuilder.forName((String)"Lageplan").add(new String[]{"json"}).create()), Path.of("siteplan.json", new String[0])).ifPresent(path -> {
            this.writeSiteplanJSON((Path)path);
            this.getDialogService().openDirectoryAfterExport(this.getToolboxShell(), path.getParent());
        }));
    }

    private void writeSiteplanJSON(Path path) {
        SiteplanTransformator transformator = (SiteplanTransformator)this.context.get(SiteplanTransformator.class);
        Siteplan siteplan = transformator.transform(this.getModelSession());
        ObjectMapper mapper = new ObjectMapper();
        EMFModule module = new EMFModule();
        module.configure(EMFModule.Feature.OPTION_SERIALIZE_TYPE, false);
        module.configure(EMFModule.Feature.OPTION_SERIALIZE_DEFAULT_VALUE, true);
        mapper.registerModule((Module)module);
        mapper.registerModule((Module)SiteplanEObjectSerializer.getModule(module));
        try {
            String json = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)siteplan);
            Files.writeString(path, (CharSequence)json, new OpenOption[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

