/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.trackservice;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.set.feature.siteplan.trackservice.GEOKanteCoordinate;
import org.eclipse.set.feature.siteplan.trackservice.GEOKanteMetadata;
import org.eclipse.set.toolboxmodel.Basisobjekte.Bereich_Objekt;
import org.locationtech.jts.geom.Coordinate;

public class GEOKanteSegment {
    private final Set<Bereich_Objekt> bereichObjekte;
    private double length;
    private double start;

    GEOKanteSegment(double start, double length) {
        this.start = start;
        this.length = length;
        this.bereichObjekte = new HashSet<Bereich_Objekt>();
    }

    GEOKanteSegment(GEOKanteSegment other) {
        this.length = other.length;
        this.start = other.start;
        this.bereichObjekte = new HashSet<Bereich_Objekt>(other.bereichObjekte);
    }

    public Set<Bereich_Objekt> getBereichObjekte() {
        return this.bereichObjekte;
    }

    public double getLength() {
        return this.length;
    }

    public double getStart() {
        return this.start;
    }

    public double getEnd() {
        return this.start + this.length;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public void setStart(double start) {
        this.start = start;
    }

    public List<GEOKanteCoordinate> getCoordinates(GEOKanteMetadata geoKante) {
        ArrayList<GEOKanteCoordinate> result = new ArrayList<GEOKanteCoordinate>();
        Coordinate lastCoordinate = null;
        double distance = geoKante.getStart();
        Coordinate[] coordinateArray = geoKante.getGeometry().getCoordinates();
        int n = coordinateArray.length;
        int n2 = 0;
        while (n2 < n) {
            Coordinate coordinate = coordinateArray[n2];
            if (lastCoordinate == null) {
                lastCoordinate = coordinate;
            } else if (distance < this.getStart()) {
                distance += lastCoordinate.distance(coordinate);
                lastCoordinate = coordinate;
            } else {
                if (distance > this.getEnd()) break;
                if (result.isEmpty()) {
                    result.add(new GEOKanteCoordinate(lastCoordinate, this.bereichObjekte, geoKante.getCRS()));
                }
                result.add(new GEOKanteCoordinate(coordinate, this.bereichObjekte, geoKante.getCRS()));
                distance += lastCoordinate.distance(coordinate);
                lastCoordinate = coordinate;
            }
            ++n2;
        }
        return result;
    }
}

