/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.trackservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.cache.Cache;
import org.eclipse.set.basis.geometry.GeometryException;
import org.eclipse.set.core.services.cache.CacheService;
import org.eclipse.set.feature.siteplan.trackservice.GEOKanteCoordinate;
import org.eclipse.set.feature.siteplan.trackservice.GEOKanteMetadata;
import org.eclipse.set.feature.siteplan.trackservice.TrackService;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.GeoKanteExtensions;
import org.eclipse.set.ppmodel.extensions.GeoKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektTopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.StreckeExtensions;
import org.eclipse.set.ppmodel.extensions.StreckePunktExtensions;
import org.eclipse.set.ppmodel.extensions.TopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.TopKnotenExtensions;
import org.eclipse.set.toolboxmodel.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.toolboxmodel.Basisobjekte.Bereich_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.toolboxmodel.Basisobjekte.Seitlicher_Abstand_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Wirkrichtung_TypeClass;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Knoten;
import org.eclipse.set.toolboxmodel.Geodaten.Strecke;
import org.eclipse.set.toolboxmodel.Geodaten.Strecke_Punkt;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Knoten;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class TrackServiceImpl
implements TrackService {
    @Reference
    private CacheService cacheService;
    private static final double GEO_LENGTH_DEVIATION_TOLERANCE = 0.001;
    private static final double GEO_LENGTH_DEVIATION_TOLERANCE_RELATIVE = 1.0E-4;
    private static final double STRECKE_KM_SPACING = 100.0;
    private static final Logger logger = LoggerFactory.getLogger(TrackServiceImpl.class);
    private static final String METADATA_CACHE_ID = "toolbox.cache.siteplan.trackservice";

    @Override
    public GEOKanteCoordinate getCoordinate(Punkt_Objekt punktObjekt) {
        Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint = (Punkt_Objekt_TOP_Kante_AttributeGroup)punktObjekt.getPunktObjektTOPKante().get(0);
        return this.getCoordinateAt(singlePoint, 0.0);
    }

    @Override
    public GEOKanteCoordinate getCoordinateAt(Punkt_Objekt punktObjekt, double distance) {
        Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint = (Punkt_Objekt_TOP_Kante_AttributeGroup)punktObjekt.getPunktObjektTOPKante().get(0);
        return this.getCoordinateAt(singlePoint, distance);
    }

    @Override
    public GEOKanteCoordinate getCoordinateAt(Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint, double distance) {
        if (singlePoint == null) {
            return null;
        }
        double _doubleValue = singlePoint.getAbstand().getWert().doubleValue();
        double punktDistance = _doubleValue + distance;
        Wirkrichtung_TypeClass _wirkrichtung = singlePoint.getWirkrichtung();
        ENUMWirkrichtung _wert = null;
        if (_wirkrichtung != null) {
            _wert = _wirkrichtung.getWert();
        }
        ENUMWirkrichtung direction = _wert;
        TOP_Kante topKante = PunktObjektTopKanteExtensions.getTopKante((Punkt_Objekt_TOP_Kante_AttributeGroup)singlePoint);
        if (topKante == null) {
            return null;
        }
        GEOKanteMetadata geoKante = this.getGeoKanteAt(topKante, TopKanteExtensions.getTOPKnotenA((TOP_Kante)topKante), punktDistance);
        BigDecimal _elvis = null;
        Seitlicher_Abstand_TypeClass _seitlicherAbstand = null;
        if (singlePoint != null) {
            _seitlicherAbstand = singlePoint.getSeitlicherAbstand();
        }
        BigDecimal _wert_1 = null;
        if (_seitlicherAbstand != null) {
            _wert_1 = _seitlicherAbstand.getWert();
        }
        _elvis = _wert_1 != null ? _wert_1 : BigDecimal.ZERO;
        double lateralDistance = _elvis.doubleValue();
        if (direction == ENUMWirkrichtung.ENUM_WIRKRICHTUNG_BEIDE || direction == null) {
            return geoKante.getCoordinate(punktDistance, lateralDistance, ENUMWirkrichtung.ENUM_WIRKRICHTUNG_IN);
        }
        return geoKante.getCoordinate(punktDistance, lateralDistance, direction);
    }

    @Override
    public GEOKanteCoordinate getCoordinate(TOP_Kante topKante, TOP_Knoten start, double distance, double lateralDistance, ENUMWirkrichtung wirkrichtung) {
        GEOKanteMetadata geoKante = this.getGeoKanteAt(topKante, start, distance);
        GEOKanteCoordinate _coordinate = null;
        if (geoKante != null) {
            _coordinate = geoKante.getCoordinate(distance, lateralDistance, wirkrichtung);
        }
        return _coordinate;
    }

    @Override
    public GEOKanteMetadata getGeoKanteAt(TOP_Kante topKante, TOP_Knoten topKnoten, final double distance) {
        List<GEOKanteMetadata> geoMetadata = this.getTOPKanteMetadata(topKante, topKnoten);
        Predicate<GEOKanteMetadata> _function = new Predicate<GEOKanteMetadata>(){

            @Override
            public boolean test(GEOKanteMetadata md) {
                return md.getStart() <= distance && md.getEnd() >= distance;
            }
        };
        return geoMetadata.stream().filter(_function).findFirst().orElse(null);
    }

    private Cache getCache() {
        return this.cacheService.getCache(METADATA_CACHE_ID);
    }

    public List<GEOKanteMetadata> getTOPKanteMetadata(TOP_Kante topKante, TOP_Knoten topKnoten) {
        String _wert = topKante.getIdentitaet().getWert();
        String _wert_1 = topKnoten.getIdentitaet().getWert();
        String key = _wert + _wert_1;
        Object value = this.getCache().getIfPresent(key);
        if (value != null) {
            return (List)value;
        }
        List bereichObjekte = IterableExtensions.toList((Iterable)BasisAttributExtensions.getContainer((EObject)topKnoten).getBereichObjekt());
        List<GEOKanteMetadata> metadata = this.getTOPKanteMetadata(topKante, topKnoten, bereichObjekte);
        this.getCache().set(key, metadata);
        return metadata;
    }

    public List<GEOKanteMetadata> getTOPKanteMetadata(TOP_Kante topKante, TOP_Knoten topKnoten, List<Bereich_Objekt> bereichObjekte) {
        double distanceScalingFactor = TrackServiceImpl.getTOPKanteScalingFactor(topKante);
        double distance = 0.0;
        GEO_Knoten geoKnoten = TopKnotenExtensions.getGEOKnoten((TOP_Knoten)topKnoten);
        GEO_Kante geoKante = null;
        ArrayList<GEOKanteMetadata> geoKanteMetadata = new ArrayList<GEOKanteMetadata>();
        while (true) {
            List geoKanten = GeoKnotenExtensions.getGeoKantenOnTopKante((GEO_Knoten)geoKnoten, (TOP_Kante)topKante);
            geoKanten.remove(geoKante);
            boolean _isEmpty = geoKanten.isEmpty();
            if (_isEmpty) {
                return geoKanteMetadata;
            }
            geoKante = (GEO_Kante)geoKanten.get(0);
            double _doubleValue = geoKante.getGEOKanteAllg().getGEOLaenge().getWert().doubleValue();
            double geoKanteLength = _doubleValue * (1.0 / distanceScalingFactor);
            GEOKanteMetadata _gEOKanteMetadata = new GEOKanteMetadata(geoKante, distance, geoKanteLength, bereichObjekte, topKante, geoKnoten);
            geoKanteMetadata.add(_gEOKanteMetadata);
            double _distance = distance;
            distance = _distance + geoKanteLength;
            geoKnoten = GeoKanteExtensions.getOpposite((GEO_Kante)geoKante, (GEO_Knoten)geoKnoten);
        }
    }

    private static double getTOPKanteScalingFactor(TOP_Kante topKante) {
        double tolerance;
        List geoKantenOnTopKante = TopKanteExtensions.getGeoKanten((TOP_Kante)topKante);
        Functions.Function2<Double, GEO_Kante, Double> _function = new Functions.Function2<Double, GEO_Kante, Double>(){

            public Double apply(Double l, GEO_Kante k) {
                double _doubleValue = k.getGEOKanteAllg().getGEOLaenge().getWert().doubleValue();
                return l + _doubleValue;
            }
        };
        Double geoLength = (Double)IterableExtensions.fold((Iterable)geoKantenOnTopKante, (Object)0.0, (Functions.Function2)_function);
        double topLength = topKante.getTOPKanteAllg().getTOPLaenge().getWert().doubleValue();
        double difference = Math.abs(geoLength - topLength);
        if (difference > (tolerance = Math.max(0.001, topLength * 1.0E-4))) {
            logger.debug("lengthTopKante={}", (Object)topLength);
            logger.debug("lengthGeoKanten={}", (Object)geoLength);
            logger.debug("geoKantenOnTopKante={}", (Object)geoKantenOnTopKante.size());
            logger.warn("Difference of GEO Kanten length and TOP Kante length for TOP Kante {} greater than tolerance {} ({}).", new Object[]{topKante.getIdentitaet().getWert(), tolerance, difference});
        }
        return geoLength / topLength;
    }

    @Override
    public List<GEOKanteMetadata> getGeoKanten(TOP_Kante topKante) {
        return this.getTOPKanteMetadata(topKante, TopKanteExtensions.getTOPKnotenA((TOP_Kante)topKante));
    }

    @Override
    public List<Pair<GEOKanteCoordinate, Double>> getStreckeKilometers(Strecke strecke) {
        Strecke_Punkt[] startEnd = StreckeExtensions.getStartEnd((Strecke)strecke);
        if (startEnd == null) {
            return Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        Strecke_Punkt start = startEnd[0];
        Strecke_Punkt end = startEnd[1];
        int startMeter = start.getStreckeMeter().getWert().intValue();
        int endMeter = end.getStreckeMeter().getWert().intValue();
        double offset = (double)startMeter + (100.0 - (double)startMeter % 100.0);
        ArrayList result = CollectionLiterals.newArrayList();
        GEO_Kante geoKante = null;
        GEO_Knoten geoKnoten = StreckePunktExtensions.getGeoKnoten((Strecke_Punkt)start);
        double geoDistance = startMeter;
        while (true) {
            List geoKanten = IterableExtensions.toList((Iterable)GeoKnotenExtensions.getGeoKanten((GEO_Knoten)geoKnoten));
            geoKanten.remove(geoKante);
            boolean _isEmpty = geoKanten.isEmpty();
            if (_isEmpty) {
                return result;
            }
            geoKante = (GEO_Kante)geoKanten.get(0);
            GEOKanteMetadata metadata = new GEOKanteMetadata(geoKante, geoDistance, geoKnoten);
            while (offset <= metadata.getEnd()) {
                if (offset >= (double)endMeter) {
                    return result;
                }
                try {
                    GEOKanteCoordinate _coordinate = metadata.getCoordinate(offset, 0.0, ENUMWirkrichtung.ENUM_WIRKRICHTUNG_IN);
                    Pair _mappedTo = Pair.of((Object)_coordinate, (Object)offset);
                    result.add(_mappedTo);
                    double _offset = offset;
                    offset = _offset + 100.0;
                }
                catch (Throwable _t) {
                    if (_t instanceof GeometryException) {
                        double _offset_1 = offset;
                        offset = _offset_1 + 100.0;
                        continue;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
            double _geoDistance = geoDistance;
            double _length = metadata.getLength();
            geoDistance = _geoDistance + _length;
            geoKnoten = GeoKanteExtensions.getOpposite((GEO_Kante)geoKante, (GEO_Knoten)geoKnoten);
        }
    }

    @Override
    public void clearMetaData() {
        this.getCache().invalidate();
    }
}

