/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.transform;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.set.basis.geometry.GeometryException;
import org.eclipse.set.feature.siteplan.positionservice.PositionService;
import org.eclipse.set.feature.siteplan.trackservice.GEOKanteCoordinate;
import org.eclipse.set.feature.siteplan.trackservice.TrackService;
import org.eclipse.set.feature.siteplan.transform.BaseTransformator;
import org.eclipse.set.feature.siteplan.transform.TrackTransformator;
import org.eclipse.set.feature.siteplan.transform.Transformator;
import org.eclipse.set.model.siteplan.Coordinate;
import org.eclipse.set.model.siteplan.KMMarker;
import org.eclipse.set.model.siteplan.Route;
import org.eclipse.set.model.siteplan.RouteSection;
import org.eclipse.set.model.siteplan.SiteplanFactory;
import org.eclipse.set.model.siteplan.SiteplanPackage;
import org.eclipse.set.ppmodel.extensions.GeoKanteExtensions;
import org.eclipse.set.ppmodel.extensions.StreckeExtensions;
import org.eclipse.set.toolboxmodel.Geodaten.ENUMGEOKoordinatensystem;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.Strecke;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Transformator.class})
public class RouteTransformator
extends BaseTransformator<Strecke> {
    @Reference
    private TrackService trackService;
    @Reference
    private PositionService positionService;

    private RouteSection transform(GEO_Kante geoKante) {
        RouteSection it = SiteplanFactory.eINSTANCE.createRouteSection();
        it.setGuid(geoKante.getIdentitaet().getWert());
        it.setShape(TrackTransformator.transformGeoForm(geoKante.getGEOKanteAllg().getGEOForm()));
        final ENUMGEOKoordinatensystem crs = GeoKanteExtensions.getCRS((GEO_Kante)geoKante);
        Functions.Function1<org.locationtech.jts.geom.Coordinate, Coordinate> _function = new Functions.Function1<org.locationtech.jts.geom.Coordinate, Coordinate>(){

            public Coordinate apply(org.locationtech.jts.geom.Coordinate it_1) {
                return RouteTransformator.this.positionService.transformCoordinate(it_1, crs);
            }
        };
        it.getPositions().addAll((Collection)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)GeoKanteExtensions.getGeometry((GEO_Kante)geoKante).getCoordinates())), (Functions.Function1)_function));
        return it;
    }

    @Override
    public void transform(Strecke strecke) {
        Consumer<Object> _function;
        final Route track = SiteplanFactory.eINSTANCE.createRoute();
        track.setGuid(strecke.getIdentitaet().getWert());
        try {
            _function = new Consumer<GEO_Kante>(){

                @Override
                public void accept(GEO_Kante it) {
                    try {
                        track.getSections().add((Object)RouteTransformator.this.transform(it));
                    }
                    catch (Throwable _t) {
                        if (_t instanceof GeometryException) {
                            GeometryException exc = (GeometryException)_t;
                            throw new RuntimeException((Throwable)exc);
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                }
            };
            StreckeExtensions.getGeoKanten((Strecke)strecke).forEach(_function);
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                return;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _function = new Consumer<KMMarker>(){

            @Override
            public void accept(KMMarker marker) {
                track.getMarkers().add((Object)marker);
            }
        };
        this.transformKMMarkers(strecke).forEach((Consumer<KMMarker>)_function);
        this.addSiteplanElement(track, SiteplanPackage.eINSTANCE.getSiteplanState_Routes());
    }

    private Iterable<KMMarker> transformKMMarkers(Strecke strecke) {
        Functions.Function1<Pair<GEOKanteCoordinate, Double>, KMMarker> _function = new Functions.Function1<Pair<GEOKanteCoordinate, Double>, KMMarker>(){

            public KMMarker apply(Pair<GEOKanteCoordinate, Double> it) {
                try {
                    KMMarker kmMarker = SiteplanFactory.eINSTANCE.createKMMarker();
                    kmMarker.setPosition(RouteTransformator.this.positionService.transformPosition((GEOKanteCoordinate)it.getKey()));
                    kmMarker.setValue(((Double)it.getValue()).intValue());
                    return kmMarker;
                }
                catch (Throwable _t) {
                    if (_t instanceof GeometryException) {
                        return null;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        };
        return IterableExtensions.filterNull((Iterable)ListExtensions.map(this.trackService.getStreckeKilometers(strecke), (Functions.Function1)_function));
    }
}

