/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.transform;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.feature.siteplan.positionservice.PositionService;
import org.eclipse.set.feature.siteplan.trackservice.GEOKanteCoordinate;
import org.eclipse.set.feature.siteplan.trackservice.TrackService;
import org.eclipse.set.feature.siteplan.transform.BaseTransformator;
import org.eclipse.set.feature.siteplan.transform.Transformator;
import org.eclipse.set.model.siteplan.Label;
import org.eclipse.set.model.siteplan.Platform;
import org.eclipse.set.model.siteplan.SiteplanFactory;
import org.eclipse.set.model.siteplan.SiteplanPackage;
import org.eclipse.set.model.siteplan.Station;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.toolboxmodel.Bahnsteig.Bahnsteig_Anlage;
import org.eclipse.set.toolboxmodel.Bahnsteig.Bahnsteig_Anlage_Bezeichnung_AttributeGroup;
import org.eclipse.set.toolboxmodel.Bahnsteig.Bahnsteig_Kante;
import org.eclipse.set.toolboxmodel.Bahnsteig.Bahnsteig_Kante_Bezeichnung_AttributeGroup;
import org.eclipse.set.toolboxmodel.Bahnsteig.Bezeichnung_Bahnsteig_Anlage_TypeClass;
import org.eclipse.set.toolboxmodel.Bahnsteig.Bezeichnung_Bahnsteig_Kante_TypeClass;
import org.eclipse.set.toolboxmodel.BasisTypen.ENUMLinksRechts;
import org.eclipse.set.toolboxmodel.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.toolboxmodel.Basisobjekte.Bereich_Objekt_Teilbereich_AttributeGroup;
import org.eclipse.set.toolboxmodel.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Transformator.class})
public class StationTransformator
extends BaseTransformator<Bahnsteig_Anlage> {
    @Reference
    private TrackService trackService;
    @Reference
    private PositionService positionService;
    private static final double STATION_TRACK_DISTANCE = 1.7;

    @Override
    public void transform(final Bahnsteig_Anlage station) {
        Station result = SiteplanFactory.eINSTANCE.createStation();
        Identitaet_TypeClass _identitaet = station.getIdentitaet();
        String _wert = null;
        if (_identitaet != null) {
            _wert = _identitaet.getWert();
        }
        result.setGuid(_wert);
        result.setLabel(SiteplanFactory.eINSTANCE.createLabel());
        Label _label = result.getLabel();
        Bahnsteig_Anlage_Bezeichnung_AttributeGroup _bezeichnung = station.getBezeichnung();
        Bezeichnung_Bahnsteig_Anlage_TypeClass _bezeichnungBahnsteigAnlage = null;
        if (_bezeichnung != null) {
            _bezeichnungBahnsteigAnlage = _bezeichnung.getBezeichnungBahnsteigAnlage();
        }
        String _wert_1 = null;
        if (_bezeichnungBahnsteigAnlage != null) {
            _wert_1 = _bezeichnungBahnsteigAnlage.getWert();
        }
        _label.setText(_wert_1);
        Functions.Function1<Bahnsteig_Kante, Boolean> _function = new Functions.Function1<Bahnsteig_Kante, Boolean>(){

            public Boolean apply(Bahnsteig_Kante it) {
                Bahnsteig_Anlage _iDBahnsteigAnlage = it.getIDBahnsteigAnlage();
                return _iDBahnsteigAnlage == station;
            }
        };
        Functions.Function1<Bahnsteig_Kante, Platform> _function_1 = new Functions.Function1<Bahnsteig_Kante, Platform>(){

            public Platform apply(Bahnsteig_Kante it) {
                return StationTransformator.this.transform(it);
            }
        };
        Iterables.addAll((Collection)result.getPlatforms(), (Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)station).getBahnsteigKante(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        this.addSiteplanElement(result, SiteplanPackage.eINSTANCE.getSiteplanState_Stations());
    }

    public Platform transform(final Bahnsteig_Kante platform) {
        final Platform result = SiteplanFactory.eINSTANCE.createPlatform();
        Identitaet_TypeClass _identitaet = platform.getIdentitaet();
        String _wert = null;
        if (_identitaet != null) {
            _wert = _identitaet.getWert();
        }
        result.setGuid(_wert);
        result.setLabel(SiteplanFactory.eINSTANCE.createLabel());
        Label _label = result.getLabel();
        Bahnsteig_Kante_Bezeichnung_AttributeGroup _bezeichnung = platform.getBezeichnung();
        Bezeichnung_Bahnsteig_Kante_TypeClass _bezeichnungBahnsteigKante = null;
        if (_bezeichnung != null) {
            _bezeichnungBahnsteigKante = _bezeichnung.getBezeichnungBahnsteigKante();
        }
        String _wert_1 = null;
        if (_bezeichnungBahnsteigKante != null) {
            _wert_1 = _bezeichnungBahnsteigKante.getWert();
        }
        _label.setText(_wert_1);
        Consumer<Bereich_Objekt_Teilbereich_AttributeGroup> _function = new Consumer<Bereich_Objekt_Teilbereich_AttributeGroup>(){

            @Override
            public void accept(Bereich_Objekt_Teilbereich_AttributeGroup tb) {
                ENUMWirkrichtung _wert_1;
                boolean _tripleEquals_1;
                boolean _tripleEquals;
                double lateralDistance = 1.7;
                ENUMLinksRechts _wert = platform.getBahnsteigKanteAllg().getLageZumGleis().getWert();
                boolean bl = _tripleEquals = _wert == ENUMLinksRechts.ENUM_LINKS_RECHTS_LINKS;
                if (_tripleEquals) {
                    lateralDistance = -lateralDistance;
                }
                boolean bl2 = _tripleEquals_1 = (_wert_1 = tb.getRichtungsbezug().getWert()) == ENUMWirkrichtung.ENUM_WIRKRICHTUNG_GEGEN;
                if (_tripleEquals_1) {
                    lateralDistance = -lateralDistance;
                }
                TOP_Kante topKante = tb.getIDTOPKante();
                GEOKanteCoordinate start = StationTransformator.this.trackService.getCoordinate(topKante, topKante.getIDTOPKnotenA(), tb.getBegrenzungA().getWert().doubleValue(), lateralDistance, tb.getRichtungsbezug().getWert());
                GEOKanteCoordinate end = StationTransformator.this.trackService.getCoordinate(topKante, topKante.getIDTOPKnotenA(), tb.getBegrenzungB().getWert().doubleValue(), lateralDistance, tb.getRichtungsbezug().getWert());
                result.getPoints().add((Object)StationTransformator.this.positionService.transformPosition(start));
                result.getPoints().add((Object)StationTransformator.this.positionService.transformPosition(end));
            }
        };
        platform.getBereichObjektTeilbereich().forEach((Consumer)_function);
        return result;
    }
}

