/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.transform;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.set.feature.siteplan.TrackSwitchMetadata;
import org.eclipse.set.feature.siteplan.positionservice.PositionService;
import org.eclipse.set.feature.siteplan.trackservice.GEOKanteCoordinate;
import org.eclipse.set.feature.siteplan.trackservice.TrackService;
import org.eclipse.set.model.siteplan.Coordinate;
import org.eclipse.set.model.siteplan.Position;
import org.eclipse.set.ppmodel.extensions.PunktObjektExtensions;
import org.eclipse.set.ppmodel.extensions.TopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.TopKnotenExtensions;
import org.eclipse.set.toolboxmodel.BasisTypen.ENUMLinksRechts;
import org.eclipse.set.toolboxmodel.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.toolboxmodel.Geodaten.ENUMTOPAnschluss;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Knoten;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Kreuzungsgleis_TypeClass;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Gsp_Komponente;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Zungenpaar_AttributeGroup;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class TrackSwitchLeg {
    private final int TRACK_SWITCH_POINTS = 10;
    private final int DEFAULT_TRACKSWITCH_LEG_LENGTH = 20;
    private TOP_Kante topKante;
    private TOP_Knoten topKnoten;
    private ENUMTOPAnschluss connection;
    private double length = 20.0;
    private double start = 0.0;

    public double getLength() {
        return this.length;
    }

    public TOP_Kante getTOPKante() {
        return this.topKante;
    }

    public ENUMTOPAnschluss getConnection() {
        return this.connection;
    }

    public Coordinate[] getCoordinates(TrackService trackService, final PositionService positionService) {
        double legLength = Math.min(this.start + this.length, this.topKante.getTOPKanteAllg().getTOPLaenge().getWert().doubleValue());
        double sectionLength = (legLength - this.start) / (double)(10 - 1);
        ArrayList result = CollectionLiterals.newArrayList();
        int i = 0;
        while (i < 10) {
            result.add(trackService.getCoordinate(this.topKante, this.topKnoten, this.start + sectionLength * (double)i, 0.0, null));
            ++i;
        }
        Functions.Function1<GEOKanteCoordinate, Position> _function = new Functions.Function1<GEOKanteCoordinate, Position>(){

            public Position apply(GEOKanteCoordinate coordinate) {
                return positionService.transformPosition(coordinate);
            }
        };
        return (Coordinate[])Conversions.unwrapArray((Object)IterableExtensions.map((Iterable)IterableExtensions.filterNull((Iterable)result), (Functions.Function1)_function), Coordinate.class);
    }

    public Position getNodeCoordinate(TrackService trackService, PositionService positionService) {
        return positionService.transformPosition(trackService.getCoordinate(this.topKante, this.topKnoten, 0.0, 0.0, null));
    }

    public Position getCoordinate(double distance, double lateralDistance, TrackService trackService, PositionService positionService) {
        return positionService.transformPosition(trackService.getCoordinate(this.topKante, this.topKnoten, this.start + distance, lateralDistance, ENUMWirkrichtung.ENUM_WIRKRICHTUNG_IN));
    }

    public static TrackSwitchLeg getLeg(List<W_Kr_Gsp_Komponente> components, TrackSwitchMetadata metadata, int legIndex) {
        boolean _equals;
        TrackSwitchLeg leg = new TrackSwitchLeg();
        int _length = ((Object[])Conversions.unwrapArray(components, Object.class)).length;
        boolean bl = _equals = _length == 1;
        if (_equals) {
            if (metadata != null && metadata.trackSwitchLength != null) {
                leg.length = legIndex == 0 ? metadata.trackSwitchLength.mainLeg : metadata.trackSwitchLength.sideLeg;
            }
            W_Kr_Gsp_Komponente component = (W_Kr_Gsp_Komponente)IterableExtensions.head(components);
            leg.topKnoten = PunktObjektExtensions.getTopKnoten((Punkt_Objekt)component);
            if (leg.topKnoten == null || ((Object[])Conversions.unwrapArray(TrackSwitchLeg.getTrackSwitchLegs(leg.topKnoten), Object.class)).length - 1 < legIndex) {
                return null;
            }
            leg.topKante = ((TOP_Kante[])Conversions.unwrapArray(TrackSwitchLeg.getTrackSwitchLegs(leg.topKnoten), TOP_Kante.class))[legIndex];
            leg.connection = TopKanteExtensions.getTOPAnschluss((TOP_Kante)leg.topKante, (TOP_Knoten)leg.topKnoten);
        } else {
            if (metadata != null) {
                leg.length = metadata.rightCrossing.crossing.mainLeg;
                if (metadata.rightCrossing.crossingTriangle != null) {
                    leg.start = metadata.rightCrossing.crossingTriangle.mainLeg - leg.length;
                }
            }
            W_Kr_Gsp_Komponente component_1 = components.get(legIndex);
            leg.topKante = TrackSwitchLeg.getCrossingLeg(component_1);
            leg.topKnoten = PunktObjektExtensions.getTopKnoten((Punkt_Objekt)component_1);
        }
        if (leg.topKante == null || leg.topKnoten == null) {
            return null;
        }
        return leg;
    }

    private static TOP_Kante getCrossingLeg(W_Kr_Gsp_Komponente component) {
        ENUMLinksRechts crossingSide;
        boolean _equals;
        final TOP_Knoten topKnoten = PunktObjektExtensions.getTopKnoten((Punkt_Objekt)component);
        Zungenpaar_AttributeGroup _zungenpaar = null;
        if (component != null) {
            _zungenpaar = component.getZungenpaar();
        }
        Kreuzungsgleis_TypeClass _kreuzungsgleis = null;
        if (_zungenpaar != null) {
            _kreuzungsgleis = _zungenpaar.getKreuzungsgleis();
        }
        ENUMLinksRechts _wert = null;
        if (_kreuzungsgleis != null) {
            _wert = _kreuzungsgleis.getWert();
        }
        if (_equals = Objects.equal((Object)(crossingSide = _wert), (Object)ENUMLinksRechts.ENUM_LINKS_RECHTS_RECHTS)) {
            Functions.Function1<TOP_Kante, Boolean> _function = new Functions.Function1<TOP_Kante, Boolean>(){

                public Boolean apply(TOP_Kante it) {
                    ENUMTOPAnschluss _tOPAnschluss = TopKanteExtensions.getTOPAnschluss((TOP_Kante)it, (TOP_Knoten)topKnoten);
                    return Objects.equal((Object)_tOPAnschluss, (Object)ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_RECHTS);
                }
            };
            return (TOP_Kante)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)TopKnotenExtensions.getTopKanten((TOP_Knoten)topKnoten), (Functions.Function1)_function));
        }
        boolean _equals_1 = Objects.equal((Object)crossingSide, (Object)ENUMLinksRechts.ENUM_LINKS_RECHTS_LINKS);
        if (_equals_1) {
            Functions.Function1<TOP_Kante, Boolean> _function_1 = new Functions.Function1<TOP_Kante, Boolean>(){

                public Boolean apply(TOP_Kante it) {
                    ENUMTOPAnschluss _tOPAnschluss = TopKanteExtensions.getTOPAnschluss((TOP_Kante)it, (TOP_Knoten)topKnoten);
                    return Objects.equal((Object)_tOPAnschluss, (Object)ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_LINKS);
                }
            };
            return (TOP_Kante)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)TopKnotenExtensions.getTopKanten((TOP_Knoten)topKnoten), (Functions.Function1)_function_1));
        }
        return null;
    }

    private static Iterable<TOP_Kante> getTrackSwitchLegs(final TOP_Knoten trackSwitchTopNode) {
        Functions.Function1<TOP_Kante, Boolean> _function = new Functions.Function1<TOP_Kante, Boolean>(){

            public Boolean apply(TOP_Kante it) {
                boolean _xblockexpression = false;
                ENUMTOPAnschluss anschluss = TopKanteExtensions.getTOPAnschluss((TOP_Kante)it, (TOP_Knoten)trackSwitchTopNode);
                _xblockexpression = Objects.equal((Object)anschluss, (Object)ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_LINKS) || Objects.equal((Object)anschluss, (Object)ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_RECHTS);
                return _xblockexpression;
            }
        };
        return IterableExtensions.filter((Iterable)TopKnotenExtensions.getTopKanten((TOP_Knoten)trackSwitchTopNode), (Functions.Function1)_function);
    }
}

