/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.abstracttableview;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.config.DefaultColumnGroupHeaderLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.SizeConfig;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.LayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.set.feature.table.abstracttableview.ColumnGroupGroupGroupHeaderLayer;

public class ColumnGroup4HeaderLayer
extends AbstractLayerTransform {
    private final ColumnGroupGroupGroupHeaderLayer columnGroupGroupGroupHeaderLayer;
    private final ColumnGroupGroupHeaderLayer columnGroupGroupHeaderLayer;
    private final ColumnGroupHeaderLayer columnGroupHeaderLayer;
    private final ColumnGroupModel model;
    private final SizeConfig rowHeightConfig = new SizeConfig(20);

    public ColumnGroup4HeaderLayer(ColumnGroupGroupGroupHeaderLayer columnGroupGroupGroupHeaderLayer, ColumnGroupGroupHeaderLayer columnGroupGroupHeaderLayer, ColumnGroupHeaderLayer columnGroupHeaderLayer, SelectionLayer selectionLayer, ColumnGroupModel columnGroupGroupGroupModel) {
        super((ILayer)columnGroupGroupGroupHeaderLayer);
        this.columnGroupGroupGroupHeaderLayer = columnGroupGroupGroupHeaderLayer;
        this.columnGroupGroupHeaderLayer = columnGroupGroupHeaderLayer;
        this.columnGroupHeaderLayer = columnGroupHeaderLayer;
        this.model = columnGroupGroupGroupModel;
        this.addConfiguration((IConfiguration)new DefaultColumnGroupHeaderLayerConfiguration(columnGroupGroupGroupModel));
    }

    public void addColumnsIndexesToGroup(String colGroupGroupGroupName, int ... colIndexes) {
        this.model.addColumnsIndexesToGroup(colGroupGroupGroupName, colIndexes);
    }

    public ILayerCell getCellByPosition(int columnPosition, int rowPosition) {
        int bodyColumnIndex = this.getColumnIndexByPosition(columnPosition);
        if (rowPosition == 0) {
            if (this.model.isPartOfAGroup(bodyColumnIndex)) {
                return new LayerCell((ILayer)this, this.getStartPositionOfGroup(columnPosition), rowPosition, columnPosition, rowPosition, this.getColumnSpan(columnPosition), 1);
            }
            ILayerCell underlyingCell = this.columnGroupGroupGroupHeaderLayer.getCellByPosition(columnPosition, rowPosition);
            return new LayerCell((ILayer)this, underlyingCell.getOriginColumnPosition(), underlyingCell.getOriginRowPosition(), columnPosition, rowPosition, underlyingCell.getColumnSpan(), underlyingCell.getRowSpan() + 1);
        }
        if (rowPosition == 1) {
            ILayerCell underlyingCell = this.columnGroupGroupGroupHeaderLayer.getCellByPosition(columnPosition, rowPosition - 1);
            boolean partOfAGroup = this.model.isPartOfAGroup(bodyColumnIndex);
            return new LayerCell((ILayer)this, underlyingCell.getOriginColumnPosition(), underlyingCell.getOriginRowPosition() + (partOfAGroup ? 1 : 0), columnPosition, rowPosition, underlyingCell.getColumnSpan(), underlyingCell.getRowSpan() + (partOfAGroup ? 0 : 1));
        }
        if (rowPosition == 2) {
            ILayerCell underlyingCell = this.columnGroupGroupGroupHeaderLayer.getCellByPosition(columnPosition, rowPosition - 1);
            boolean partOfAGroup = this.model.isPartOfAGroup(bodyColumnIndex) || this.columnGroupGroupGroupHeaderLayer.isColumnInGroup(bodyColumnIndex);
            return new LayerCell((ILayer)this, underlyingCell.getOriginColumnPosition(), underlyingCell.getOriginRowPosition() + (partOfAGroup ? 1 : 0), columnPosition, rowPosition, underlyingCell.getColumnSpan(), underlyingCell.getRowSpan() + (partOfAGroup ? 0 : 1));
        }
        if (rowPosition == 3) {
            ILayerCell underlyingCell = this.columnGroupGroupGroupHeaderLayer.getCellByPosition(columnPosition, rowPosition - 1);
            boolean partOfAGroup = this.model.isPartOfAGroup(bodyColumnIndex) || this.columnGroupGroupGroupHeaderLayer.isColumnInGroup(bodyColumnIndex) || this.columnGroupGroupHeaderLayer.isColumnInGroup(bodyColumnIndex);
            return new LayerCell((ILayer)this, underlyingCell.getOriginColumnPosition(), underlyingCell.getOriginRowPosition() + (partOfAGroup ? 1 : 0), columnPosition, rowPosition, underlyingCell.getColumnSpan(), underlyingCell.getRowSpan() + (partOfAGroup ? 0 : 1));
        }
        if (rowPosition == 4) {
            ILayerCell underlyingCell = this.columnGroupGroupGroupHeaderLayer.getCellByPosition(columnPosition, rowPosition - 1);
            boolean partOfAGroup = this.model.isPartOfAGroup(bodyColumnIndex) || this.columnGroupGroupGroupHeaderLayer.isColumnInGroup(bodyColumnIndex) || this.columnGroupGroupHeaderLayer.isColumnInGroup(bodyColumnIndex) || this.columnGroupHeaderLayer.isColumnInGroup(bodyColumnIndex);
            return new LayerCell((ILayer)this, underlyingCell.getOriginColumnPosition(), underlyingCell.getOriginRowPosition() + (partOfAGroup ? 1 : 0), columnPosition, rowPosition, underlyingCell.getColumnSpan(), underlyingCell.getRowSpan() + (partOfAGroup ? 0 : 1));
        }
        return null;
    }

    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        int localRowPosition = rowPosition;
        int columnIndex = this.getColumnIndexByPosition(columnPosition);
        if (localRowPosition == 0 && this.model.isPartOfAGroup(columnIndex)) {
            LabelStack stack = new LabelStack(new String[]{"COLUMN_GROUP_HEADER"});
            if (this.model.isPartOfACollapseableGroup(columnIndex)) {
                ColumnGroupModel.ColumnGroup group = this.model.getColumnGroupByIndex(columnIndex);
                if (group.isCollapsed()) {
                    stack.addLabelOnTop("GROUP_COLLAPSED");
                } else {
                    stack.addLabelOnTop("GROUP_EXPANDED");
                }
            }
            return stack;
        }
        if (localRowPosition != 0) {
            --localRowPosition;
        }
        return this.columnGroupGroupGroupHeaderLayer.getConfigLabelsByPosition(columnPosition, localRowPosition);
    }

    public Object getDataValueByPosition(int columnPosition, int rowPosition) {
        int localRowPosition = rowPosition;
        int columnIndex = this.getColumnIndexByPosition(columnPosition);
        ColumnGroupModel.ColumnGroup columnGroup = this.model.getColumnGroupByIndex(columnIndex);
        if (localRowPosition == 0) {
            if (this.model.isPartOfAGroup(columnIndex)) {
                return columnGroup.getName();
            }
        } else {
            --localRowPosition;
        }
        return this.columnGroupGroupGroupHeaderLayer.getDataValueByPosition(columnPosition, localRowPosition);
    }

    public DisplayMode getDisplayModeByPosition(int columnPosition, int rowPosition) {
        int columnIndex = this.getColumnIndexByPosition(columnPosition);
        if (rowPosition == 0 && this.model.isPartOfAGroup(columnIndex)) {
            return DisplayMode.NORMAL;
        }
        return this.columnGroupGroupGroupHeaderLayer.getDisplayModeByPosition(columnPosition, rowPosition);
    }

    public int getHeight() {
        return this.rowHeightConfig.getAggregateSize(1) + this.columnGroupGroupGroupHeaderLayer.getHeight();
    }

    public int getPreferredHeight() {
        return this.rowHeightConfig.getAggregateSize(1) + this.columnGroupGroupGroupHeaderLayer.getPreferredHeight();
    }

    public int getPreferredRowCount() {
        return this.columnGroupGroupHeaderLayer.getPreferredRowCount() + 1;
    }

    public LabelStack getRegionLabelsByXY(int x, int y) {
        int columnIndex = this.getColumnIndexByPosition(this.getColumnPositionByX(x));
        if (this.model.isPartOfAGroup(columnIndex) && y < this.getRowHeightByPosition(0)) {
            return new LabelStack(new String[]{"COLUMN_GROUP_HEADER"});
        }
        return this.columnGroupGroupGroupHeaderLayer.getRegionLabelsByXY(x, y - this.getRowHeightByPosition(0));
    }

    public int getRowCount() {
        return this.columnGroupGroupGroupHeaderLayer.getRowCount() + 1;
    }

    public int getRowHeightByPosition(int rowPosition) {
        if (rowPosition == 0) {
            return this.rowHeightConfig.getSize(rowPosition);
        }
        return this.columnGroupGroupGroupHeaderLayer.getRowHeightByPosition(rowPosition - 1);
    }

    public int getRowIndexByPosition(int rowPosition) {
        if (rowPosition == 0) {
            return rowPosition;
        }
        return this.columnGroupGroupGroupHeaderLayer.getRowIndexByPosition(rowPosition - 1);
    }

    public int getRowPositionByY(int y) {
        int row0Height = this.getRowHeightByPosition(0);
        if (y < row0Height) {
            return 0;
        }
        return 1 + this.columnGroupGroupGroupHeaderLayer.getRowPositionByY(y - row0Height);
    }

    public int getStartYOfRowPosition(int rowPosition) {
        if (rowPosition == 0) {
            return this.rowHeightConfig.getAggregateSize(rowPosition);
        }
        return this.getRowHeightByPosition(0) + this.columnGroupGroupGroupHeaderLayer.getStartYOfRowPosition(rowPosition - 1);
    }

    public boolean isRowPositionResizable(int rowPosition) {
        if (rowPosition == 0) {
            return this.rowHeightConfig.isPositionResizable(rowPosition);
        }
        return this.columnGroupGroupGroupHeaderLayer.isRowPositionResizable(rowPosition - 1);
    }

    public void setRowHeight(int rowHeight) {
        this.rowHeightConfig.setSize(0, rowHeight);
    }

    private int getStartPositionOfGroup(int columnPosition) {
        int bodyColumnIndex = this.getColumnIndexByPosition(columnPosition);
        ColumnGroupModel.ColumnGroup columnGroup = this.model.getColumnGroupByIndex(bodyColumnIndex);
        int leastPossibleStartPositionOfGroup = columnPosition - columnGroup.getSize();
        int i = 0;
        i = leastPossibleStartPositionOfGroup;
        while (i < columnPosition) {
            if (ColumnGroupUtils.isInTheSameGroup((int)this.getColumnIndexByPosition(i), (int)bodyColumnIndex, (ColumnGroupModel)this.model)) break;
            ++i;
        }
        return i;
    }

    protected int getColumnSpan(int columnPosition) {
        int columnIndex = this.getColumnIndexByPosition(columnPosition);
        ColumnGroupModel.ColumnGroup columnGroup = this.model.getColumnGroupByIndex(columnIndex);
        int sizeOfGroup = columnGroup.getSize();
        if (columnGroup.isCollapsed()) {
            int sizeOfStaticColumns = columnGroup.getStaticColumnIndexes().size();
            if (sizeOfStaticColumns == 0) {
                return 1;
            }
            sizeOfGroup = sizeOfStaticColumns;
        }
        int startPositionOfGroup = this.getStartPositionOfGroup(columnPosition);
        int endPositionOfGroup = startPositionOfGroup + sizeOfGroup;
        List columnIndexesInGroup = columnGroup.getMembers();
        int i = startPositionOfGroup;
        while (i < endPositionOfGroup) {
            int index = this.getColumnIndexByPosition(i);
            if (!columnIndexesInGroup.contains(index)) {
                --sizeOfGroup;
            }
            ++i;
        }
        return sizeOfGroup;
    }
}

