/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.model.siteplan;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PZBElement implements Enumerator
{
    NONE(0, "None", "None"),
    F500_HZ(1, "F500Hz", "500Hz"),
    F1000_HZ(2, "F1000Hz", "1000Hz"),
    F2000_HZ(3, "F2000Hz", "2000Hz"),
    F1000_HZ2000_HZ(4, "F1000Hz2000Hz", "1000Hz2000Hz");

    public static final int NONE_VALUE = 0;
    public static final int F500_HZ_VALUE = 1;
    public static final int F1000_HZ_VALUE = 2;
    public static final int F2000_HZ_VALUE = 3;
    public static final int F1000_HZ2000_HZ_VALUE = 4;
    private static final PZBElement[] VALUES_ARRAY;
    public static final List<PZBElement> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PZBElement[]{NONE, F500_HZ, F1000_HZ, F2000_HZ, F1000_HZ2000_HZ};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PZBElement get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PZBElement result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PZBElement getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PZBElement result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PZBElement get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return F500_HZ;
            }
            case 2: {
                return F1000_HZ;
            }
            case 3: {
                return F2000_HZ;
            }
            case 4: {
                return F1000_HZ2000_HZ;
            }
        }
        return null;
    }

    private PZBElement(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

