/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.export.checkboxmodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.set.core.services.export.CheckboxModelElement;

public final class CheckboxModel {
    private final List<CheckboxModelElement> checkboxes;

    public CheckboxModel(CheckboxModelElement[] elements) {
        this.checkboxes = new ArrayList<CheckboxModelElement>(Arrays.asList(elements));
    }

    public void deselectAll() {
        this.checkboxes.forEach(ele -> ele.deselect());
    }

    public CheckboxModelElement[] getChecked() {
        List<CheckboxModelElement> result = this.checkboxes.stream().filter(ele -> ele.isChecked()).collect(Collectors.toList());
        return result.toArray(new CheckboxModelElement[result.size()]);
    }

    public CheckboxModelElement[] getElements() {
        return this.checkboxes.toArray(new CheckboxModelElement[this.checkboxes.size()]);
    }

    public void selectAll() {
        this.checkboxes.forEach(ele -> ele.select());
    }
}

