/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.export.parts;

import java.nio.file.Paths;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.set.basis.OverwriteHandling;
import org.eclipse.set.model.titlebox.Titlebox;
import org.eclipse.set.ppmodel.extensions.utils.PlanProToTitleboxTransformation;
import org.eclipse.set.services.export.ExportService;
import org.eclipse.set.toolboxmodel.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.exception.ExceptionHandler;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TitleBoxImagePart
extends BasePart {
    private static final String TITLEBOX_IMAGE = "titlebox.png";
    @Inject
    private ExportService exportService;

    private static Image createImage(String image, LocalResourceManager localResourceManager) {
        ImageDescriptor titleboxDescriptor = ImageDescriptor.createFromFile(null, (String)image);
        return localResourceManager.createImage(titleboxDescriptor);
    }

    private static void createTitlebox(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        Label label = new Label(parent, 0);
        LocalResourceManager localResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)label);
        label.setImage(TitleBoxImagePart.createImage(TITLEBOX_IMAGE, localResourceManager));
    }

    @Inject
    public TitleBoxImagePart() {
    }

    private void createTitleboxImage(PlanPro_Schnittstelle planProSchnittstelle) throws Exception {
        PlanProToTitleboxTransformation planProToTitlebox = PlanProToTitleboxTransformation.create();
        Titlebox titlebox = planProToTitlebox.transform(planProSchnittstelle, null);
        this.exportService.exportTitleboxImage(titlebox, Paths.get(this.getModelSession().getTempDir().toString(), TITLEBOX_IMAGE), OverwriteHandling.forCheckbox((boolean)true), (Consumer)new ExceptionHandler(this.getToolboxShell(), this.getDialogService()));
    }

    protected void createView(Composite parent) {
        if (this.getModelSession() != null) {
            try {
                this.createTitleboxImage(this.getModelSession().getPlanProSchnittstelle());
                TitleBoxImagePart.createTitlebox(parent);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

