/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.model.validationreport;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ObjectScope implements Enumerator
{
    LAYOUT(4, "Layout", "Layout"),
    CONTENT(3, "Content", "Fachdaten"),
    BETRACHTUNG(2, "Betrachtung", "Betrachtung"),
    PLAN(1, "Plan", "Planung"),
    UNKNOWN(0, "Unknown", "");

    public static final int LAYOUT_VALUE = 4;
    public static final int CONTENT_VALUE = 3;
    public static final int BETRACHTUNG_VALUE = 2;
    public static final int PLAN_VALUE = 1;
    public static final int UNKNOWN_VALUE = 0;
    private static final ObjectScope[] VALUES_ARRAY;
    public static final List<ObjectScope> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ObjectScope[]{LAYOUT, CONTENT, BETRACHTUNG, PLAN, UNKNOWN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ObjectScope get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ObjectScope result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ObjectScope getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ObjectScope result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ObjectScope get(int value) {
        switch (value) {
            case 4: {
                return LAYOUT;
            }
            case 3: {
                return CONTENT;
            }
            case 2: {
                return BETRACHTUNG;
            }
            case 1: {
                return PLAN;
            }
            case 0: {
                return UNKNOWN;
            }
        }
        return null;
    }

    private ObjectScope(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

