/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.core.enumtranslation;

import java.lang.reflect.Field;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.set.basis.Translateable;
import org.eclipse.set.basis.exceptions.NoEnumTranslationFound;
import org.eclipse.set.core.Messages;
import org.eclipse.set.core.enumtranslation.Enumerators;
import org.eclipse.set.core.services.enumtranslation.EnumTranslation;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.utils.enums.EnumTranslationUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class EnumTranslationServiceImpl
implements EnumTranslationService {
    @Reference
    Enumerators enumerators;
    @Reference
    Messages messages;

    protected static Field[] getDeclaredFields() {
        return Enumerators.class.getDeclaredFields();
    }

    public EnumTranslation translate(boolean value) throws NoEnumTranslationFound {
        return this.translate(EnumTranslationUtils.getKeyBasis((Boolean)value));
    }

    public EnumTranslation translate(Enumerator obj) {
        Enumerator enumerator = obj;
        String enumeratorName = EnumTranslationUtils.getKeyBasis((Enumerator)enumerator);
        return this.translate(enumeratorName);
    }

    public <C extends Enumerator> List<EnumTranslation> translate(List<C> enums) {
        return enums.stream().map(this::translate).toList();
    }

    public EnumTranslation translate(Translateable translateable) {
        return this.translate(translateable.getKey());
    }

    private EnumTranslation translate(final String keyBasis) {
        return new EnumTranslation(){

            public String getAlternative() {
                return EnumTranslationServiceImpl.this.translateSingle(EnumTranslationUtils.getKeyAlternative((String)keyBasis));
            }

            public String getKeyBasis() {
                return keyBasis;
            }

            public String getPresentation() {
                return EnumTranslationServiceImpl.this.translateSingle(EnumTranslationUtils.getKeyPresentation((String)keyBasis));
            }

            public String getSorting() {
                return EnumTranslationServiceImpl.this.translateSingle(EnumTranslationUtils.getKeySorting((String)keyBasis));
            }
        };
    }

    private String translateApplicationEnum(String key) {
        try {
            Field[] declaredFields;
            Field[] fieldArray = declaredFields = Messages.class.getDeclaredFields();
            int n = declaredFields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                String fieldName = field.getName();
                if (fieldName.equals(key)) {
                    return ((String)field.get(this.messages)).trim();
                }
                ++n2;
            }
            throw new NoEnumTranslationFound((Object)key);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    String translateSingle(String key) {
        try {
            Field[] declaredFields;
            Field[] fieldArray = declaredFields = EnumTranslationServiceImpl.getDeclaredFields();
            int n = declaredFields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                String fieldName = field.getName();
                if (fieldName.equals(key)) {
                    return ((String)field.get(this.enumerators)).trim();
                }
                ++n2;
            }
            return this.translateApplicationEnum(key);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }
}

