/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel.check;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringSubstitutor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.core.services.graph.BankService;
import org.eclipse.set.feature.plazmodel.check.AbstractPlazContainerCheck;
import org.eclipse.set.feature.plazmodel.check.PlazCheck;
import org.eclipse.set.model.plazmodel.PlazError;
import org.eclipse.set.model.plazmodel.PlazFactory;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.toolboxmodel.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.toolboxmodel.Geodaten.Ueberhoehungslinie;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class BankValues
extends AbstractPlazContainerCheck
implements PlazCheck {
    @Reference
    private BankService bankService;

    @Override
    public List<PlazError> run(MultiContainer_AttributeGroup container) {
        Functions.Function1<Ueberhoehungslinie, PlazError> _function = new Functions.Function1<Ueberhoehungslinie, PlazError>(){

            public PlazError apply(Ueberhoehungslinie it) {
                double _bankLineTopOffsetLimit;
                boolean _greaterThan;
                BigDecimal pathLength;
                BankService.BankingInformation bankinfo = BankValues.this.bankService.findTOPBanking(it);
                if (bankinfo == null) {
                    Identitaet_TypeClass _identitaet = it.getIdentitaet();
                    String _wert = null;
                    if (_identitaet != null) {
                        _wert = _identitaet.getWert();
                    }
                    return BankValues.this.createError(it, "Es konnte kein topologischer Pfad f\u00fcr die \u00dcberh\u00f6hungslinie {GUID} gefunden werden.", Map.of("GUID", _wert));
                }
                BigDecimal bankLength = bankinfo.line().getUeberhoehungslinieAllg().getUeberhoehungslinieLaenge().getWert();
                double diff = bankLength.subtract(pathLength = bankinfo.path().length()).doubleValue();
                boolean bl = _greaterThan = diff > (_bankLineTopOffsetLimit = ToolboxConfiguration.getBankLineTopOffsetLimit());
                if (_greaterThan) {
                    Identitaet_TypeClass _identitaet_1 = it.getIdentitaet();
                    String _wert_1 = null;
                    if (_identitaet_1 != null) {
                        _wert_1 = _identitaet_1.getWert();
                    }
                    return BankValues.this.createError(it, "Die L\u00e4nge des topologischen Pfads ({PFAD}) f\u00fcr die \u00dcberh\u00f6hungslinie {GUID} weicht von der L\u00e4nge der \u00dcberh\u00f6hungslinie ({UEBERHOEHUNG}) ab.", Map.of("GUID", _wert_1, "PFAD", pathLength.toString(), "UEBERHOEHUNG", bankLength.toString()));
                }
                return null;
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)container.getUeberhoehungslinie(), (Functions.Function1)_function)));
    }

    private PlazError createError(Ueberhoehungslinie object, String message, Map<String, String> data) {
        PlazError err = PlazFactory.eINSTANCE.createPlazError();
        err.setMessage(StringSubstitutor.replace((Object)message, data, (String)"{", (String)"}"));
        err.setType(this.checkType());
        Identitaet_TypeClass _identitaet = null;
        if (object != null) {
            _identitaet = object.getIdentitaet();
        }
        err.setObject((EObject)_identitaet);
        return err;
    }

    @Override
    public String checkType() {
        return "\u00dcberh\u00f6hungslinie";
    }

    @Override
    public String getDescription() {
        return "Topologische Pfade konnten f\u00fcr \u00dcberh\u00f6hungslinien gefunden werden.";
    }

    @Override
    public String getGeneralErrMsg() {
        return "Es gibt \u00dcberh\u00f6hungslinien mit fehlerhaften topologischen Pfaden.";
    }
}

