/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel.check;

import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.feature.plazmodel.check.AbstractPlazContainerCheck;
import org.eclipse.set.feature.plazmodel.check.PlazCheck;
import org.eclipse.set.model.plazmodel.PlazError;
import org.eclipse.set.model.plazmodel.PlazFactory;
import org.eclipse.set.model.validationreport.ValidationSeverity;
import org.eclipse.set.ppmodel.extensions.BereichObjektExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.toolboxmodel.Basisobjekte.Begrenzung_A_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Begrenzung_B_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Bereich_Objekt_Teilbereich_AttributeGroup;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante_Allg_AttributeGroup;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Laenge_TypeClass;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.osgi.service.component.annotations.Component;

@Component
public class TeilbereichTOPKanteLength
extends AbstractPlazContainerCheck
implements PlazCheck {
    @Override
    public List<PlazError> run(MultiContainer_AttributeGroup container) {
        Functions.Function1<Bereich_Objekt_Teilbereich_AttributeGroup, PlazError> _function = new Functions.Function1<Bereich_Objekt_Teilbereich_AttributeGroup, PlazError>(){

            public PlazError apply(Bereich_Objekt_Teilbereich_AttributeGroup it) {
                Begrenzung_A_TypeClass _begrenzungA = null;
                if (it != null) {
                    _begrenzungA = it.getBegrenzungA();
                }
                BigDecimal _wert = null;
                if (_begrenzungA != null) {
                    _wert = _begrenzungA.getWert();
                }
                BigDecimal limitA = _wert;
                Begrenzung_B_TypeClass _begrenzungB = null;
                if (it != null) {
                    _begrenzungB = it.getBegrenzungB();
                }
                BigDecimal _wert_1 = null;
                if (_begrenzungB != null) {
                    _wert_1 = _begrenzungB.getWert();
                }
                BigDecimal limitB = _wert_1;
                TOP_Kante _topKante = BereichObjektExtensions.getTopKante((Bereich_Objekt_Teilbereich_AttributeGroup)it);
                TOP_Kante_Allg_AttributeGroup _tOPKanteAllg = null;
                if (_topKante != null) {
                    _tOPKanteAllg = _topKante.getTOPKanteAllg();
                }
                TOP_Laenge_TypeClass _tOPLaenge = null;
                if (_tOPKanteAllg != null) {
                    _tOPLaenge = _tOPKanteAllg.getTOPLaenge();
                }
                BigDecimal _wert_2 = null;
                if (_tOPLaenge != null) {
                    _wert_2 = _tOPLaenge.getWert();
                }
                BigDecimal topLength = _wert_2;
                if (limitA == null || limitB == null || topLength == null) {
                    return null;
                }
                double length = limitA.subtract(limitB).abs().doubleValue();
                if (length >= 0.1) {
                    return null;
                }
                PlazError err = PlazFactory.eINSTANCE.createPlazError();
                StringConcatenation _builder = new StringConcatenation();
                String _generalErrMsg = TeilbereichTOPKanteLength.this.getGeneralErrMsg();
                _builder.append(_generalErrMsg);
                _builder.append(" Die L\u00e4nge des Teilbereichs ist ");
                _builder.append((Object)length);
                _builder.append(" m.");
                err.setMessage(_builder.toString());
                err.setType(TeilbereichTOPKanteLength.this.checkType());
                err.setObject((EObject)it);
                err.setSeverity(ValidationSeverity.WARNING);
                return err;
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)container.getAllContents(), Bereich_Objekt_Teilbereich_AttributeGroup.class), (Functions.Function1)_function)));
    }

    @Override
    public String checkType() {
        return "Teilbereichsl\u00e4nge";
    }

    @Override
    public String getDescription() {
        return "Teilbereichsl\u00e4ngen der LST-Objekte sind g\u00fcltig.";
    }

    @Override
    public String getGeneralErrMsg() {
        return "Sehr kleine Teilbereichsl\u00e4nge (<0.1 m).";
    }
}

